/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaModel;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.BalticValidator;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.SchemaValidator;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SchemaValidatorUpgrader
implements UpgradePipelineElement {
    private Document balticValidation(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        BalticValidator validator = new BalticValidator();
        return validator.upgrade(origSpec, upgradeSession);
    }

    private Document schemaModelValidation(Document origSpec, SchemaModel model, UpgradeSessionContext upgradeSession) throws UpgradeException {
        SchemaValidator validator = new SchemaValidator(upgradeSession.getConfiguration(), model, upgradeSession.getLog());
        Document validDoc = validator.validateAndFix(origSpec);
        return validDoc;
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element root = XmlUtils.getRoot(origSpec);
        String ns = root.getNamespaceURI();
        if ("http://developer.cognos.com/schemas/report/1/".equals(ns)) {
            return this.balticValidation(origSpec, upgradeSession);
        }
        SchemaModel schemaModel = upgradeSession.getReportSpecificationSchemaModel(ns);
        if (schemaModel != null) {
            return this.schemaModelValidation(origSpec, schemaModel, upgradeSession);
        }
        return origSpec;
    }
}

