/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools;

import com.cognos.rspecupgrade.tools.Utils;

public class SchemaVersionUtils {
    private static final String namespacePrefix = "http://developer.cognos.com/schemas/report/";

    public static String getNamespaceFromVersion(String version) {
        return SchemaVersionUtils.getNamespaceFromVersion(version, null);
    }

    public static String getNamespaceFromVersion(String version, String suffix) {
        StringBuilder sb = new StringBuilder();
        if (version != null && !version.isEmpty() && version.matches("\\d*\\.?\\d+")) {
            sb.append(namespacePrefix);
            sb.append(version);
            sb.append("/");
            if (suffix != null && !suffix.isEmpty()) {
                sb.append(suffix);
            }
        }
        return sb.toString();
    }

    public static String getVersionFromNamespace(String namespace) {
        String nameSpacePrefixRemoved;
        String result = "";
        if (namespace.startsWith(namespacePrefix) && (nameSpacePrefixRemoved = namespace.replaceAll(namespacePrefix, "")).indexOf("/") != -1 && !(result = nameSpacePrefixRemoved.substring(0, nameSpacePrefixRemoved.indexOf("/"))).matches("\\d*\\.?\\d+")) {
            result = "";
        }
        return result;
    }

    public static boolean isCompatibleNamespace(String lastCompatibleNamespace, String sourceNamespace) {
        boolean bRet = false;
        if (Utils.hasString(lastCompatibleNamespace) && Utils.hasString(sourceNamespace)) {
            float fLastCompatibleSchemaVersion = Float.valueOf(SchemaVersionUtils.getVersionFromNamespace(lastCompatibleNamespace)).floatValue();
            float fSourceVersion = Float.valueOf(SchemaVersionUtils.getVersionFromNamespace(sourceNamespace)).floatValue();
            if (fSourceVersion <= fLastCompatibleSchemaVersion) {
                bRet = true;
            } else if ((double)(fSourceVersion - fLastCompatibleSchemaVersion) < 1.0) {
                bRet = true;
            }
        }
        return bRet;
    }

    public static String getSchemaRelativePathfromVersion(String version) {
        return "rspec/" + version + "/V5_report_one.xsd";
    }
}

