/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.DomWalker;
import com.cognos.rspecupgrade.internal.xml.XmlCommentOutTool;
import com.cognos.rspecupgrade.internal.xml.XmlComparer;
import com.cognos.rspecupgrade.internal.xml.XmlDeleteTool;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.MessageTemplate;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Messages;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification50;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.IUpgradeNotes;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class UpgradeNotes
implements XmlComparer.CompareListener,
XmlDeleteTool.DeleteListener,
XmlCommentOutTool.CommentOutListener,
IUpgradeNotes {
    int lastMessageId = 0;
    final Messages translatedMessages;

    public UpgradeNotes(Messages translatedMessages) {
        this.translatedMessages = translatedMessages;
    }

    private boolean isMessageXmlAttribute(Element xmlAttribute) {
        String name = xmlAttribute.getAttribute(ReportSpecification50._name);
        boolean isMessage = "RS_upgradeMessageIndex".equals(name);
        return isMessage;
    }

    private boolean areMessageXmlAttributes(Element xmlAttributes) {
        NodeList xmlAttributeList = XmlUtils.getChildElements(xmlAttributes);
        int nbAttributes = xmlAttributeList.getLength();
        for (int i = 0; i < nbAttributes; ++i) {
            Element xmlAttribute = (Element)xmlAttributeList.item(i);
            if (this.isMessageXmlAttribute(xmlAttribute)) continue;
            return false;
        }
        return true;
    }

    private String getMessageSeverity(int severity) {
        switch (severity) {
            case 2: {
                return ReportSpecification50._info;
            }
            case 1: {
                return ReportSpecification50._warning;
            }
        }
        return ReportSpecification50._error;
    }

    private int getMessageSeverity(String type) {
        if (ReportSpecification50._info.equals(type)) {
            return 2;
        }
        if (ReportSpecification50._warning.equals(type)) {
            return 1;
        }
        return 0;
    }

    private boolean isErrorMessage(Element upgradeMessage) {
        String severity = upgradeMessage.getAttribute(ReportSpecification50._type);
        return ReportSpecification50._error.equals(severity);
    }

    Set<String> getMessageIds(NodeList xmlAttributeElements) {
        HashSet<String> ids = new HashSet<String>();
        int nbAttributes = xmlAttributeElements.getLength();
        for (int i = 0; i < nbAttributes; ++i) {
            Element xmlAttribute = (Element)xmlAttributeElements.item(i);
            String attributeName = xmlAttribute.getAttribute(ReportSpecification50._name);
            if (!"RS_upgradeMessageIndex".equals(attributeName)) continue;
            String attributeValue = xmlAttribute.getAttribute(ReportSpecification50._value);
            ids.add(attributeValue);
        }
        return ids;
    }

    Set<String> getMessageIds(Element recipient) {
        Element xmlAttributes = XmlUtils.getFirstChildElementByName(recipient, ReportSpecification50._XMLAttributes);
        NodeList xmlAttributeList = xmlAttributes != null ? XmlUtils.getChildElementsByName(xmlAttributes, ReportSpecification50._XMLAttribute) : XmlUtils.getChildElementsByName(recipient, ReportSpecification50._XMLAttribute);
        return this.getMessageIds(xmlAttributeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LinkedList<Element> getMessageElements(Element recipient) throws UpgradeException {
        LinkedList<Element> resultCollection = new LinkedList<Element>();
        Set<String> messageIds = this.getMessageIds(recipient);
        Document doc = recipient.getOwnerDocument();
        Element upgradeMessagesElement = UpgradeNotes.getUpgradeMessagesElement(doc);
        if (upgradeMessagesElement == null) {
            return resultCollection;
        }
        NoteFinder collector = new NoteFinder(messageIds, resultCollection);
        try {
            DomWalker.walkChildrenElements(upgradeMessagesElement, collector);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
        }
        return resultCollection;
    }

    private Element getNoteLocation(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof Element) {
            return (Element)node;
        }
        if (node instanceof Document) {
            return XmlUtils.getRoot((Document)node);
        }
        return XmlUtils.getAncestorElement(node);
    }

    boolean doesMessageDefine(Element upgradeMessage, String severity, String msgText) {
        String type = upgradeMessage.getAttribute(ReportSpecification50._type);
        if (!severity.equals(type)) {
            return false;
        }
        String text = XmlUtils.getText(upgradeMessage);
        return msgText.equals(text);
    }

    boolean messageAlreadyExists(Element recipient, int msgSeverity, String msgText) throws UpgradeException {
        String severity = this.getMessageSeverity(msgSeverity);
        LinkedList<Element> messages = this.getMessageElements(recipient);
        for (Element upgradeMessage : messages) {
            if (!this.doesMessageDefine(upgradeMessage, severity, msgText)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addUpgradeNote(Node recipientNode, int msgSeverity, MessageTemplate messageTemplate) throws UpgradeException {
        this.addUpgradeNote(recipientNode, msgSeverity, messageTemplate, false);
    }

    @Override
    public void addUpgradeNote(Node recipientNode, int msgSeverity, MessageTemplate messageTemplate, boolean addComment) throws UpgradeException {
        String msgText = this.translatedMessages.getString(messageTemplate);
        this.addUpgradeNote(recipientNode, msgSeverity, msgText, addComment);
    }

    @Override
    public void addUpgradeNote(Node recipientNode, int msgSeverity, String msgText) throws UpgradeException {
        this.addUpgradeNote(recipientNode, msgSeverity, msgText, false);
    }

    private void addUpgradeNote(Node recipientNode, int msgSeverity, String msgText, boolean addComment) throws UpgradeException {
        if (recipientNode == null) {
            throw new NullPointerException("recipient null may not be null since we need to document to store the error message.");
        }
        Element recipient = this.getNoteLocation(recipientNode);
        if (!this.messageAlreadyExists(recipient, msgSeverity, msgText)) {
            String messageId = Integer.toString(++this.lastMessageId);
            if (recipient != null) {
                Element xmlAttributes = XmlUtils.getOrCreateChildElementByName(recipient, ReportSpecification50._XMLAttributes);
                Element xmlAttribute = XmlUtils.createChildElement(xmlAttributes, ReportSpecification50._XMLAttribute);
                xmlAttribute.setAttribute(ReportSpecification50._name, "RS_upgradeMessageIndex");
                xmlAttribute.setAttribute(ReportSpecification50._value, messageId);
            }
            Document doc = recipient.getOwnerDocument();
            Element upgradeNotes = this.getOrCreateUpgradeMessagesElement(doc);
            Element messageElement = XmlUtils.createElement(doc, ReportSpecification50._upgradeMessage);
            messageElement.setAttribute(ReportSpecification50._messageId, messageId);
            messageElement.setAttribute(ReportSpecification50._type, this.getMessageSeverity(msgSeverity));
            Text messageText = doc.createTextNode(msgText);
            messageElement.appendChild(messageText);
            upgradeNotes.appendChild(messageElement);
            if (addComment) {
                XmlUtils.insertComment(recipientNode, msgText);
            }
        }
    }

    @Override
    public boolean containsErrorMessages(Element recipient) throws UpgradeException {
        LinkedList<Element> messageElements = this.getMessageElements(recipient);
        for (Element upgradeMessage : messageElements) {
            if (!this.isErrorMessage(upgradeMessage)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void downgradeErrorsToWarnings(Element recipient) throws UpgradeException {
        LinkedList<Element> messageElements = this.getMessageElements(recipient);
        for (Element upgradeMessage : messageElements) {
            if (!this.isErrorMessage(upgradeMessage)) continue;
            upgradeMessage.setAttribute(ReportSpecification50._type, ReportSpecification50._warning);
        }
    }

    void removeMessageXmlAttributes(Element container) {
        Element xmlAttributes = XmlUtils.getFirstChildElementByName(container, ReportSpecification50._XMLAttributes);
        if (xmlAttributes == null) {
            return;
        }
        NodeList xmlAttributeList = XmlUtils.getChildElementsByName(xmlAttributes, ReportSpecification50._XMLAttribute);
        int nbAttributes = xmlAttributeList.getLength();
        for (int i = 0; i < nbAttributes; ++i) {
            Element xmlAttribute = (Element)xmlAttributeList.item(i);
            if (!this.isMessageXmlAttribute(xmlAttribute)) continue;
            xmlAttribute.getParentNode().removeChild(xmlAttribute);
        }
        if (xmlAttributes.getFirstChild() == null) {
            container.removeChild(xmlAttributes);
        }
    }

    private void removeMessages(Set<String> ids, Document doc) {
        Element upgradeMessages = UpgradeNotes.getUpgradeMessagesElement(doc);
        if (upgradeMessages == null) {
            return;
        }
        NodeList upgradeMessageList = XmlUtils.getChildElementsByName(upgradeMessages, ReportSpecification50._upgradeMessage);
        int nbMessages = upgradeMessageList.getLength();
        for (int i = 0; i < nbMessages; ++i) {
            Element upgradeMessage = (Element)upgradeMessageList.item(i);
            String messageId = upgradeMessage.getAttribute(ReportSpecification50._messageId);
            if (!ids.contains(messageId)) continue;
            upgradeMessages.removeChild(upgradeMessage);
        }
        if (XmlUtils.getFirstChildElementByName(upgradeMessages, ReportSpecification50._upgradeMessage) == null) {
            upgradeMessages.getParentNode().removeChild(upgradeMessages);
        }
    }

    @Override
    public void removeUpgradeNote(Element context) throws UpgradeException {
        Document doc = context.getOwnerDocument();
        Set<String> messageIds = this.getMessageIds(context);
        this.removeMessages(messageIds, doc);
        this.removeMessageXmlAttributes(context);
    }

    private static Element getUpgradeMessagesElement(Document doc) {
        Element report = XmlUtils.getFirstChildElementByName(doc, ReportSpecification50._report);
        if (report == null) {
            return null;
        }
        Element upgradeInfo = XmlUtils.getFirstChildElementByName(report, ReportSpecification50._upgradeInfo);
        if (upgradeInfo == null) {
            return null;
        }
        Element upgradeMessages = XmlUtils.getFirstChildElementByName(upgradeInfo, ReportSpecification50._upgradeMessages);
        return upgradeMessages;
    }

    private Element getOrCreateUpgradeMessagesElement(Document doc) {
        Element rootElement = XmlUtils.getRoot(doc);
        Element upgradeInfoElement = XmlUtils.getOrCreateChildElementByName(rootElement, ReportSpecification50._upgradeInfo);
        Element upgradeMessagesElement = XmlUtils.getOrCreateChildElementByName(upgradeInfoElement, ReportSpecification50._upgradeMessages);
        return upgradeMessagesElement;
    }

    Element getMessageElement(String id, Document doc) {
        Element upgradeMessages = UpgradeNotes.getUpgradeMessagesElement(doc);
        if (upgradeMessages == null) {
            return null;
        }
        Element upgradeMessage = XmlUtils.getFirstChildElementByNameWithAttributeValue(upgradeMessages, ReportSpecification50._upgradeMessage, ReportSpecification50._messageId, id);
        return upgradeMessage;
    }

    @Override
    public boolean useNode(Node node) {
        Element elem;
        String name;
        return !(node instanceof Element) || !((name = XmlUtils.getName(elem = (Element)node)).equals(ReportSpecification50._XMLAttribute) ? this.isMessageXmlAttribute(elem) : name.equals(ReportSpecification50._XMLAttributes) && this.areMessageXmlAttributes(elem));
    }

    boolean isMessageAlreadyDefined(Element location, String severity, String msgText) throws UpgradeException {
        LinkedList<Element> messages = this.getMessageElements(location);
        for (Element message : messages) {
            if (!this.doesMessageDefine(message, severity, msgText)) continue;
            return true;
        }
        return false;
    }

    boolean isMessageAlreadyDefined(Element location, Element message) throws UpgradeException {
        String severity = message.getAttribute(ReportSpecification50._type);
        String msgText = XmlUtils.getText(message);
        return this.isMessageAlreadyDefined(location, severity, msgText);
    }

    void moveXmlAttribute(Element newLocation, Element xmlAttribute) throws UpgradeException {
        String messageId = xmlAttribute.getAttribute(ReportSpecification50._value);
        Element message = this.getMessageElement(messageId, newLocation.getOwnerDocument());
        if (message == null) {
            throw new UpgradeException("Internal error message with id " + messageId + " not found.");
        }
        if (this.isMessageAlreadyDefined(newLocation, message)) {
            XmlUtils.delete(xmlAttribute);
            XmlUtils.delete(message);
        } else {
            Element xmlAttributes = XmlUtils.getOrCreateChildElementByName(newLocation, ReportSpecification50._XMLAttributes);
            xmlAttributes.appendChild(xmlAttribute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveMessages(Element source, final Element destination) throws UpgradeException {
        try {
            Element sourceXmlAttributes = XmlUtils.getFirstChildElementByName(source, ReportSpecification50._XMLAttributes);
            if (sourceXmlAttributes != null) {
                DomWalker.walkChildrenElements(sourceXmlAttributes, new DomWalker.Examiner(){

                    @Override
                    public DomWalker.SearchOrder examine(Element elem) throws XmlException {
                        String xmlAttributeName;
                        String name = XmlUtils.getName(elem);
                        if (name.equals(ReportSpecification50._XMLAttribute) && (xmlAttributeName = elem.getAttribute(ReportSpecification50._name)).equals("RS_upgradeMessageIndex")) {
                            try {
                                UpgradeNotes.this.moveXmlAttribute(destination, elem);
                            }
                            catch (UpgradeException e) {
                                XmlException.throwNestedException(e);
                            }
                        }
                        return DomWalker.SearchOrder.proceed;
                    }
                });
                if (XmlUtils.getChildElements(sourceXmlAttributes).getLength() == 0) {
                    XmlUtils.delete(sourceXmlAttributes);
                }
            }
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
        }
    }

    private void hoistMessages(Node sourceNode) throws XmlException {
        if (!(sourceNode instanceof Element)) {
            return;
        }
        final Element parent = XmlUtils.getAncestorElement(sourceNode);
        if (parent == null) {
            return;
        }
        Element sourceElement = (Element)sourceNode;
        DomWalker.topDownWalkElements(sourceElement, new DomWalker.Examiner(){

            @Override
            public DomWalker.SearchOrder examine(Element elem) throws XmlException {
                try {
                    UpgradeNotes.this.moveMessages(elem, parent);
                    return DomWalker.SearchOrder.proceed;
                }
                catch (UpgradeException e) {
                    throw new XmlException(e);
                }
            }
        });
    }

    @Override
    public void deleteNodeNotification(Node deletedNode) throws XmlException {
        this.hoistMessages(deletedNode);
    }

    @Override
    public void commentedOutNotification(Node node) throws XmlException {
        this.hoistMessages(node);
    }

    private Set<String> getUsedMessageIds(Document origSpec) {
        HashSet<String> ids = new HashSet<String>();
        NodeList xmlAttributeList = origSpec.getElementsByTagName(ReportSpecification50._XMLAttribute);
        int nbAttributes = xmlAttributeList.getLength();
        for (int i = 0; i < nbAttributes; ++i) {
            Element xmlAttribute = (Element)xmlAttributeList.item(i);
            if (!this.isMessageXmlAttribute(xmlAttribute)) continue;
            String id = xmlAttribute.getAttribute(ReportSpecification50._value);
            ids.add(id);
        }
        return ids;
    }

    @Override
    public int getMaximumSeverity(Document doc) {
        Element upgradeMessages = UpgradeNotes.getUpgradeMessagesElement(doc);
        if (upgradeMessages == null) {
            return 3;
        }
        NodeList upgradeMessageList = XmlUtils.getChildElementsByName(upgradeMessages, ReportSpecification50._upgradeMessage);
        int mostSevere = 3;
        int nbMessages = upgradeMessageList.getLength();
        for (int i = 0; i < nbMessages; ++i) {
            Element upgradeMessage = (Element)upgradeMessageList.item(i);
            String type = upgradeMessage.getAttribute(ReportSpecification50._type);
            int severity = this.getMessageSeverity(type);
            if (severity >= mostSevere) continue;
            mostSevere = severity;
        }
        return mostSevere;
    }

    public static class RemoveUnusedMessageIds
    implements UpgradePipelineElement {
        @Override
        public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
            Element upgradeMessages = UpgradeNotes.getUpgradeMessagesElement(origSpec);
            if (upgradeMessages == null) {
                return origSpec;
            }
            Set usedIds = ((UpgradeNotes)upgradeSession.getUpgradeNotes()).getUsedMessageIds(origSpec);
            NodeList upgradeMessageList = XmlUtils.getChildElementsByName(upgradeMessages, ReportSpecification50._upgradeMessage);
            int nbMessages = upgradeMessageList.getLength();
            for (int i = 0; i < nbMessages; ++i) {
                String id;
                Element upgradeMessage = (Element)upgradeMessageList.item(i);
                if (!upgradeMessage.hasAttribute(ReportSpecification50._messageId) || usedIds.contains(id = upgradeMessage.getAttribute(ReportSpecification50._messageId))) continue;
                upgradeMessage.removeAttribute(ReportSpecification50._messageId);
            }
            return origSpec;
        }
    }

    private static class NoteFinder
    implements DomWalker.Examiner {
        AbstractCollection<Element> notes;
        private Set<String> noteIds;

        NoteFinder(Set<String> ids, AbstractCollection<Element> noteCollection) {
            this.noteIds = ids;
            this.notes = noteCollection;
        }

        @Override
        public DomWalker.SearchOrder examine(Element elem) throws XmlException {
            String id = elem.getAttribute(ReportSpecification50._messageId);
            if (this.noteIds.contains(id)) {
                this.notes.add(elem);
            }
            return DomWalker.SearchOrder.proceed;
        }
    }
}

