/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools;

import com.cognos.rspecupgrade.internal.io.IOException;
import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.XmlChecksumGeneratorImpl;
import com.cognos.rspecupgrade.internal.xml.XmlChecksumUtils;
import com.cognos.rspecupgrade.internal.xml.XmlChecksumValidator;
import com.cognos.rspecupgrade.internal.xml.XmlChecksumValidatorImpl;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaModel;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Messages;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.MessagesImpl;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import java.io.File;
import org.w3c.dom.Document;

public class ValidateChecksumMain {
    private static final int EXIT_CODE_SUCCESS = 0;
    private static final int EXIT_CODE_UNKNOWN_FAILURE = 1;
    private static final int EXIT_CODE_BAD_INPUT_FILE = 2;
    private File inputSpecFile = null;
    private Messages messages = new MessagesImpl();

    private boolean validate(Document origSpec, XmlChecksumValidator validator) throws Exception {
        boolean result = false;
        if (validator == null) {
            throw new Exception(this.messages.getString(RspecUpgradeMessage.RSU_CHK_CHKSUM_VALIDATOR_NULL()));
        }
        try {
            XmlChecksumGeneratorImpl generator = new XmlChecksumGeneratorImpl();
            SchemaModel schema = XmlUtils.getSchema(origSpec, this.messages);
            String expectedChecksum = null;
            expectedChecksum = XmlChecksumUtils.getChecksumStringFromXmlDoc(origSpec, this.messages);
            result = validator.validateChecksum(origSpec, expectedChecksum, generator, this.messages, schema);
            return result;
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
            return false;
        }
    }

    private void help() {
        System.out.println(this.messages.getString(RspecUpgradeMessage.RSU_CHK_CHKSUM_VALIDATOR_HELP()));
    }

    private int processOptions(String[] args) throws Exception {
        if (args != null) {
            for (int arg = 0; arg < args.length && args[arg].equals("-i"); ++arg) {
                if (++arg >= args.length) {
                    return 2;
                }
                this.inputSpecFile = new File(args[arg]);
            }
            if (!this.inputSpecFile.isFile()) {
                String output = this.messages.getString(RspecUpgradeMessage.RSU_UPG_ORIGINAL_REPORT_FILE_NOT_READABLE(this.inputSpecFile.getCanonicalPath()));
                System.out.println(output);
                return 2;
            }
            return 0;
        }
        return 2;
    }

    int execute(String[] args, XmlChecksumValidator validator) {
        try {
            int rc = this.processOptions(args);
            if (rc != 0) {
                this.help();
                return rc;
            }
            Document inputSpecDoc = null;
            try {
                inputSpecDoc = XmlUtils.readDocument(this.inputSpecFile);
            }
            catch (IOException ex) {
                String error = this.messages.getString(RspecUpgradeMessage.RSU_CHK_CHKSUM_INVALID_FILE(this.inputSpecFile.getAbsolutePath()));
                System.out.println(error);
                return 2;
            }
            boolean result = this.validate(inputSpecDoc, validator);
            String msg = null;
            msg = result ? this.messages.getString(RspecUpgradeMessage.RSU_CHK_CHKSUM_VALIDATION_PASSED()) : this.messages.getString(RspecUpgradeMessage.RSU_CHK_CHKSUM_VALIDATION_FAILED());
            System.out.println(msg);
            return 0;
        }
        catch (Exception ex) {
            System.out.println(ex.getLocalizedMessage());
            return 1;
        }
    }

    public static void main(String[] args) {
        ValidateChecksumMain main = new ValidateChecksumMain();
        XmlChecksumValidatorImpl validator = new XmlChecksumValidatorImpl();
        int rc = main.execute(args, validator);
        System.exit(rc);
    }
}

