/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools;

import com.cognos.rspecupgrade.internal.io.XslTransformerImpl;
import com.cognos.rspecupgrade.rsupgrade.internal.configuration.IConfiguration;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Log;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Messages;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import java.io.File;
import java.util.LinkedList;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;

public class XslPlugin {
    private Log log;
    private Messages messages;
    private IConfiguration config;

    public XslPlugin(Log log, Messages messages, IConfiguration config) {
        this.log = log;
        this.messages = messages;
        this.config = config;
    }

    public Document preprocess(Document doc) {
        String[] scriptNames = this.config.getPluginPreprocess();
        Document result = this.executeScripts(doc, scriptNames);
        return result;
    }

    public Document postprocess(Document doc) {
        String[] scriptNames = this.config.getPluginPostprocess();
        Document result = this.executeScripts(doc, scriptNames);
        return result;
    }

    private Document executeScripts(Document doc, String[] scriptNames) {
        try {
            if (scriptNames.length == 0) {
                return doc;
            }
            LinkedList<File> scripts = new LinkedList<File>();
            for (int i = 0; i < scriptNames.length; ++i) {
                File scriptFile = new File(scriptNames[i]);
                if (!scriptFile.exists()) {
                    this.log.error(RspecUpgradeMessage.RSU_SPC_ERROR_XSL_PLUGIN_MISSING(scriptFile.getPath()));
                    return doc;
                }
                if (!scriptFile.isFile()) {
                    this.log.error(RspecUpgradeMessage.RSU_SPC_ERROR_XSL_PLUGIN_MISSING(scriptFile.getPath()));
                    return doc;
                }
                scripts.add(scriptFile);
            }
            for (File scriptFile : scripts) {
                String msg = this.messages.getString(RspecUpgradeMessage.RSU_SPC_XSL_PLUGIN_EXECUTED(scriptFile.getPath()));
                Comment comment = doc.createComment(msg);
                doc.appendChild(comment);
            }
            Document modifiedDoc = XslTransformerImpl.pipelineXsltTransformationFiles(doc, scripts, this.config);
            if (modifiedDoc == null) {
                this.log.error(RspecUpgradeMessage.RSU_SPC_ERROR_XSL_PLUGIN_FAILED());
                return doc;
            }
            return modifiedDoc;
        }
        catch (Exception ex) {
            this.log.error(RspecUpgradeMessage.RSU_SPC_ERROR_XSL_PLUGIN_FAILED_1(ex.getLocalizedMessage()));
            return doc;
        }
    }
}

