<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<!--
*
*  Intermediate stage in upgrading from a baltic report specification
*  to a bering report specification.
*
*  The input is a baltic report specification.  The output is an 
*  augmented baltic report specification that is only used as input for
*  further processing to get to the final bering specification.
-->
<xsl:stylesheet version="1.0" xmlns="http://developer.cognos.com/schemas/report/1/" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl">
	<!-- For charts add chartMeasure and chartLevel elements if they do not 
   * have them.
  -->
	<xsl:template match="baltic:chart">
		<chart>
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="child::node()"/>
			<xsl:if test="not(baltic:chartMeasure)">
				<xsl:for-each select="/baltic:report/baltic:querySet/baltic:BIQuery[@name = current()/@refQuery]/baltic:summary/baltic:dataCells/baltic:item">
					<chartMeasure>
						<chartText>
							<queryItemRef>
								<xsl:attribute name="refItem"><xsl:value-of select="@refItem"/></xsl:attribute>
								<xsl:attribute name="content">label</xsl:attribute>
							</queryItemRef>
						</chartText>
						<member>
							<xsl:attribute name="refMember"><xsl:value-of select="@refItem"/></xsl:attribute>
						</member>
					</chartMeasure>
				</xsl:for-each>
			</xsl:if>
			<xsl:if test="not(baltic:chartLevel)">
				<xsl:for-each select="/baltic:report/baltic:querySet/baltic:BIQuery[@name = current()/@refQuery]/baltic:summary/baltic:columnEdge/baltic:level | /baltic:report/baltic:querySet/baltic:BIQuery[@name = current()/@refQuery]/baltic:summary/baltic:rowEdge/baltic:level">
					<chartLevel>
						<xsl:attribute name="refLevel"><xsl:value-of select="@refLevel"/></xsl:attribute>
						<queryItemRef>
							<xsl:attribute name="refItem"><xsl:value-of select="baltic:item/@refItem"/></xsl:attribute>
						</queryItemRef>
						<chartText>
							<queryItemRef>
								<xsl:attribute name="refItem"><xsl:value-of select="baltic:item/@refItem"/></xsl:attribute>
								<xsl:attribute name="content">label</xsl:attribute>
							</queryItemRef>
						</chartText>
					</chartLevel>
				</xsl:for-each>
			</xsl:if>
		</chart>
	</xsl:template>
</xsl:stylesheet>
