<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl">
	<xsl:template name="bubbleChartTemplate">
		<bubbleChart showBorders="true">
			<xsl:call-template name="chartMarkerTemplate">
				<xsl:with-param name="p_chart" select="baltic:bubbleChart"/>
				<xsl:with-param name="p_addDataPointSize" select="'false'"/>
			</xsl:call-template>
			<xsl:call-template name="standardChartAttributesTemplate"/>
			<xsl:call-template name="bubbleChartShowValuesTemplate"/>
			<xsl:call-template name="generateMasterDetailLinks2">
				<xsl:with-param name="p_frame" select="."/>
			</xsl:call-template>
			<xsl:call-template name="legendTemplate"/>
			<xsl:call-template name="axisBubbleScatterTemplate"/>
			<xsl:call-template name="pointsAndPointClustersTemplate"/>
			<bubbleMeasure refDataItem="{baltic:bubbleChart/baltic:sizeMeasure/@refMember}"/>
			<pointXMeasure refDataItem="{baltic:bubbleChart/baltic:xMeasure/@refMember}"/>
			<pointYMeasure refDataItem="{baltic:bubbleChart/baltic:yMeasure/@refMember}"/>
			<xsl:call-template name="commonChartTemplate"/>
			<xsl:call-template name="pointChartMarkerTemplate"/>
			<xsl:call-template name="commonPointChartBaselineTemplate">
				<xsl:with-param name="chartType" select="'bubbleChart'"/>
			</xsl:call-template>
		</bubbleChart>
	</xsl:template>
	<xsl:template name="axisBubbleScatterTemplate">
		<xsl:for-each select="baltic:axis">
			<xsl:variable name="v_axisPosition" select="@axisPosition"/>
			<xsl:choose>
				<xsl:when test="$v_axisPosition = 'X'">
					<numericalAxisX>
						<xsl:call-template name="copyAxisAttsTemplate"/>
						<xsl:call-template name="axisTitleTemplate"/>
						<xsl:call-template name="gridlinesTemplate">
							<xsl:with-param name="p_chart" select=".."/>
						</xsl:call-template>
						<xsl:call-template name="mergeStylesFromAxisAndAxisLabelsTemplate"/>
					</numericalAxisX>
				</xsl:when>
				<xsl:when test="$v_axisPosition = 'Y1'">
					<numericalAxisY>
						<xsl:call-template name="copyAxisAttsTemplate"/>
						<xsl:call-template name="axisTitleTemplate"/>
						<xsl:call-template name="gridlinesTemplate">
							<xsl:with-param name="p_chart" select=".."/>
						</xsl:call-template>
						<xsl:call-template name="mergeStylesFromAxisAndAxisLabelsTemplate"/>
					</numericalAxisY>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="bubbleChartShowValuesTemplate">
		<xsl:if test="*[contains(local-name(),'Chart')]/@showValues">
			<xsl:attribute name="showBubblePointValues">valuesAndLabels</xsl:attribute>
		</xsl:if>
		<xsl:if test="*[contains(local-name(),'Chart')]/@showLabels">
			<xsl:attribute name="showPointValuesForPoints">valuesOnly</xsl:attribute>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
