<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl">
	<xsl:template match="baltic:burst">
		<!-- 
			* Detailed mappings for burst upgrade:
			* 
			* burst -> burst
			* key/@refQuery -> burst/@refQuery
			* key/@refLevel -> burstGroup for each query level up to this one
			* key/@refItem -> burstLabel/@refDataItem
			* recipient -> burstRecipient
			* recipient/@refQuery -> burstRecipient/@refQuery
			* recipient/@refItem -> burstRecipient/@refDataItem
			* recipient/@type -> burstRecipient/@type
			-->
		<xsl:variable name="var_refQuery" select="baltic:key/@refQuery"/>
		<xsl:variable name="var_beringRefQuery">
			<xsl:call-template name="getQueryTemplate">
				<xsl:with-param name="refQuery" select="$var_refQuery"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="var_burstGroups">
			<!-- The structure of the V5 burstGroups is derived from the V4 Cube Dimension Levels. -->
			<xsl:apply-templates select="/baltic:report/baltic:querySet/baltic:BIQuery[@name=$var_refQuery]" mode="burst">
				<xsl:with-param name="p_refLevel" select="baltic:key/@refLevel"/>
			</xsl:apply-templates>
		</xsl:variable>
		<xsl:variable name="var_burstRecipient">
			<xsl:apply-templates select="baltic:recipient"/>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$var_burstGroups/node()[local-name()='burstGroup'] and $var_burstRecipient/node()[local-name()='burstRecipient']">
				<burst refQuery="{$var_beringRefQuery}">
					<burstGroups>
						<xsl:copy-of select="$var_burstGroups"/>
					</burstGroups>
					<xsl:copy-of select="$var_burstRecipient"/>
					<xsl:if test="count(baltic:key/@refItem) &gt; 0">
						<burstLabel refDataItem="{baltic:key/@refItem}"/>
					</xsl:if>
				</burst>
			</xsl:when>
			<xsl:otherwise>
				<xsl:comment>
					<xsl:call-template name="logError0">
						<xsl:with-param name="p_msgId" select="'RSU_SPC_INVALID_BURST_SPECIFICATION'"/>
					</xsl:call-template>
				</xsl:comment>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="baltic:recipient">
		<xsl:variable name="var_beringRefQuery">
			<xsl:call-template name="getQueryTemplate">
				<xsl:with-param name="refQuery" select="@refQuery"/>
			</xsl:call-template>
		</xsl:variable>
		<burstRecipient refQuery="{$var_beringRefQuery}" refDataItem="{@refItem}" type="{@type}"/>
	</xsl:template>
	<xsl:template match="/baltic:report/baltic:querySet/baltic:BIQuery" mode="burst">
		<xsl:param name="p_refLevel"/>
		<xsl:variable name="var_cube">
			<xsl:call-template name="getCubeOrCubeReference"/>
		</xsl:variable>
		<xsl:for-each select="$var_cube/baltic:cube/baltic:dimension/baltic:level[@name=$p_refLevel]/preceding-sibling::baltic:level">
			<xsl:apply-templates select="." mode="burst"/>
		</xsl:for-each>
		<xsl:apply-templates select="$var_cube/baltic:cube/baltic:dimension/baltic:level[@name=$p_refLevel]" mode="burst"/>
	</xsl:template>
	<xsl:template match="baltic:cube/baltic:dimension/baltic:level" mode="burst">
		<xsl:variable name="var_refLevel" select="@name"/>
		<xsl:variable name="v_refDataItem">
			<xsl:call-template name="getKeyItemNameForLevel"/>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$v_refDataItem='ERROR: Cannot find item or dataItem for the level referenced.'">
				<xsl:comment>
					<xsl:call-template name="logError2">
						<xsl:with-param name="p_msgId" select="'RSU_SPC_LEVEL_KEYITEM_MISSING'"/>
						<xsl:with-param name="p_param1" select="'burstGroup'"/>
						<xsl:with-param name="p_param2" select="$var_refLevel"/>
					</xsl:call-template>
				</xsl:comment>
			</xsl:when>
			<xsl:otherwise>
				<burstGroup refDataItem="{$v_refDataItem}">
					<!-- Generate sortList from the baltic:item sort attributes up to this level in the current dimension. -->
					<sortList>
						<xsl:apply-templates select="baltic:item" mode="generate_sortItems"/>
					</sortList>
				</burstGroup>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
