<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2012

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2012], 'RELEASE':['caspian', 'colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl">
	<xsl:template name="valueTypeTemplate">
		<xsl:param name="p_chart" select="."/>
		<xsl:param name="p_defaultValueType"/>
		<xsl:variable name="v_standardType" select="$p_chart/@standardType"/>
		<xsl:variable name="v_stackedValuesAbsolute" select="$p_chart/@stackedValuesAbsolute"/>
		<xsl:choose>
			<xsl:when test="$v_standardType = 'absolute' or $v_standardType = 'clustered' or $v_standardType = 'standard' or $v_standardType = '3DAxis'">
				<xsl:attribute name="valueType">absolute</xsl:attribute>
			</xsl:when>
			<xsl:when test="$v_standardType = 'stacked'">
				<xsl:attribute name="valueType">stacked</xsl:attribute>
			</xsl:when>
			<xsl:when test="$v_standardType = 'percent'">
				<xsl:attribute name="valueType">stacked100Percent</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="$p_defaultValueType != ''">
					<xsl:attribute name="valueType"><xsl:value-of select="$p_defaultValueType"/></xsl:attribute>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="$v_standardType = 'stacked' or $v_standardType = 'percent'">
				<xsl:attribute name="showAbsoluteValues"><xsl:choose><xsl:when test="$v_stackedValuesAbsolute = 'true' or not($v_stackedValuesAbsolute)">true</xsl:when><!-- Default in V4 was false, while V5 default is true --><xsl:otherwise>false</xsl:otherwise></xsl:choose></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="showAbsoluteValues">true</xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="legendTemplate">
		<xsl:choose>
			<xsl:when test="not(baltic:legend)"/>
			<xsl:when test="baltic:pieChart and not(baltic:chartLevel) and @columnEdgeIncluded='false'">
				<!-- Legends are not outputted if there are no series and if plot measures is series for a pie chart
                  *  @see trakker 542012.
                 -->
			</xsl:when>
			<xsl:when test="not(baltic:pieChart) and not(baltic:chartLevel) and @rowEdgeIncluded='false'">
				<!-- Legends are not outputted if there are no series and if plot measures is category for 
                  *  anything other than a pie chart.
                  *  @see trakker 542012.
                 -->
			</xsl:when>
			<xsl:otherwise>
				<legend>
					<xsl:call-template name="addStyle">
						<xsl:with-param name="for" select="'chartLegend'"/>
					</xsl:call-template>
					<!-- attributes -->
					<xsl:if test="baltic:legend/@allowFontReduction">
						<xsl:attribute name="autoFontResizing"><xsl:value-of select="baltic:legend/@allowFontReduction"/></xsl:attribute>
					</xsl:if>
					<xsl:if test="baltic:legend/baltic:itemTruncationText/baltic:text">
						<xsl:attribute name="truncationText"><xsl:value-of select="baltic:legend/baltic:itemTruncationText/baltic:text"/></xsl:attribute>
					</xsl:if>
					<xsl:if test="baltic:legend/@itemMaxCharacters">
						<xsl:attribute name="maxCharacters"><xsl:value-of select="baltic:legend/@itemMaxCharacters"/></xsl:attribute>
					</xsl:if>
					<xsl:if test="baltic:legend/@valueInLegend">
						<xsl:variable name="v_legendValue" select="baltic:legend/@valueInLegend"/>
						<xsl:choose>
							<xsl:when test="$v_legendValue = 'showMin'">
								<xsl:attribute name="showLegendValues">min</xsl:attribute>
							</xsl:when>
							<xsl:when test="$v_legendValue = 'showMax'">
								<xsl:attribute name="showLegendValues">max</xsl:attribute>
							</xsl:when>
							<xsl:when test="$v_legendValue = 'showFirst'">
								<xsl:attribute name="showLegendValues">first</xsl:attribute>
							</xsl:when>
							<xsl:when test="$v_legendValue = 'showLast'">
								<xsl:attribute name="showLegendValues">last</xsl:attribute>
							</xsl:when>
						</xsl:choose>
					</xsl:if>
					<xsl:choose>
						<xsl:when test="baltic:legend/@itemMaxCharacters">
							<xsl:attribute name="allowTruncation">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="baltic:legend/@itemEnableTruncation">
							<xsl:attribute name="allowTruncation"><xsl:value-of select="baltic:legend/@itemEnableTruncation"/></xsl:attribute>
						</xsl:when>
					</xsl:choose>
					<legendPosition>
						<relativePosition>
							<xsl:variable name="v_position" select="baltic:legend/@position"/>
							<xsl:if test="$v_position != ''">
								<xsl:attribute name="legendPosition"><xsl:value-of select="$v_position"/></xsl:attribute>
							</xsl:if>
						</relativePosition>
					</legendPosition>
					<xsl:call-template name="legendTitleTemplate"/>
					<xsl:apply-templates select="baltic:legend/baltic:background"/>
					<xsl:variable name="v_chart" select="*[contains(local-name(),'Chart')]"/>
					<xsl:variable name="v_chartType" select="local-name($v_chart)"/>
					<xsl:variable name="v_render">
						<xsl:choose>
							<xsl:when test="baltic:legend/@render = 'true'">true</xsl:when>
							<xsl:when test="baltic:legend/@render = 'false'">false</xsl:when>
							<xsl:when test="@rowEdgeIncluded = 'false' and count(baltic:chartMeasure) = 1 and ($v_chartType != 'pieChart')">false</xsl:when>
							<xsl:when test="@columnEdgeIncluded = 'false' and count(baltic:chartMeasure) = 1 and ($v_chartType = 'pieChart')">false</xsl:when>
							<xsl:otherwise>true</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					<xsl:variable name="v_addValue">
						<xsl:if test="$v_render = 'false'">visibility:hidden</xsl:if>
					</xsl:variable>
					<xsl:call-template name="simpleLayoutGroupTemplate">
						<xsl:with-param name="p_cur" select="baltic:legend"/>
						<xsl:with-param name="p_addValue" select="$v_addValue"/>
					</xsl:call-template>
				</legend>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="axisTemplate">
		<xsl:for-each select="baltic:axis">
			<xsl:variable name="v_axisPosition" select="@axisPosition"/>
			<xsl:choose>
				<xsl:when test="$v_axisPosition = 'X'">
					<xsl:call-template name="ordinalAxis">
						<xsl:with-param name="p_gridLines" select="0"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$v_axisPosition = 'Y1'">
					<numericalAxisY1>
						<xsl:call-template name="copyAxisAttsTemplate"/>
						<xsl:call-template name="axisTitleTemplate"/>
						<xsl:call-template name="gridlinesTemplate">
							<xsl:with-param name="p_chart" select=".."/>
						</xsl:call-template>
						<xsl:call-template name="mergeStylesFromAxisAndAxisLabelsTemplate"/>
					</numericalAxisY1>
				</xsl:when>
				<xsl:when test="$v_axisPosition = 'Y2'">
					<numericalAxisY2>
						<xsl:call-template name="copyAxisAttsTemplate"/>
						<xsl:call-template name="axisTitleTemplate">
							<xsl:with-param name="p_y2" select="'true'"/>
						</xsl:call-template>
						<xsl:call-template name="gridlinesTemplate">
							<xsl:with-param name="p_chart" select=".."/>
							<xsl:with-param name="p_lineStyle" select="'dash'"/>
							<xsl:with-param name="p_color" select="'#99ccff'"/>
						</xsl:call-template>
						<xsl:call-template name="mergeStylesFromAxisAndAxisLabelsTemplate">
							<xsl:with-param name="p_y2" select="'true'"/>
						</xsl:call-template>
					</numericalAxisY2>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="axis3DTemplate">
		<xsl:for-each select="baltic:axis">
			<xsl:variable name="v_axisPosition" select="@axisPosition"/>
			<xsl:choose>
				<xsl:when test="$v_axisPosition = 'X'">
					<ordinalAxisX>
						<xsl:call-template name="copyTruncationAttsTemplate"/>
						<xsl:call-template name="processAllowAttsTemplate">
							<xsl:with-param name="p_el" select=".."/>
						</xsl:call-template>
						<xsl:call-template name="axisTitleTemplate"/>
						<xsl:call-template name="mergeStylesFromAxisAndAxisLabelsTemplate"/>
					</ordinalAxisX>
					<ordinalAxisY>
						<xsl:call-template name="copyTruncationAttsTemplate"/>
						<xsl:call-template name="processAllowAttsTemplate">
							<xsl:with-param name="p_el" select=".."/>
						</xsl:call-template>
						<xsl:call-template name="axisTitleTemplate"/>
						<xsl:call-template name="mergeStylesFromAxisAndAxisLabelsTemplate"/>
					</ordinalAxisY>
				</xsl:when>
				<xsl:when test="$v_axisPosition = 'Y1'">
					<numericalAxis>
						<xsl:call-template name="copyAxisAttsTemplate"/>
						<xsl:call-template name="axisTitleTemplate">
							<xsl:with-param name="p_z_axis" select="'true'"/>
						</xsl:call-template>
						<xsl:call-template name="gridlinesTemplate">
							<xsl:with-param name="p_chart" select=".."/>
						</xsl:call-template>
						<xsl:call-template name="mergeStylesFromAxisAndAxisLabelsTemplate"/>
					</numericalAxis>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="getCSSMergeValueFromAxisStyleAndLabelsStyleTemplate">
		<xsl:param name="p_axis" select="."/>
		<xsl:param name="p_y2"/>
		<xsl:variable name="cssValue">
			<xsl:choose>
				<xsl:when test="$p_axis/baltic:labels/baltic:style/baltic:stringFormat or $p_axis/baltic:labels/baltic:style/baltic:numberFormat or $p_axis/baltic:labels/baltic:style/baltic:currencyFormat or $p_axis/baltic:labels/baltic:style/baltic:percentFormat or $p_axis/baltic:labels/baltic:style/baltic:dateFormat or $p_axis/baltic:labels/baltic:style/baltic:timeFormat or $p_axis/baltic:labels/baltic:style/baltic:dateTimeFormat or $p_axis/baltic:labels/baltic:style/baltic:intervalFormat or $p_axis/baltic:labels/baltic:style/baltic:format">
					<xsl:if test="$p_y2 != 'true'">
						<xsl:value-of select="$p_axis/baltic:style/baltic:CSS/@value"/>
					</xsl:if>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$p_axis/baltic:labels/baltic:style/baltic:CSS/@value"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$cssValue != ''">
				<xsl:value-of select="$cssValue"/>
			</xsl:when>
			<xsl:when test="$p_y2 = 'true'">
				<xsl:text>color:#0066cc</xsl:text>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="mergeStylesFromAxisAndAxisLabelsTemplate">
		<xsl:param name="p_axis" select="."/>
		<xsl:param name="p_y2"/>
		<xsl:variable name="cssValueToAdd">
			<xsl:call-template name="getCSSMergeValueFromAxisStyleAndLabelsStyleTemplate">
				<xsl:with-param name="p_cur" select="$p_axis"/>
				<xsl:with-param name="p_y2" select="$p_y2"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$p_axis/baltic:labels/baltic:style/baltic:stringFormat or $p_axis/baltic:labels/baltic:style/baltic:numberFormat or $p_axis/baltic:labels/baltic:style/baltic:currencyFormat or $p_axis/baltic:labels/baltic:style/baltic:percentFormat or $p_axis/baltic:labels/baltic:style/baltic:dateFormat or $p_axis/baltic:labels/baltic:style/baltic:timeFormat or $p_axis/baltic:labels/baltic:style/baltic:dateTimeFormat or $p_axis/baltic:labels/baltic:style/baltic:intervalFormat or $p_axis/baltic:labels/baltic:style/baltic:format">
				<xsl:call-template name="simpleLayoutGroupTemplate">
					<xsl:with-param name="p_cur" select="$p_axis/baltic:labels"/>
					<xsl:with-param name="p_prependValue" select="$cssValueToAdd"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="simpleLayoutGroupTemplate">
					<xsl:with-param name="p_cur" select="$p_axis"/>
					<xsl:with-param name="p_addValue" select="$cssValueToAdd"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<!-- 
			The axis' style and labels' style get merge together as one style element under the axis.
			If the labels has CSS and data format it will override the axis' style CSS and data format.
			Thefore, consider the following scenarios:
	
			1.
					
				<axis axisPosition="X">
					<labels>
						<style>
							<CSS value="color:red"/>
							<currencyFormat decimalSize="2"/>
						</style>
					</labels>
					<style>
						<CSS value="color:blue"/>
						<currencyFormat decimalSize="1"/>
					</style>
				</axis>	
			
				BECOMES
				<ordinalAxis>
					<style>
						<CSS value="color:blue;color:red"/>
						<currencyFormat decimalSize="2"/>
					</style>					
				<ordinalAxis>
				
				Result: Ordinal axis labels will get drawn as red with 2 decimal places
				
				
			2.
					
				<axis axisPosition="X">
					<labels>
						<style>
							<CSS value="color:red"/>
						</style>
					</labels>
					<style>
						<CSS value="color:blue"/>
						<currencyFormat decimalSize="1"/>
					</style>
				</axis>	
			
				BECOMES
				<ordinalAxis>
					<style>
						<CSS value="color:blue;color:red"/>
						<currencyFormat decimalSize="1"/>
					</style>					
				<ordinalAxis>
				
				Result: Ordinal axis labels will get drawn as red with 1 decimal places


			3.
					
				<axis axisPosition="X">
					<labels>
						<style>
							<CSS value="color:red"/>
							<currencyFormat decimalSize="2"/>
						</style>
					</labels>
					<style>
						<CSS value="color:blue"/>
					</style>
				</axis>	
			
				BECOMES
				<ordinalAxis>
					<style>
						<CSS value="color:blue;color:red"/>
						<currencyFormat decimalSize="2"/>
					</style>					
				<ordinalAxis>
				
				Result: Ordinal axis labels will get drawn as red with 2 decimal places
			
		-->
	</xsl:template>
	<xsl:template name="commonClustersTemplateWithMeasureOnColEdgeCheck">
		<xsl:variable name="v_refQuery" select="@refQuery"/>
		<xsl:variable name="v_measureOnColEdge">
			<xsl:choose>
				<xsl:when test="//baltic:BIQuery[@name=$v_refQuery]/baltic:summary/baltic:columnEdge/baltic:cellMembers">1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="v_levelOnColEdge">
			<xsl:choose>
				<xsl:when test="//baltic:BIQuery[@name=$v_refQuery]/baltic:summary/baltic:columnEdge/baltic:level">1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="v_checkMeasures">
			<xsl:choose>
				<xsl:when test="count(baltic:chartMeasure) = 1 and $v_levelOnColEdge = 1">conditionally</xsl:when>
				<xsl:when test="count(baltic:chartMeasure) = 1 and $v_measureOnColEdge = 1">yes</xsl:when>
				<xsl:otherwise>conditionally</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:call-template name="commonClustersTemplate">
			<xsl:with-param name="p_checkMeasures" select="$v_checkMeasures"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="commonClustersTemplate">
		<xsl:param name="p_addChartContents" select="'false'"/>
		<xsl:param name="p_checkMeasures" select="'conditionally'"/>
		<xsl:variable name="v_refQuery" select="@refQuery"/>
		<xsl:variable name="p_testMoveMeasureToColEdge">
			<xsl:choose>
				<xsl:when test="not(@columnEdgeIncluded ='false') and //baltic:BIQuery[@name=$v_refQuery]/baltic:summary/baltic:columnEdge/baltic:cellMembers">1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="v_createCommonClusters">
			<xsl:choose>
				<xsl:when test="not(@columnEdgeIncluded ='false') and //baltic:BIQuery[@name=$v_refQuery]/baltic:summary/baltic:columnEdge/baltic:level">1</xsl:when>
				<xsl:when test="$p_testMoveMeasureToColEdge = 1">1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="$v_createCommonClusters = 1">
			<commonClusters>
				<xsl:call-template name="chartLevelTemplate">
					<xsl:with-param name="p_mode" select="'columnEdge'"/>
					<xsl:with-param name="p_addChartContents" select="$p_addChartContents"/>
					<xsl:with-param name="p_checkMeasures" select="$p_checkMeasures"/>
					<xsl:with-param name="p_testMoveMeasureToColEdge" select="$p_testMoveMeasureToColEdge"/>
				</xsl:call-template>
			</commonClusters>
		</xsl:if>
	</xsl:template>
	<xsl:template name="defaultMeasureTemplate">
		<xsl:param name="p_base" select="."/>
		<xsl:param name="p_testByCount" select="'yes'"/>
		<xsl:variable name="v_refQuery" select="@refQuery"/>
		<xsl:variable name="v_createMeasure">
			<xsl:choose>
				<xsl:when test="$p_testByCount = 'yes' and count($p_base/baltic:chartMeasure) = 1">1</xsl:when>
				<xsl:when test="$p_testByCount = 'no' and count($p_base/baltic:chartMeasure) = 1 and //baltic:BIQuery[@name=$v_refQuery]/baltic:summary/baltic:columnEdge/baltic:level">1</xsl:when>
				<xsl:when test="$p_testByCount = 'no' and count($p_base/baltic:chartMeasure) = 1 and not(//baltic:BIQuery[@name=$v_refQuery]/baltic:summary/baltic:columnEdge)">1</xsl:when>
				<xsl:when test="$p_testByCount = 'no' and count($p_base/baltic:chartMeasure) = 1 and not(//baltic:BIQuery[@name=$v_refQuery]/baltic:summary/baltic:columnEdge/*)">1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="$v_createMeasure = 1">
			<xsl:variable name="v_refDataItem">
				<xsl:value-of select="baltic:chartMeasure/baltic:member/@refMember"/>
			</xsl:variable>
			<xsl:if test="$v_refDataItem != ''">
				<defaultChartMeasure refDataItem="{$v_refDataItem}">
					<xsl:call-template name="mergeStylesFromChartBodyAndChartMeasure">
						<xsl:with-param name="p_chartBody" select="baltic:chartBody"/>
						<xsl:with-param name="p_chartMeasure" select="baltic:chartMeasure"/>
					</xsl:call-template>
					<xsl:if test="baltic:chartMeasure/baltic:chartText">
						<chartLabel>
							<chartContents>
								<xsl:apply-templates select="baltic:chartMeasure/baltic:chartText"/>
							</chartContents>
						</chartLabel>
					</xsl:if>
				</defaultChartMeasure>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template name="mergeStylesFromChartBodyAndChartMeasure">
		<xsl:param name="p_chart" select="."/>
		<xsl:param name="p_chartBody"/>
		<xsl:param name="p_chartMeasure"/>
		<xsl:choose>
			<xsl:when test="$p_chart/baltic:pieChart/@showPercentage ='true'">
				<xsl:choose>
					<xsl:when test="$p_chartMeasure/baltic:style/baltic:percentFormat">
						<!--carry all chartMeasure CSS and data format over to V5-->
						<xsl:call-template name="simpleLayoutGroupTemplate">
							<xsl:with-param name="p_cur" select="$p_chartMeasure"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="$p_chartBody/baltic:style/baltic:stringFormat or $p_chartBody/baltic:style/baltic:numberFormat or $p_chartBody/baltic:style/baltic:currencyFormat or $p_chartBody/baltic:style/baltic:percentFormat or $p_chartBody/baltic:style/baltic:dateFormat or $p_chartBody/baltic:style/baltic:timeFormat or $p_chartBody/baltic:style/baltic:dateTimeFormat or $p_chartBody/baltic:style/baltic:intervalFormat or $p_chartBody/baltic:style/baltic:format">
						<!--carry the chartMeasure CSS over with the chartBody data format to V5-->
						<style>
							<xsl:apply-templates select="baltic:chartMeasure/baltic:style" mode="CSSOnly"/>
							<xsl:apply-templates select="$p_chartBody/baltic:style" mode="formatOnly"/>
						</style>
					</xsl:when>
					<xsl:otherwise>
						<!--Only carry the chartMeasure CSS over to V5-->
						<xsl:if test="baltic:chartMeasure/baltic:style/baltic:CSS">
							<style>
								<xsl:apply-templates select="baltic:chartMeasure/baltic:style" mode="CSSOnly"/>
							</style>
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$p_chart/baltic:areaChart/@standardType='percent' or $p_chart/baltic:barChart/@standardType='percent' or $p_chart/baltic:columnChart/@standardType='percent' or $p_chart/baltic:combinationChart/@standardType='percent' or $p_chart/baltic:lineChart/@standardType='percent'">
				<xsl:choose>
					<xsl:when test="$p_chartMeasure/baltic:style/baltic:percentFormat">
						<!--carry all chartMeasure CSS and data format over to V5-->
						<xsl:call-template name="simpleLayoutGroupTemplate">
							<xsl:with-param name="p_cur" select="$p_chartMeasure"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<!--Only carry the chartMeasure CSS over to V5-->
						<xsl:if test="baltic:chartMeasure/baltic:style">
							<style>
								<xsl:apply-templates select="baltic:chartMeasure/baltic:style" mode="CSSOnly"/>
							</style>
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<!--Non-percent charts
					chartMeasure data format inherits from chartBody data format
					chartMeasure data format overrides chartBody data format
				-->
				<xsl:choose>
					<xsl:when test="$p_chartMeasure/baltic:style/baltic:stringFormat or $p_chartMeasure/baltic:style/baltic:numberFormat or $p_chartMeasure/baltic:style/baltic:currencyFormat or $p_chartMeasure/baltic:style/baltic:percentFormat or $p_chartMeasure/baltic:style/baltic:dateFormat or $p_chartMeasure/baltic:style/baltic:timeFormat or $p_chartMeasure/baltic:style/baltic:dateTimeFormat or $p_chartMeasure/baltic:style/baltic:intervalFormat or $p_chartMeasure/baltic:style/baltic:format">
						<xsl:call-template name="simpleLayoutGroupTemplate">
							<xsl:with-param name="p_cur" select="$p_chartMeasure"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<!--carry the chartMeasure CSS over with the chartBody data format to V5-->
						<xsl:if test="baltic:chartMeasure/baltic:style or $p_chartBody/baltic:style/baltic:stringFormat or $p_chartBody/baltic:style/baltic:numberFormat or $p_chartBody/baltic:style/baltic:currencyFormat or $p_chartBody/baltic:style/baltic:percentFormat or $p_chartBody/baltic:style/baltic:dateFormat or $p_chartBody/baltic:style/baltic:timeFormat or $p_chartBody/baltic:style/baltic:dateTimeFormat or $p_chartBody/baltic:style/baltic:intervalFormat or $p_chartBody/baltic:style/baltic:format">
							<style>
								<xsl:apply-templates select="baltic:chartMeasure/baltic:style" mode="CSSOnly"/>
								<xsl:apply-templates select="$p_chartBody/baltic:style" mode="formatOnly"/>
							</style>
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
		<!--V4 data format inheritance from chartBody and chartMeasure
		
		For percentage pie chart:
		=========================	
					
		1. If the <chartMeasure> data format is not of type percentFormat, Baltic ignores it.  Therefore, do not carry non-percentFormat to Bering.
		2. <chartMeasure> percentFormat takes precedence over <chartBody> percentFormat
		3. All <chartBody> data format types get applied to the <chartMeasure> when the <chartMeasure> has no data format.
		
		
		For other percent type charts (area, bar, column, line, combination)
		====================================================================
		1. If the <chartMeasure> data format is not of type percentFormat, Baltic ignores it.  Therefore, do not carry non-percentFormat to Bering.
		2. <chartMeasure> percentFormat gets apply so carry over to Bering.
		3. <chartMeasure> does not inherit percentFormat from chartBody.
		
		
		For all non-percent charts
		==========================
		2. <chartMeasure> data Format takes precedence over <chartBody> data Format
		3. All <chartBody> data format types get applied to the <chartMeasure> when the <chartMeasure> has no data format.
		-->
	</xsl:template>
	<xsl:template name="processAllowAttsTemplate">
		<xsl:param name="p_el" select="."/>
		<xsl:variable name="v_startsWith" select="'allow'"/>
		<labelControl>
			<xsl:choose>
				<xsl:when test="$p_el[@skipInterval]">
					<manualLabelControl>
						<xsl:attribute name="displayFrequency"><xsl:value-of select="$p_el/@skipInterval"/></xsl:attribute>
						<xsl:if test="$p_el[@startSkipInterval]">
							<xsl:attribute name="firstLabel"><xsl:value-of select="$p_el/@startSkipInterval"/></xsl:attribute>
						</xsl:if>
					</manualLabelControl>
				</xsl:when>
				<xsl:otherwise>
					<autoLabelControl>
						<xsl:for-each select="$p_el/@*[contains(name(),$v_startsWith)]">
							<xsl:attribute name="{name(.)}"><xsl:value-of select="."/></xsl:attribute>
						</xsl:for-each>
					</autoLabelControl>
				</xsl:otherwise>
			</xsl:choose>
		</labelControl>
	</xsl:template>
	<xsl:template name="copyAttributesTemplate">
		<xsl:param name="p_el" select="."/>
		<xsl:param name="p_startsWith"/>
		<xsl:param name="p_oldAtt1"/>
		<xsl:param name="p_newAtt1"/>
		<xsl:param name="p_oldAtt2"/>
		<xsl:param name="p_newAtt2"/>
		<xsl:param name="p_oldAtt3"/>
		<xsl:param name="p_newAtt3"/>
		<xsl:param name="p_oldAtt4"/>
		<xsl:param name="p_newAtt4"/>
		<xsl:if test="$p_startsWith != ''">
			<xsl:for-each select="$p_el/@*[contains(name(),$p_startsWith)]">
				<xsl:attribute name="{name(.)}"><xsl:value-of select="."/></xsl:attribute>
			</xsl:for-each>
		</xsl:if>
		<xsl:if test="$p_oldAtt1 != '' and $p_newAtt1 != ''">
			<xsl:variable name="v_attValue">
				<xsl:value-of select="./@*[name()=$p_oldAtt1]"/>
			</xsl:variable>
			<xsl:if test="$v_attValue != ''">
				<xsl:attribute name="{$p_newAtt1}"><xsl:value-of select="$v_attValue"/></xsl:attribute>
			</xsl:if>
		</xsl:if>
		<xsl:if test="$p_oldAtt2 != '' and $p_newAtt2 != ''">
			<xsl:variable name="v_attValue">
				<xsl:value-of select="./@*[name()=$p_oldAtt2]"/>
			</xsl:variable>
			<xsl:if test="$v_attValue != ''">
				<xsl:attribute name="{$p_newAtt2}"><xsl:value-of select="$v_attValue"/></xsl:attribute>
			</xsl:if>
		</xsl:if>
		<xsl:if test="$p_oldAtt3 != '' and $p_newAtt3 != ''">
			<xsl:variable name="v_attValue">
				<xsl:value-of select="./@*[name()=$p_oldAtt3]"/>
			</xsl:variable>
			<xsl:if test="$v_attValue != ''">
				<xsl:attribute name="{$p_newAtt3}"><xsl:value-of select="$v_attValue"/></xsl:attribute>
			</xsl:if>
		</xsl:if>
		<xsl:if test="$p_oldAtt4 != '' and $p_newAtt4 != ''">
			<xsl:variable name="v_attValue">
				<xsl:value-of select="./@*[name()=$p_oldAtt4]"/>
			</xsl:variable>
			<xsl:if test="$v_attValue != ''">
				<xsl:attribute name="{$p_newAtt4}"><xsl:value-of select="$v_attValue"/></xsl:attribute>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template name="useNumericalAxisTemplate">
		<xsl:param name="p_chart" select="."/>
		<xsl:choose>
			<xsl:when test="baltic:chartMember[@axisPosition = 'Y1']">
				<xsl:attribute name="useNumericalAxis">numericalAxisY1</xsl:attribute>
			</xsl:when>
			<xsl:when test="baltic:chartMember[@axisPosition = 'Y2']">
				<xsl:attribute name="useNumericalAxis">numericalAxisY2</xsl:attribute>
			</xsl:when>
			<xsl:when test="baltic:chartMember[@axisPosition = 'Y3']">
				<xsl:attribute name="useNumericalAxis">numericalAxisY3</xsl:attribute>
			</xsl:when>
			<xsl:when test="baltic:chartMember[@axisPosition = 'Y4']">
				<xsl:attribute name="useNumericalAxis">numericalAxisY4</xsl:attribute>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="lineAttributesTemplate">
		<xsl:param name="chart"/>
	</xsl:template>
	<xsl:template name="copyAxisAttsTemplate">
		<xsl:param name="p_el" select="."/>
		<xsl:choose>
			<xsl:when test="@scaleMinimum = '0' and @scaleMaximum = '0'">
				<xsl:attribute name="includeZeroForAutoScale">false</xsl:attribute>
				<xsl:call-template name="copyAttributesTemplate">
					<xsl:with-param name="p_el" select="$p_el"/>
					<xsl:with-param name="p_oldAtt1">sharedMaximumValue</xsl:with-param>
					<xsl:with-param name="p_newAtt1">sameRangeAllInstances</xsl:with-param>
					<xsl:with-param name="p_oldAtt2">scaleInterval</xsl:with-param>
					<xsl:with-param name="p_newAtt2">scaleInterval</xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="copyAttributesTemplate">
					<xsl:with-param name="p_el" select="$p_el"/>
					<xsl:with-param name="p_oldAtt1">scaleMinimum</xsl:with-param>
					<xsl:with-param name="p_newAtt1">min</xsl:with-param>
					<xsl:with-param name="p_oldAtt2">scaleMaximum</xsl:with-param>
					<xsl:with-param name="p_newAtt2">max</xsl:with-param>
					<xsl:with-param name="p_oldAtt3">sharedMaximumValue</xsl:with-param>
					<xsl:with-param name="p_newAtt3">sameRangeAllInstances</xsl:with-param>
					<xsl:with-param name="p_oldAtt4">scaleInterval</xsl:with-param>
					<xsl:with-param name="p_newAtt4">scaleInterval</xsl:with-param>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:if test="$p_el/@logarithmic = 'true'">
			<xsl:attribute name="scale">log</xsl:attribute>
		</xsl:if>
	</xsl:template>
	<xsl:template name="gridlinesTemplate">
		<xsl:param name="p_chart" select="."/>
		<xsl:param name="p_lineStyle"/>
		<xsl:param name="p_color"/>
		<xsl:param name="p_mandatory"/>
		<xsl:if test="$p_mandatory = 'true' or not($p_chart/baltic:chartBody/@showGridLines) or $p_chart/baltic:chartBody/@showGridLines != 'false'">
			<gridlines>
				<xsl:if test="$p_lineStyle != ''">
					<xsl:attribute name="lineStyle"><xsl:value-of select="$p_lineStyle"/></xsl:attribute>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="$p_color != ''">
						<xsl:attribute name="color"><xsl:value-of select="$p_color"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<!--default gridlines color in both V4 & V5-->
						<xsl:attribute name="color">silver</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</gridlines>
		</xsl:if>
	</xsl:template>
	<xsl:template name="copyTruncationAttsTemplate">
		<xsl:param name="p_chart" select=".."/>
		<!-- attributes -->
		<xsl:if test="$p_chart/baltic:categoryItemTruncationText/baltic:text">
			<xsl:attribute name="truncationText"><xsl:value-of select="$p_chart/baltic:categoryItemTruncationText/baltic:text"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$p_chart/@categoryitemMaxCharacters">
			<xsl:attribute name="categoryitemMaxCharacters"><xsl:value-of select="$p_chart/@categoryitemMaxCharacters"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$p_chart/@itemEnableTruncation">
			<xsl:attribute name="categoryitemEnableTruncation"><xsl:value-of select="$p_chart/@categoryitemEnableTruncation"/></xsl:attribute>
		</xsl:if>
	</xsl:template>
	<xsl:template name="axisTitleTemplate">
		<xsl:param name="p_cur" select="."/>
		<xsl:param name="p_addChartContents"/>
		<xsl:param name="p_y2"/>
		<xsl:param name="p_z_axis"/>
		<xsl:param name="p_addAxisLine"/>
		<axisTitle>
			<xsl:call-template name="addStyle">
				<xsl:with-param name="for" select="'chartAxisTitle'"/>
			</xsl:call-template>
			<xsl:variable name="v_axisTitleText">
				<xsl:choose>
					<xsl:when test="$p_cur/baltic:title/baltic:text">
						<xsl:value-of select="$p_cur/baltic:title/baltic:text"/>
					</xsl:when>
					<xsl:when test="$p_cur/baltic:title/baltic:queryItemRef">'true'</xsl:when>
					<xsl:when test="$p_cur/baltic:title/baltic:expression">'true'</xsl:when>
					<xsl:otherwise/>
				</xsl:choose>
			</xsl:variable>
			<xsl:if test="$v_axisTitleText != '' or p_addChartContents='true'">
				<chartContents>
					<xsl:apply-templates select="$p_cur/baltic:title" mode="axis"/>
				</chartContents>
			</xsl:if>
			<xsl:variable name="v_addValue">
				<xsl:if test="$p_cur/baltic:title/@render = 'false'">visibility:hidden</xsl:if>
			</xsl:variable>
			<xsl:call-template name="simpleLayoutGroupTemplate">
				<xsl:with-param name="p_cur" select="$p_cur/baltic:title"/>
				<xsl:with-param name="p_addValue" select="$v_addValue"/>
			</xsl:call-template>
		</axisTitle>
		<xsl:if test="$p_addAxisLine != 'false'">
			<xsl:if test="not($p_cur/@showAxisLine) or $p_cur/@showAxisLine != 'false'">
				<xsl:variable name="color">
					<xsl:if test="baltic:style">
						<xsl:call-template name="getColorFromCSSTemplate">
							<xsl:with-param name="inputString" select="normalize-space(baltic:style[1]/baltic:CSS/@value)"/>
						</xsl:call-template>
					</xsl:if>
				</xsl:variable>
				<xsl:element name="axisLine">
					<xsl:choose>
						<xsl:when test="$color!=''">
							<xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="$p_z_axis = 'true'">
							<xsl:attribute name="color">#cccccc</xsl:attribute>
						</xsl:when>
						<xsl:when test="$p_y2 = 'true'">
							<xsl:attribute name="color">#99ccff</xsl:attribute>
						</xsl:when>
					</xsl:choose>
				</xsl:element>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template name="legendTitleTemplate">
		<legendTitle>
			<xsl:call-template name="addStyle">
				<xsl:with-param name="for" select="'chartLegendTitle'"/>
			</xsl:call-template>
			<xsl:variable name="v_legendTitleText">
				<xsl:choose>
					<xsl:when test="baltic:legend/baltic:title/baltic:text">
						<xsl:value-of select="baltic:legend/baltic:title/baltic:text"/>
					</xsl:when>
					<xsl:when test="baltic:legend/baltic:title/baltic:queryItemRef">'true'</xsl:when>
					<xsl:when test="baltic:legend/baltic:title/baltic:expression">'true'</xsl:when>
					<xsl:otherwise/>
				</xsl:choose>
			</xsl:variable>
			<xsl:if test="$v_legendTitleText != ''">
				<chartContents>
					<xsl:apply-templates select="baltic:legend/baltic:title" mode="legend"/>
				</chartContents>
			</xsl:if>
			<xsl:variable name="v_addValue">
				<xsl:if test="baltic:legend/baltic:title/@render = 'false'">visibility:hidden</xsl:if>
			</xsl:variable>
			<xsl:call-template name="simpleLayoutGroupTemplate">
				<xsl:with-param name="p_cur" select="baltic:legend"/>
				<xsl:with-param name="p_addValue" select="$v_addValue"/>
			</xsl:call-template>
		</legendTitle>
	</xsl:template>
</xsl:stylesheet>
