<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl">
	<!-- 
		drillTarget -> reportDrill
		drillTarget@name -> reportDrill@name
		drillTarget@path -> reportDrill/drillTarget/reportPath@path
		drillTarget@showInNewWindow -> reportDrill/drillTarget@showInNewWindow
		drillTarget@method -> reportDrill/drillTarget@method
		drillTarget@outputFormat -> reportDrill/drillTarget@outputFormat
		
		drillParameter -> drillLink
		drillParameter@name -> drillLink/drillTargetContext/parameterContext@parameter
		drillParameter@value -> Not Supported
		drillParameter/queryItemRef@refItem -> drillLink/drillSourceContext/dataItemContext@refDataItem
		
		bookmarkRef -> bookmarkRef
		bookmarkRef/label -> bookmarkRef/dataSource/staticValue
		bookmarkRef/queryItemRef@refItem -> bookmarkRef/dataSource/dataItemValue@refDataItem
		bookmarkRef/expression -> bookmarkRef/dataSource/reportExpression
		
		label -> drillLabel/dataSource/staticValue
	-->
	<xsl:template name="drillTargetTemplate">
		<xsl:param name="p_drillTargets" select="baltic:drillTarget"/>
		<xsl:if test="$p_drillTargets">
			<reportDrills>
				<xsl:apply-templates select="$p_drillTargets"/>
			</reportDrills>
		</xsl:if>
	</xsl:template>
	<xsl:template match="baltic:drillTarget">
		<reportDrill name="{@name}">
			<!-- label ==> drillLabel -->
			<xsl:apply-templates select="baltic:label"/>
			<!-- Even though the schema allows it (trakker 531099) it is not permissable to have
                * both a bookmarkRef and a drillTarget.  
                -->
			<xsl:if test="count(@path) > 0 or count(baltic:drillParameter) > 0">
				<xsl:variable name="v_path">
					<xsl:call-template name="upgradeDrillTargetPathTemplate">
						<xsl:with-param name="p_v4DrillTargetName" select="@name"/>
						<xsl:with-param name="p_v4DrillTargetPath" select="@path"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:if test="$v_path != ''">
					<drillTarget>
						<!-- showInNewWIndow -->
						<xsl:variable name="v_showInNewWindow" select="@showInNewWindow"/>
						<xsl:if test="$v_showInNewWindow = 'true'">
							<xsl:attribute name="showInNewWindow"><xsl:value-of select="$v_showInNewWindow"/></xsl:attribute>
						</xsl:if>
						<!-- method -->
						<xsl:variable name="v_method" select="@method"/>
						<xsl:attribute name="method"><xsl:choose><xsl:when test="$v_method != ''"><xsl:value-of select="$v_method"/></xsl:when><xsl:otherwise>execute</xsl:otherwise></xsl:choose></xsl:attribute>
						<!-- outputFormat -->
						<xsl:variable name="v_outputFormat" select="@outputFormat"/>
						<xsl:if test="$v_outputFormat != ''">
							<xsl:attribute name="outputFormat"><xsl:value-of select="$v_outputFormat"/></xsl:attribute>
						</xsl:if>
						<!-- reportPath -->						
						<reportPath path="{$v_path}">
							<XMLAttributes>
								<xsl:variable name="v_after">report[@name='</xsl:variable>
								<xsl:variable name="v_before">']</xsl:variable>
								<XMLAttribute name="ReportName" value="{substring-before(substring-after($v_path,$v_after),$v_before)}" render="false"/>
							</XMLAttributes>
						</reportPath>
						<!-- drillLinks -->
						<xsl:if test="count(baltic:drillParameter) > 0">
							<drillLinks>
								<xsl:for-each select="baltic:drillParameter">
									<drillLink>
										<xsl:if test="count(baltic:queryItemRef) > 0">
											<xsl:variable name="v_dic" select="baltic:queryItemRef/@refItem"/>
											<xsl:if test="$v_dic != ''">
												<drillSourceContext>
													<dataItemContext refDataItem="{$v_dic}"/>
												</drillSourceContext>
											</xsl:if>
										</xsl:if>
										<drillTargetContext>
											<parameterContext parameter="{@name}"/>
										</drillTargetContext>
									</drillLink>
								</xsl:for-each>
							</drillLinks>
						</xsl:if>
					</drillTarget>
				</xsl:if>
			</xsl:if>
			<!-- bookmarkRef ==> bookmarkRef -->
			<xsl:apply-templates select="baltic:bookmarkRef"/>
		</reportDrill>
	</xsl:template>
	<xsl:template match="baltic:drillTarget/baltic:label">
		<drillLabel>
			<dataSource>
				<staticValue>
					<xsl:apply-templates/>
				</staticValue>
			</dataSource>
		</drillLabel>
	</xsl:template>
	<xsl:template match="baltic:bookmarkRef">
		<bookmarkRef>
			<xsl:call-template name="bookmarkTypeTemplate"/>
		</bookmarkRef>
	</xsl:template>
	<xsl:template name="upgradeDrillTargetPathTemplate">
		<xsl:param name="p_v4DrillTargetName"/>
		<xsl:param name="p_v4DrillTargetPath"/>
		<xsl:if test="$p_v4DrillTargetPath != ''">
			<xsl:variable name="v_path">
				<xsl:value-of select="/baltic:report/baltic:paths/baltic:value/baltic:item/baltic:target/baltic:item//baltic:searchPath/baltic:value[../../../../baltic:name/baltic:item/baltic:value = $p_v4DrillTargetName]"/>
			</xsl:variable>
			<xsl:choose>
				<xsl:when test="$v_path != ''">
					<xsl:value-of select="$v_path"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$p_v4DrillTargetPath"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
