<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl">
	<xsl:variable name="v_asOfTime">
		<xsl:if test="count(/baltic:report/baltic:asOfTime)">
			<asOfTime>
				<xsl:apply-templates select="comment()"/>
				<!-- Harvest comments in case there were expression parsing errors. -->
				<xsl:apply-templates select="/baltic:report/baltic:asOfTime/baltic:expression"/>
			</asOfTime>
		</xsl:if>
	</xsl:variable>
	<xsl:template match="baltic:layoutList[@refVariable]">
		<layouts>
			<!-- Default layout. -->
			<xsl:apply-templates select="baltic:layout[not(@refVariableValue)]"/>
			<!-- Conditional layouts. -->
			<xsl:if test="count(baltic:layout[@refVariableValue]) &gt; 0">
				<xsl:variable name="v_refVariableExists">
					<xsl:call-template name="checkRefVariableTemplate"/>
				</xsl:variable>
				<xsl:if test="$v_refVariableExists = 'true'">
					<conditionalLayouts>
						<xsl:attribute name="refVariable"><xsl:value-of select="@refVariable"/></xsl:attribute>
						<xsl:apply-templates select="baltic:layout[@refVariableValue]"/>
					</conditionalLayouts>
				</xsl:if>
			</xsl:if>
		</layouts>
	</xsl:template>
	<xsl:template match="baltic:layoutList[not(@refVariable)]">
		<layouts>
			<xsl:apply-templates select="baltic:layout[not(@refVariableValue)]"/>
		</layouts>
	</xsl:template>
	<xsl:template match="baltic:layout[@refVariableValue]">
		<conditionalLayout>
			<xsl:attribute name="refVariableValue"><xsl:value-of select="@refVariableValue"/></xsl:attribute>
			<xsl:call-template name="layoutCommonTemplate"/>
		</conditionalLayout>
	</xsl:template>
	<xsl:template match="baltic:layout[not(@refVariableValue)]">
		<layout>
			<xsl:call-template name="layoutCommonTemplate"/>
		</layout>
	</xsl:template>
	<xsl:template name="layoutCommonTemplate">
		<!-- NOTE: The name, localeList,  id and class attributes of the V4 layout element are dropped. -->
		<!-- NOTE: The V4 refQuery attribute of the layout moves down to the V5 pageSet element. -->
		<!-- NOTE: Adding attribute "layoutRefQuery" as a temporary annotation to the v5 layout element
			       to help the upgrade keep track of the query context for prompt pages.
			       This temporary attribute will be removed by the RSUpgradePostProcessing.xsl stylesheet. -->
		<xsl:call-template name="addAttr">
			<xsl:with-param name="p_name" select="'refQuery'"/>
			<xsl:with-param name="p_newName" select="'layoutRefQuery'"/>
		</xsl:call-template>
		<xsl:call-template name="reportPagesTemplate"/>
		<xsl:apply-templates select="baltic:promptPageList"/>
		<xsl:if test="count(baltic:pageSetup) &gt; 1">
			<xsl:comment>
				<xsl:call-template name="logWarning2">
					<xsl:with-param name="p_msgId" select="'RSU_SPC_EXTRA_ELEMENTS_IGNORED'"/>
					<xsl:with-param name="p_param1" select="'pageSetup'"/>
					<xsl:with-param name="p_param2" select="'layout'"/>
				</xsl:call-template>
			</xsl:comment>
		</xsl:if>
		<xsl:apply-templates select="baltic:pageSetup[1]"/>
		<xsl:call-template name="defaultDataFormatsTemplate"/>
	</xsl:template>
	<xsl:template name="layoutContainerTemplate">
		<xsl:param name="p_cur" select="."/>
		<xsl:call-template name="layoutContainerGroupTemplate">
			<xsl:with-param name="p_cur" select="$p_cur"/>
		</xsl:call-template>
		<xsl:call-template name="simpleLayoutGroupTemplate">
			<xsl:with-param name="p_cur" select="$p_cur"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="layoutContainerGroupTemplate">
		<xsl:param name="p_cur" select="."/>
		<contents>
			<xsl:copy-of select="$v_asOfTime"/>
			<xsl:call-template name="layoutContainerGroupNoContentsTemplate">
				<xsl:with-param name="p_cur" select="$p_cur"/>
			</xsl:call-template>
		</contents>
	</xsl:template>
	<xsl:template name="layoutContainerGroupNoContentsTemplate">
		<xsl:param name="p_cur" select="."/>
		<xsl:for-each select="$p_cur/*">
			<xsl:choose>
				<xsl:when test="namespace-uri(.) = 'http://cognos.com/rspecupgrade/passthrough/'">
					<xsl:copy-of select="."/>
				</xsl:when>
				<xsl:when test="local-name(.) = 'list'">
					<xsl:apply-templates select="."/>
				</xsl:when>
				<xsl:when test="local-name(.) = 'crosstab'">
					<xsl:apply-templates select="."/>
				</xsl:when>
				<xsl:when test="local-name(.) = 'chart'">
					<xsl:apply-templates select="."/>
				</xsl:when>
				<xsl:when test="local-name(.) = 'repeater'">
					<xsl:apply-templates select="."/>
				</xsl:when>
				<xsl:when test="local-name(.) = 'layoutComponentRef'">
					<xsl:apply-templates select="."/>
				</xsl:when>
				<xsl:when test="local-name(.) = 'fieldSet'">
					<xsl:apply-templates select="."/>
				</xsl:when>
				<xsl:when test="local-name(.) = 'table'">
					<xsl:apply-templates select="."/>
				</xsl:when>
				<xsl:when test="local-name(.) = 'block'">
					<xsl:apply-templates select="."/>
				</xsl:when>
				<xsl:when test="local-name(.) = 'conditionalBlockList'">
					<xsl:apply-templates select="."/>
				</xsl:when>
				<xsl:when test="local-name(.) = 'textItem'">
					<xsl:apply-templates select="."/>
				</xsl:when>
				<xsl:when test="local-name(.) = 'image'">
					<xsl:apply-templates select="."/>
				</xsl:when>
				<xsl:when test="local-name(.) = 'hyperlink'">
					<xsl:apply-templates select="."/>
				</xsl:when>
				<xsl:when test="local-name(.) = 'button'">
					<xsl:apply-templates select="."/>
				</xsl:when>
				<xsl:when test="local-name(.) = 'promptButton'">
					<xsl:apply-templates select="."/>
				</xsl:when>
				<xsl:when test="local-name(.) = 'HTMLItem'">
					<xsl:apply-templates select="."/>
				</xsl:when>
				<xsl:when test="local-name(.) = 'XMLItem'">
					<xsl:apply-templates select="."/>
				</xsl:when>
				<xsl:when test="local-name(.) = 'bookmark'">
					<xsl:apply-templates select="."/>
				</xsl:when>
				<xsl:when test="local-name(.) = 'textBox'">
					<xsl:apply-templates select="."/>
				</xsl:when>
				<xsl:when test="local-name(.) = 'selectValue'">
					<xsl:apply-templates select="."/>
				</xsl:when>
				<xsl:when test="local-name(.) = 'selectWithSearch'">
					<xsl:apply-templates select="."/>
				</xsl:when>
				<xsl:when test="local-name(.) = 'selectDate'">
					<xsl:apply-templates select="."/>
				</xsl:when>
				<xsl:when test="local-name(.) = 'selectTime'">
					<xsl:apply-templates select="."/>
				</xsl:when>
				<xsl:when test="local-name(.) = 'selectDateTime'">
					<xsl:apply-templates select="."/>
				</xsl:when>
				<xsl:when test="local-name(.) = 'selectInterval'">
					<xsl:apply-templates select="."/>
				</xsl:when>
				<xsl:when test="local-name(.) = 'generatedPrompt'">
					<xsl:apply-templates select="."/>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="simpleLayoutGroupTemplate">
		<xsl:param name="p_cur" select="."/>
		<xsl:param name="p_recursive"/>
		<xsl:param name="p_addValue" select="''"/>
		<xsl:param name="p_prependValue" select="''"/>
		<xsl:choose>
			<xsl:when test="not($p_cur/baltic:style[1]) and $p_addValue != ''">
				<style>
					<CSS>
						<xsl:attribute name="value"><xsl:value-of select="$p_addValue"/></xsl:attribute>
					</CSS>
				</style>
			</xsl:when>
			<xsl:when test="not($p_cur/baltic:style[1]) and $p_prependValue != ''">
				<style>
					<CSS>
						<xsl:attribute name="value"><xsl:value-of select="$p_prependValue"/></xsl:attribute>
					</CSS>
				</style>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="$p_cur/baltic:style[1]">
					<xsl:with-param name="p_recursive" select="$p_recursive"/>
					<xsl:with-param name="p_addValue" select="$p_addValue"/>
					<xsl:with-param name="p_prependValue" select="$p_prependValue"/>
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:if test="count($p_cur/baltic:XMLAttribute) &gt; 0">
			<xsl:variable name="var_XMLAttributes">
				<xsl:apply-templates select="$p_cur/baltic:XMLAttribute"/>
			</xsl:variable>
			<XMLAttributes>
				<xsl:copy-of select="$var_XMLAttributes"/>
			</XMLAttributes>
		</xsl:if>
		<xsl:apply-templates select="$p_cur/baltic:conditionalStyle[1]">
			<xsl:with-param name="p_recursive" select="$p_recursive"/>
		</xsl:apply-templates>
	</xsl:template>
	<xsl:template name="defaultDataFormatsTemplate">
		<defaultDataFormats>
			<xsl:apply-templates select="baltic:style" mode="defaultDataFormats"/>
		</defaultDataFormats>
	</xsl:template>
	<xsl:template match="baltic:style" mode="defaultDataFormats">
		<xsl:call-template name="formatGroupTemplate">
			<xsl:with-param name="p_includeDataFormatElement" select="'false'"/>
		</xsl:call-template>
	</xsl:template>
</xsl:stylesheet>
