<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl">
	<xsl:template match="baltic:layoutComponentRef">
		<layoutComponentRef>
			<xsl:attribute name="refLayoutElement"><!-- NOTE: The leading '#' character must be trimmed off. --><xsl:variable name="v_after">#</xsl:variable><xsl:variable name="v_href" select="@href"/><xsl:value-of select="substring-after($v_href,$v_after)"/></xsl:attribute>
			<xsl:call-template name="addStyle"/>
			<xsl:if test="count(@id) = 1">
				<xsl:attribute name="name"><xsl:value-of select="@id"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="count(baltic:layoutComponentOverride) &gt; 0">
				<layoutComponentOverrides>
					<xsl:apply-templates select="baltic:layoutComponentOverride"/>
				</layoutComponentOverrides>
			</xsl:if>
		</layoutComponentRef>
	</xsl:template>
	<xsl:template match="baltic:layoutComponentOverride">
		<layoutComponentOverride>
			<xsl:attribute name="refLayoutElement"><xsl:value-of select="@idContainer"/></xsl:attribute>
			<xsl:call-template name="layoutContainerGroupNoContentsTemplate"/>
			<xsl:call-template name="simpleLayoutGroupTemplate"/>
		</layoutComponentOverride>
	</xsl:template>
</xsl:stylesheet>
