<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl">
	<!-- Logs an error message.
       * @param p_msgId Identifier for the translated message.
       * @return translated message.
       -->
	<xsl:template name="logError0">
		<xsl:param name="p_msgId"/>
		<xsl:value-of select="log:logError0(/baltic:report/logIdentifier/@logId, $p_msgId)" xmlns:log="http://developer.cognos.com/schemas/report/2.0/com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.LogMap"/>
	</xsl:template>
	<!-- Logs an error message.
       * @param p_msgId Identifier for the translated message.
       * @param p_param1 First parameter to insert into translated message.
       * @return translated message.
       -->
	<xsl:template name="logError1">
		<xsl:param name="p_msgId"/>
		<xsl:param name="p_param1"/>
		<xsl:value-of select="log:logError1(/baltic:report/logIdentifier/@logId, $p_msgId, $p_param1)" xmlns:log="http://developer.cognos.com/schemas/report/2.0/com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.LogMap"/>
	</xsl:template>
	<!-- Logs an error message.
       * @param p_msgId Identifier for the translated message.
       * @param p_param1 First parameter to insert into translated message.
       * @param p_param2 Second parameter to insert into translated message.
       * @return translated message.
       -->
	<xsl:template name="logError2">
		<xsl:param name="p_msgId"/>
		<xsl:param name="p_param1"/>
		<xsl:param name="p_param2"/>
		<xsl:value-of select="log:logError2(/baltic:report/logIdentifier/@logId, $p_msgId, $p_param1, $p_param2)" xmlns:log="http://developer.cognos.com/schemas/report/2.0/com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.LogMap"/>
	</xsl:template>
	<!-- Logs a warning message.
       * @param p_msgId Identifier for the translated message.
       * @return translated message.
       -->
	<xsl:template name="logWarning0">
		<xsl:param name="p_msgId"/>
		<xsl:value-of select="log:logWarning0(/baltic:report/logIdentifier/@logId, $p_msgId)" xmlns:log="http://developer.cognos.com/schemas/report/2.0/com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.LogMap"/>
	</xsl:template>
	<!-- Logs a warning message.
       * @param p_msgId Identifier for the translated message.
       * @param p_param1 First parameter to insert into translated message.
       * @return translated message.
       -->
	<xsl:template name="logWarning1">
		<xsl:param name="p_msgId"/>
		<xsl:param name="p_param1"/>
		<xsl:value-of select="log:logWarning1(/baltic:report/logIdentifier/@logId, $p_msgId, $p_param1)" xmlns:log="http://developer.cognos.com/schemas/report/2.0/com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.LogMap"/>
	</xsl:template>
	<!-- Logs a warning message.
       * @param p_msgId Identifier for the translated message.
       * @param p_param1 First parameter to insert into translated message.
       * @param p_param2 Second parameter to insert into translated message.
       * @return translated message.
       -->
	<xsl:template name="logWarning2">
		<xsl:param name="p_msgId"/>
		<xsl:param name="p_param1"/>
		<xsl:param name="p_param2"/>
		<xsl:value-of select="log:logWarning2(/baltic:report/logIdentifier/@logId, $p_msgId, $p_param1, $p_param2)" xmlns:log="http://developer.cognos.com/schemas/report/2.0/com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.LogMap"/>
	</xsl:template>
</xsl:stylesheet>
