<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns:bering="http://developer.cognos.com/schemas/report/2.0/" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl">
	<!--
        * Generate the master detail links for a frame.
        *
        * p_frame Frame we are generating the links for.
     -->
	<xsl:template name="generateMasterDetailLinks2">
		<xsl:param name="p_frame"/>
		<xsl:variable name="v_detailQueryName">
			<xsl:call-template name="getRefQuery">
				<xsl:with-param name="p_frame" select="$p_frame"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:if test="string-length(normalize-space($v_detailQueryName))>0">
			<xsl:if test="$p_frame/..">
				<xsl:variable name="v_masterQueryName">
					<xsl:call-template name="getMasterQueryName">
						<xsl:with-param name="p_frame" select="$p_frame/.."/>
						<xsl:with-param name="p_detailQueryName" select="$v_detailQueryName"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:if test="$v_masterQueryName != ''">
				    <!-- map the master and detail query names, so that parameters generated come
	                    * from the new queries.
                        *
                        * The ignored queries are no longer generat
                      -->
                      <xsl:variable name="v_mappedMasterQueryName">
						  <xsl:call-template name="getQueryTemplate">
							  <xsl:with-param name="refQuery" select="$v_masterQueryName"/>
						  </xsl:call-template>
                      </xsl:variable>
                      <xsl:variable name="v_mappedDetailQueryName">
						  <xsl:call-template name="getQueryTemplate">
							  <xsl:with-param name="refQuery" select="$v_detailQueryName"/>
						  </xsl:call-template>
                      </xsl:variable>
					<xsl:for-each select="/baltic:report/masterDetailInfo/masterDetailData">
						<xsl:if test="@masterQueryName = $v_mappedMasterQueryName">
							<xsl:if test="@detailQueryName = $v_mappedDetailQueryName">
								<xsl:if test="masterDetailLink">
									<xsl:element name="masterDetailLinks">
										<xsl:apply-templates mode="masterDetail" select="masterDetailLink"/>
									</xsl:element>
								</xsl:if>
							</xsl:if>
						</xsl:if>
					</xsl:for-each>
				</xsl:if>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<!--
 * Copy over the detailFilter's from the master-detail information.
 *
 * p_queryName of the query in the master-detail information file to copy the 
 * filters from.
 *
 -->
	<xsl:template name="copyDetailFilter">
		<xsl:param name="p_queryName"/>
		<xsl:for-each select="/baltic:report/masterDetailInfo/masterDetailData">
			<xsl:if test="@detailQueryName = $p_queryName">
				<xsl:apply-templates mode="masterDetail" select="detailFilter"/>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<!--
 * Copy over the detailFilter's from the master-detail information.
 *
 * p_refQuery Name of the detail query.
 -->
	<xsl:template name="generateMasterDetailFilter">
		<xsl:param name="p_detailQueryName"/>
		<!-- copy the original query -->
		<xsl:call-template name="copyDetailFilter">
			<xsl:with-param name="p_queryName" select="$p_detailQueryName"/>
		</xsl:call-template>
	</xsl:template>
	<!--
 * Generate a detailFilters section from the master-detail information.
 *
 * p_refQuery Name of the detail query.
 -->
	<xsl:template name="generateMasterDetailFilters">
		<xsl:param name="p_detailQueryName"/>
		<xsl:variable name="v_filters">
			<xsl:call-template name="generateMasterDetailFilter">
				<xsl:with-param name="p_detailQueryName" select="$p_detailQueryName"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:if test="$v_filters != ''">
			<xsl:element name="detailFilters">
				<xsl:copy-of select="$v_filters"/>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<!-- Find the name of the query that contains the current frame, such that the query is different
        *  then the detail query.
        *
        * p_frame frame, and its ancestors to look for refQuery.
        * p_detailQueryName Name of the detail query we already have, we want a query that nests this one.
        *
        * Return the name of the nesting query, or nothing.
       -->
	<xsl:template name="getMasterQueryName">
		<xsl:param name="p_frame"/>
		<xsl:param name="p_detailQueryName"/>
		<xsl:variable name="v_outterQueryName">
			<xsl:call-template name="getRefQuery">
				<xsl:with-param name="p_frame" select="$p_frame"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:if test="string-length($v_outterQueryName)>0">
			<xsl:choose>
				<xsl:when test="$v_outterQueryName = $p_detailQueryName">
					<xsl:call-template name="getMasterQueryName">
						<xsl:with-param name="p_frame" select="$p_frame/.."/>
						<xsl:with-param name="p_detailQueryName" select="$p_detailQueryName"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$v_outterQueryName"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	<!-- Return the ref query that immediatly encloses the frame.
    * p_frame  Frame in layout to examine.
    *
    * If no refQuery is found then nothing will be returned.
-->
	<xsl:template name="getRefQuery">
		<xsl:param name="p_frame"/>
		<xsl:choose>
			<xsl:when test="$p_frame/@refQuery">
				<xsl:value-of select="$p_frame/@refQuery"/>
			</xsl:when>
			<xsl:when test="$p_frame/..">
				<xsl:call-template name="getRefQuery">
					<xsl:with-param name="p_frame" select="$p_frame/.."/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!-- Copy master-detail information into the Bering namespace without using namespace attributes
       which can not be handled by report studio.
_____________________________________________ 
From: 	McCully, Eric  
Sent:	Friday, August 19, 2005 10:43 AM
To:	Pawlowsky, Marc
Subject:	RE: Report Studio can not handle namespace attributes

RS does not handle namespace attributes, never has. There are too many issues with IE and namespaces.
-->
	<xsl:template mode="masterDetail" match="masterDetailLink">
		<xsl:element name="masterDetailLink">
			<xsl:apply-templates mode="masterDetail"/>
		</xsl:element>
	</xsl:template>
	<xsl:template mode="masterDetail" match="masterDetailLink">
		<xsl:element name="masterDetailLink">
			<xsl:apply-templates mode="masterDetail" select="node()|@*"/>
		</xsl:element>
	</xsl:template>
	<xsl:template mode="masterDetail" match="masterContext">
		<xsl:element name="masterContext">
			<xsl:apply-templates mode="masterDetail" select="node()|@*"/>
		</xsl:element>
	</xsl:template>
	<xsl:template mode="masterDetail" match="detailContext">
		<xsl:element name="detailContext">
			<xsl:apply-templates mode="masterDetail" select="node()|@*"/>
		</xsl:element>
	</xsl:template>
	<xsl:template mode="masterDetail" match="dataItemContext">
		<xsl:element name="dataItemContext">
			<xsl:apply-templates mode="masterDetail" select="node()|@*"/>
		</xsl:element>
	</xsl:template>
	<xsl:template mode="masterDetail" match="parameterContext">
		<xsl:element name="parameterContext">
			<xsl:apply-templates mode="masterDetail" select="node()|@*"/>
		</xsl:element>
	</xsl:template>
	<xsl:template mode="masterDetail" match="detailFilter">
		<xsl:element name="detailFilter">
			<xsl:apply-templates mode="masterDetail" select="node()|@*"/>
		</xsl:element>
	</xsl:template>
	<xsl:template mode="masterDetail" match="filterExpression">
		<xsl:element name="filterExpression">
			<xsl:apply-templates mode="masterDetail" select="node()|@*"/>
		</xsl:element>
	</xsl:template>
	<xsl:template mode="masterDetail" match="@*">
		<xsl:copy-of select="."/>
	</xsl:template>
</xsl:stylesheet>
