<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl">
	<!-- 
	* Detailed mappings for pageSet upgrade:
	* 
	* layout[not(@refQuery)]/pageSet/page -> layout/reportPages/page
	*
	* NOTE: Since each pageSet actually maps to a pageOverallGroup, pageGroup or detailPages element, 
	*             which have no corresponding attributes, the resetPageNumber and resetPageCount attributes of the v4 pageSet
	*             will be set on the first page of the corresponding group.
	* pageSet/@resetPageNumber -> page/@resetPageNumber
	* pageSet/@resetPageCount -> page/@resetPageCount
	*
	* layout[@refQuery]/pageSet[not(@refLevel)]/headerPageList -> layout/ReportPages/pageSet/pageOverallGroup/headerPages
	* layout[@refQuery]/pageSet[not(@refLevel)]/footerPageList  -> layout/ReportPages/pageSet/pageOverallGroup/footerPages
	* layout[@refQuery]/pageSet[not(@refLevel)]/page  -> layout/ReportPages/pageSet/detailPages/page
	*
	* A pageGroup is generated for each query level up to (and including) the innermost pageSet.
	* layout[@refQuery]/pageSet[@refLevel] -> layout/ReportPages/pageSet/pageGroups/pageGroup
	*
	* Header and footer pages for a given level go to the corresponding pageGroup
	* layout[@refQuery]/pageSet[@refLevel]/headerPageList -> layout/ReportPages/pageSet/pageGroups/pageGroup/headerPages
	* layout[@refQuery]/pageSet[@refLevel]/footerPageList -> layout/ReportPages/pageSet/pageGroups/pageGroup/footerPages
	*
	* Only the pageSet for the innermost level has detail pages.
	* The pageSets for the outermost levels only have header and footer page lists.
	* layout[@refQuery]/pageSet[@refLevel and last()]/page  -> layout/ReportPages/pageSet/detailPages/page
	*
	-->
	<xsl:template name="reportPagesTemplate">
		<!--The current context must be "baltic:layout". -->
		<xsl:if test="./node()">
			<reportPages>
				<xsl:choose>
					<xsl:when test="count(@refQuery) = 1 and @refQuery != ''">
						<pageSet name="pageSet1">
							<!-- Get the refQuery attribute of the baltic:layout element. -->
							<xsl:variable name="var_beringRefQuery">
								<xsl:call-template name="getQueryTemplate">
									<xsl:with-param name="refQuery" select="@refQuery"/>
								</xsl:call-template>
							</xsl:variable>
							<xsl:attribute name="refQuery"><xsl:value-of select="$var_beringRefQuery"/></xsl:attribute>
							<!-- originalRefQuery is used by the property list adjuster and will be removed later on. -->
							<xsl:attribute name="originalRefQuery"><xsl:value-of select="@refQuery"/></xsl:attribute>
							<xsl:if test="baltic:pageSet/@resetPageNumber">
								<xsl:call-template name="resetPageTemplate">
									<xsl:with-param name="attribute" select="baltic:pageSet/@resetPageNumber"/>
									<xsl:with-param name="targetName" select="'resetPageNumber'"/>
								</xsl:call-template>
							</xsl:if>
							<xsl:if test="baltic:pageSet/@resetPageCount">
								<xsl:call-template name="resetPageTemplate">
									<xsl:with-param name="attribute" select="baltic:pageSet/@resetPageCount"/>
									<xsl:with-param name="targetName" select="'resetPageCount'"/>
								</xsl:call-template>
							</xsl:if>
							<xsl:call-template name="pageOverallGroupTemplate"/>
							<xsl:call-template name="pageGroupsTemplate"/>
							<xsl:call-template name="detailPagesTemplate"/>
							<xsl:call-template name="generateMasterDetailLinks2">
								<xsl:with-param name="p_frame" select="."/>
							</xsl:call-template>
							<xsl:variable name="v_cube">
								<xsl:call-template name="getCube">
									<xsl:with-param name="p_queryName" select="@refQuery"/>
								</xsl:call-template>
							</xsl:variable>
							<xsl:element name="propertyList"/>
						</pageSet>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="baltic:pageSet" mode="detail"/>
					</xsl:otherwise>
				</xsl:choose>
			</reportPages>
		</xsl:if>
	</xsl:template>
	<xsl:template name="pageOverallGroupTemplate">
		<xsl:apply-templates select="baltic:pageSet[not(@refLevel)]"/>
	</xsl:template>
	<xsl:template name="pageGroupsTemplate">
		<!-- The structure of the V5 page grouping is derived from the V4 Cube Dimension Levels. -->
		<xsl:variable name="var_refQuery" select="@refQuery"/>
		<xsl:apply-templates select="/baltic:report/baltic:querySet/baltic:BIQuery[@name=$var_refQuery]" mode="pageSet">
			<xsl:with-param name="p_layout" select="."/>
			<xsl:with-param name="p_refLevel">
				<xsl:value-of select="baltic:pageSet[last()]/@refLevel"/>
			</xsl:with-param>
		</xsl:apply-templates>
	</xsl:template>
	<xsl:template name="detailPagesTemplate">
		<detailPages>
			<xsl:apply-templates select="baltic:pageSet[@refLevel and last()]" mode="detail"/>
			<xsl:apply-templates select="baltic:pageSet[not(@refLevel)]" mode="detail"/>
		</detailPages>
	</xsl:template>
	<xsl:template match="baltic:layout[@refQuery]/baltic:pageSet[not(@refLevel)]">
		<pageOverallGroup>
			<xsl:variable name="var_refQuery">
				<xsl:call-template name="getRefQuery">
					<xsl:with-param name="p_frame" select="."/>
				</xsl:call-template>
			</xsl:variable>
			<!-- originalRefQuery is used by the property list adjuster and will be removed later on. -->
			<xsl:attribute name="originalRefQuery"><xsl:value-of select="$var_refQuery"/></xsl:attribute>
			<xsl:apply-templates select="baltic:headerPageList"/>
			<xsl:apply-templates select="baltic:footerPageList"/>
			<xsl:element name="propertyList"/>
		</pageOverallGroup>
	</xsl:template>
	<xsl:template match="baltic:layout[@refQuery]/baltic:pageSet[@refLevel]">
		<xsl:apply-templates select="baltic:headerPageList"/>
		<xsl:apply-templates select="baltic:footerPageList"/>
	</xsl:template>
	<xsl:template match="baltic:pageSet" mode="detail">
		<xsl:call-template name="pageTemplate"/>
	</xsl:template>
	<xsl:template match="baltic:headerPageList">
		<headerPages>
			<xsl:call-template name="pageTemplate"/>
		</headerPages>
	</xsl:template>
	<xsl:template match="baltic:footerPageList">
		<footerPages>
			<xsl:call-template name="pageTemplate"/>
		</footerPages>
	</xsl:template>
	<xsl:template name="pageTemplate">
		<xsl:apply-templates select="baltic:page[1]">
			<xsl:with-param name="p_resetPageNumber">
				<xsl:choose>
					<xsl:when test="@resetPageNumber">
						<xsl:value-of select="@resetPageNumber"/>
					</xsl:when>
					<xsl:when test="../@resetPageNumber">
						<!--From the parent pageSet -->
						<xsl:value-of select="../@resetPageNumber"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="''"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:with-param>
			<xsl:with-param name="p_resetPageCount">
				<xsl:choose>
					<xsl:when test="@resetPageCount">
						<xsl:value-of select="@resetPageCount"/>
					</xsl:when>
					<xsl:when test="../@resetPageCount">
						<!--From the parent pageSet -->
						<xsl:value-of select="../@resetPageCount"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="''"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:with-param>
		</xsl:apply-templates>
		<xsl:apply-templates select="baltic:page[position() &gt; 1]"/>
	</xsl:template>
	<xsl:template match="/baltic:report/baltic:querySet/baltic:BIQuery" mode="pageSet">
		<xsl:param name="p_layout"/>
		<xsl:param name="p_refLevel"/>
		<xsl:variable name="var_cube">
			<xsl:call-template name="getCubeOrCubeReference"/>
		</xsl:variable>
		<xsl:variable name="var_pageGroups">
			<xsl:for-each select="$var_cube/baltic:cube/baltic:dimension/baltic:level[@name=$p_refLevel]/preceding-sibling::baltic:level">
				<xsl:apply-templates select="." mode="pageSet">
					<xsl:with-param name="p_layout" select="$p_layout"/>
				</xsl:apply-templates>
			</xsl:for-each>
			<xsl:apply-templates select="$var_cube/baltic:cube/baltic:dimension/baltic:level[@name=$p_refLevel]" mode="pageSet">
				<xsl:with-param name="p_layout" select="$p_layout"/>
			</xsl:apply-templates>
		</xsl:variable>
		<xsl:if test="count($var_cube/baltic:cube/baltic:dimension/baltic:level[@name=$p_refLevel]) &gt; 0">
			<pageGroups>
				<xsl:copy-of select="$var_pageGroups"/>
			</pageGroups>
		</xsl:if>
		<!-- Generate the sortList from the baltic:cube/baltic:factList/baltic:item sort attributes. -->
		<sortList>
			<xsl:apply-templates select="$var_cube/baltic:cube/baltic:factList/baltic:item" mode="generate_sortItems"/>
		</sortList>
	</xsl:template>
	<xsl:template match="baltic:cube/baltic:dimension/baltic:level" mode="pageSet">
		<xsl:param name="p_layout"/>
		<xsl:variable name="var_refLevel" select="@name"/>
		<xsl:variable name="v_refDataItem">
			<xsl:call-template name="getKeyItemNameForLevel"/>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$v_refDataItem='ERROR: Cannot find item or dataItem for the level referenced.'">
				<xsl:comment>
					<xsl:call-template name="logError2">
						<xsl:with-param name="p_msgId" select="'RSU_SPC_LEVEL_KEYITEM_MISSING'"/>
						<xsl:with-param name="p_param1" select="'pageGroup'"/>
						<xsl:with-param name="p_param2" select="$var_refLevel"/>
					</xsl:call-template>
				</xsl:comment>
			</xsl:when>
			<xsl:otherwise>
				<pageGroup refDataItem="{$v_refDataItem}">
					<!-- Generate headerPages and footerPages from the baltic:pageSet with a matching refLevel attribute. -->
					<xsl:apply-templates select="$p_layout/baltic:pageSet[@refLevel=$var_refLevel]"/>
					<!-- Generate sortList from the baltic:item sort attributes up to this level in the current dimension. -->
					<sortList>
						<xsl:apply-templates select="baltic:item" mode="generate_sortItems"/>
					</sortList>
					<xsl:element name="propertyList"/>
				</pageGroup>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
