<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl">
	<xsl:template match="baltic:pageSetup">
		<pageSetup orientation="{@orientation}">
			<xsl:variable name="v_after">@name='</xsl:variable>
			<xsl:variable name="v_before">']</xsl:variable>
			<xsl:variable name="v_name">
				<xsl:choose>
					<xsl:when test="starts-with(@name, '/')">
						<!-- Normally, the name is a path to a pageSetup object in CM and looks like this: /configuration/pageDefinition[@name='Legal'] -->
						<xsl:value-of select="substring-before(substring-after(@name, $v_after),$v_before)"/>
					</xsl:when>
					<xsl:otherwise>
						<!-- Otherwise, use the name as is. -->
						<xsl:value-of select="@name"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="v_width" select="@width"/>
			<xsl:variable name="v_height" select="@height"/>
			<xsl:variable name="v_unit" select="@unit"/>
			<xsl:variable name="v_namedPaper">
				<xsl:choose>
					<xsl:when test="count(@width) = 0 or count(@height) = 0">true</xsl:when>
					<xsl:when test="$v_width = '' or $v_height = ''">true</xsl:when>
					<xsl:when test="$var_paperSize//*[local-name()='namedPaper' and @name=$v_name and @width=$v_width and @height=$v_height and @unit = $v_unit]">true</xsl:when>
					<xsl:otherwise>false</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:choose>
				<xsl:when test="$v_namedPaper = 'true'">
					<namedPaper name="{@name}"/>
				</xsl:when>
				<xsl:otherwise>
					<customPaper width="{@width}" height="{@height}" unit="{@unit}"/>
				</xsl:otherwise>
			</xsl:choose>
		</pageSetup>
	</xsl:template>
</xsl:stylesheet>
