<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl">
	<xsl:template name="pieChartTemplate">
		<pieChart>
			<xsl:call-template name="depthTemplate"/>
			<xsl:call-template name="standardChartAttributesTemplate"/>
			<!-- ringHoleSize ==> holeSize -->
			<xsl:variable name="v_ringHoleSize" select="baltic:pieChart/@ringHoleSize"/>
			<xsl:if test="$v_ringHoleSize != ''">
				<xsl:attribute name="holeSize"><xsl:value-of select="$v_ringHoleSize"/></xsl:attribute>
			</xsl:if>
			<!-- showPieLabels ==> showPieLabels -->
			<xsl:variable name="v_showPieLabels" select="baltic:pieChart/@showPieLabels"/>
			<xsl:if test="$v_showPieLabels != '' and $v_showPieLabels != 'none'">
				<xsl:attribute name="showPieLabels"><xsl:choose><xsl:when test="$v_showPieLabels = 'onSlices'">inside</xsl:when><xsl:when test="$v_showPieLabels = 'outsideSlices'">outside</xsl:when><xsl:when test="$v_showPieLabels = 'outsideSlicesWithHeaderLines'">outsideWithLines</xsl:when></xsl:choose></xsl:attribute>
			</xsl:if>
			<!-- showPieValues ==> showPieValues -->
			<xsl:variable name="v_showPieValues" select="baltic:pieChart/@showPieValues"/>
			<xsl:if test="$v_showPieValues != '' and $v_showPieValues != 'none'">
				<xsl:attribute name="showPieValues"><xsl:choose><xsl:when test="$v_showPieValues = 'onSlices'">inside</xsl:when><xsl:when test="$v_showPieValues = 'outsideSlices'">outside</xsl:when><xsl:when test="$v_showPieValues = 'outsideSlicesWithHeaderLines'">outsideWithLines</xsl:when></xsl:choose></xsl:attribute>
			</xsl:if>
			<!-- showPercentage ==> showValuesAsPercent -->
			<xsl:variable name="v_showPercentage" select="baltic:pieChart/@showPercentage"/>
			<xsl:if test="$v_showPercentage != '' and $v_showPercentage != 'false'">
				<xsl:attribute name="showValuesAsPercent">true</xsl:attribute>
			</xsl:if>
			<!-- tooltips ==> showTooltips -->
			<xsl:variable name="v_tooltips" select="@tooltips"/>
			<xsl:if test="$v_tooltips != '' and $v_tooltips != 'false'">
				<xsl:attribute name="showTooltips">true</xsl:attribute>
			</xsl:if>
			<xsl:call-template name="generateMasterDetailLinks2">
				<xsl:with-param name="p_frame" select="."/>
			</xsl:call-template>
			<xsl:call-template name="legendTemplate"/>
			<xsl:variable name="v_ordinalAxis" select="baltic:axis[@axisPosition='X']"/>
			<xsl:call-template name="axisTitleTemplate">
				<xsl:with-param name="p_cur" select="$v_ordinalAxis"/>
				<xsl:with-param name="p_addAxisLine" select="'false'"/>
			</xsl:call-template>
			<!-- Baltic doesn't display pie labels if there's no category edge or if there's only 1 measure
			     or if the chart only has measures -->
			<xsl:if test="$v_ordinalAxis/baltic:labels and (@rowEdgeIncluded != 'false' or count(baltic:chartMeasure) &gt; 1) and count(baltic:chartLevel) &gt; 0">
				<pieLabels>
					<xsl:call-template name="addStyle">
						<xsl:with-param name="for" select="'chartAxisLabel'"/>
						<xsl:with-param name="default" select="'true'"/>
					</xsl:call-template>
					<!-- attributes -->
					<xsl:if test="baltic:categoryItemTruncationText/baltic:text">
						<xsl:attribute name="truncationText"><xsl:value-of select="baltic:categoryItemTruncationText/baltic:text"/></xsl:attribute>
					</xsl:if>
					<xsl:if test="@categoryitemMaxCharacters">
						<xsl:attribute name="categoryitemMaxCharacters"><xsl:value-of select="@categoryitemMaxCharacters"/></xsl:attribute>
					</xsl:if>
					<xsl:if test="@itemEnableTruncation">
						<xsl:attribute name="categoryitemEnableTruncation"><xsl:value-of select="@categoryitemEnableTruncation"/></xsl:attribute>
					</xsl:if>
					<xsl:call-template name="simpleLayoutGroupTemplate">
						<xsl:with-param name="p_cur" select="$v_ordinalAxis/baltic:labels"/>
					</xsl:call-template>
				</pieLabels>
			</xsl:if>
			<xsl:variable name="v_pieSlices">
				<xsl:call-template name="chartLevelTemplate">
					<xsl:with-param name="p_mode" select="'columnEdge'"/>
					<xsl:with-param name="p_checkMeasures" select="'conditionally'"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:if test="$v_pieSlices/*">
				<pieSlices>
					<xsl:copy-of select="$v_pieSlices"/>
				</pieSlices>
			</xsl:if>
			<xsl:variable name="v_pies">
				<xsl:call-template name="chartLevelTemplate">
					<xsl:with-param name="p_mode" select="'rowEdge'"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:if test="$v_pies/*">
				<pies>
					<xsl:copy-of select="$v_pies"/>
				</pies>
			</xsl:if>
			<xsl:call-template name="defaultMeasureTemplate"/>
			<xsl:call-template name="commonChartTemplate"/>
		</pieChart>
	</xsl:template>
</xsl:stylesheet>
