<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl">
	<xsl:template name="promptTypesTemplate">
		<xsl:apply-templates select="baltic:textBox"/>
		<xsl:apply-templates select="baltic:selectValue"/>
		<xsl:apply-templates select="baltic:selectWithSearch"/>
		<xsl:apply-templates select="baltic:selectDate"/>
		<xsl:apply-templates select="baltic:selectTime"/>
		<xsl:apply-templates select="baltic:selectDateTime"/>
		<xsl:apply-templates select="baltic:selectInterval"/>
		<xsl:apply-templates select="baltic:generatedPrompt"/>
	</xsl:template>
	<xsl:template match="baltic:textBox">
		<textBox>
			<xsl:call-template name="PromptCommonAttributes"/>
			<xsl:call-template name="PromptMultiSelectAttributes"/>
			<xsl:call-template name="PromptRangeAttributes"/>
			<xsl:call-template name="PromptMissingValueAttributes"/>
			<xsl:call-template name="NameLayoutAttributes"/>
			<!-- hideText, multiLine, numbersOnly, showThousandSeparator -->
			<xsl:call-template name="addAttr">
				<xsl:with-param name="p_name" select="'hideText'"/>
			</xsl:call-template>
			<xsl:call-template name="addAttr">
				<xsl:with-param name="p_name" select="'multiLine'"/>
			</xsl:call-template>
			<xsl:call-template name="addAttr">
				<xsl:with-param name="p_name" select="'numbersOnly'"/>
			</xsl:call-template>
			<xsl:call-template name="addAttr">
				<xsl:with-param name="p_name" select="'showThousandSeparator'"/>
			</xsl:call-template>
			<xsl:apply-templates select="baltic:useItem"/>
			<xsl:apply-templates select="baltic:defaultSelections"/>
			<xsl:call-template name="simpleLayoutGroupTemplate"/>
		</textBox>
	</xsl:template>
	<xsl:template match="baltic:selectValue">
		<selectValue>
			<xsl:if test="count(@refQuery) &gt; 0 and @refQuery != ''">
				<!-- Empty refQuery is allowed when all the data values are static. -->
				<xsl:variable name="var_beringRefQuery">
					<xsl:call-template name="getQueryTemplate">
						<xsl:with-param name="refQuery" select="@refQuery"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:attribute name="refQuery"><xsl:value-of select="$var_beringRefQuery"/></xsl:attribute>
				<!-- originalRefQuery is used by the property list adjuster and will be removed later on. -->
				<xsl:attribute name="originalRefQuery"><xsl:value-of select="@refQuery"/></xsl:attribute>
			</xsl:if>
			<xsl:call-template name="PromptCommonAttributes"/>
			<xsl:call-template name="PromptDataDrivenAttributes"/>
			<xsl:call-template name="PromptMissingValueAttributes"/>
			<xsl:call-template name="PromptMultiSelectAttributes"/>
			<xsl:call-template name="PromptRangeAttributes"/>
			<xsl:call-template name="NameLayoutAttributes"/>
			<!-- selectValueUI, autoSubmit -->
			<xsl:call-template name="addAttr">
				<xsl:with-param name="p_name" select="'selectUI'"/>
				<xsl:with-param name="p_newName" select="'selectValueUI'"/>
				<xsl:with-param name="p_default" select="'dropdown'"/>
			</xsl:call-template>
			<xsl:call-template name="addAttr">
				<xsl:with-param name="p_name" select="'autoSubmit'"/>
			</xsl:call-template>
			<xsl:apply-templates select="baltic:useItem"/>
			<xsl:apply-templates select="baltic:selectOptions"/>
			<xsl:apply-templates select="baltic:defaultSelections"/>
			<xsl:call-template name="PromptSortList">
				<xsl:with-param name="p_refQuery" select="@refQuery"/>
			</xsl:call-template>
			<xsl:call-template name="simpleLayoutGroupTemplate"/>
			<xsl:variable name="var_cube">
				<xsl:call-template name="getCube">
					<xsl:with-param name="p_queryName" select="@refQuery"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:if test="count(@refQuery) &gt; 0">
				<xsl:element name="propertyList"/>
			</xsl:if>
		</selectValue>
	</xsl:template>
	<xsl:template match="baltic:selectWithSearch">
		<selectWithSearch>
			<xsl:if test="count(@refQuery) &gt; 0">
				<xsl:variable name="var_beringRefQuery">
					<xsl:call-template name="getQueryTemplate">
						<xsl:with-param name="refQuery" select="@refQuery"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:attribute name="refQuery"><xsl:value-of select="$var_beringRefQuery"/></xsl:attribute>
				<!-- originalRefQuery is used by the property list adjuster and will be removed later on. -->
				<xsl:attribute name="originalRefQuery"><xsl:value-of select="@refQuery"/></xsl:attribute>
			</xsl:if>
			<xsl:call-template name="PromptCommonAttributes"/>
			<xsl:call-template name="PromptDataDrivenAttributes"/>
			<xsl:call-template name="PromptMissingValueAttributes"/>
			<xsl:call-template name="addAttr">
				<xsl:with-param name="p_name" select="'multiSelect'"/>
				<xsl:with-param name="p_default" select="'true'"/>
			</xsl:call-template>
			<xsl:call-template name="NameLayoutAttributes"/>
			<xsl:apply-templates select="baltic:useItem"/>
			<xsl:apply-templates select="baltic:defaultSelections" mode="selectWithSearch"/>
			<xsl:call-template name="simpleLayoutGroupTemplate"/>
			<xsl:call-template name="PromptSortList">
				<xsl:with-param name="p_refQuery" select="@refQuery"/>
			</xsl:call-template>
			<xsl:variable name="var_cube">
				<xsl:call-template name="getCube">
					<xsl:with-param name="p_queryName" select="@refQuery"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:if test="count(@refQuery) &gt; 0">
				<xsl:element name="propertyList"/>
			</xsl:if>
		</selectWithSearch>
	</xsl:template>
	<xsl:template match="baltic:selectDate">
		<selectDate>
			<xsl:call-template name="PromptCommonAttributes"/>
			<xsl:call-template name="PromptDateAttributes"/>
			<xsl:call-template name="PromptMissingValueAttributes"/>
			<xsl:call-template name="PromptMultiSelectAttributes"/>
			<xsl:call-template name="PromptRangeAttributes"/>
			<xsl:call-template name="NameLayoutAttributes"/>
			<!-- selectDateUI -->
			<xsl:call-template name="addAttr">
				<xsl:with-param name="p_name" select="'selectUI'"/>
				<xsl:with-param name="p_newName" select="'selectDateUI'"/>
				<xsl:with-param name="p_default" select="'calendar'"/>
			</xsl:call-template>
			<xsl:apply-templates select="baltic:useItem"/>
			<xsl:apply-templates select="baltic:defaultSelections"/>
			<xsl:call-template name="simpleLayoutGroupTemplate"/>
		</selectDate>
	</xsl:template>
	<xsl:template match="baltic:selectTime">
		<selectTime>
			<xsl:call-template name="PromptTimeAttributes"/>
			<xsl:call-template name="PromptCommonAttributes"/>
			<xsl:call-template name="PromptMissingValueAttributes"/>
			<xsl:call-template name="PromptMultiSelectAttributes"/>
			<xsl:call-template name="PromptRangeAttributes"/>
			<xsl:call-template name="NameLayoutAttributes"/>
			<!-- selectTimeUI -->
			<xsl:call-template name="addAttr">
				<xsl:with-param name="p_name" select="'selectUI'"/>
				<xsl:with-param name="p_newName" select="'selectTimeUI'"/>
				<xsl:with-param name="p_default" select="'clock'"/>
			</xsl:call-template>
			<xsl:apply-templates select="baltic:useItem"/>
			<xsl:apply-templates select="baltic:defaultSelections"/>
			<xsl:call-template name="simpleLayoutGroupTemplate"/>
		</selectTime>
	</xsl:template>
	<xsl:template match="baltic:selectDateTime">
		<selectDateTime>
			<xsl:call-template name="PromptCommonAttributes"/>
			<xsl:call-template name="PromptMissingValueAttributes"/>
			<xsl:call-template name="PromptMultiSelectAttributes"/>
			<xsl:call-template name="PromptRangeAttributes"/>
			<xsl:call-template name="PromptTimeAttributes"/>
			<xsl:call-template name="PromptDateAttributes"/>
			<xsl:call-template name="NameLayoutAttributes"/>
			<!-- selectDateTimeUI -->
			<xsl:call-template name="addAttr">
				<xsl:with-param name="p_name" select="'selectUI'"/>
				<xsl:with-param name="p_newName" select="'selectDateTimeUI'"/>
				<xsl:with-param name="p_default" select="'calendar'"/>
			</xsl:call-template>
			<xsl:apply-templates select="baltic:useItem"/>
			<xsl:apply-templates select="baltic:defaultSelections"/>
			<xsl:call-template name="simpleLayoutGroupTemplate"/>
		</selectDateTime>
	</xsl:template>
	<xsl:template match="baltic:selectInterval">
		<selectInterval>
			<xsl:call-template name="PromptCommonAttributes"/>
			<xsl:call-template name="PromptMissingValueAttributes"/>
			<xsl:call-template name="PromptMultiSelectAttributes"/>
			<xsl:call-template name="PromptRangeAttributes"/>
			<xsl:call-template name="NameLayoutAttributes"/>
			<!-- showSeconds, showMilliseconds -->
			<xsl:call-template name="addAttr">
				<xsl:with-param name="p_name" select="'showSeconds'"/>
			</xsl:call-template>
			<xsl:call-template name="addAttr">
				<xsl:with-param name="p_name" select="'showMilliseconds'"/>
			</xsl:call-template>
			<xsl:apply-templates select="baltic:useItem"/>
			<xsl:apply-templates select="baltic:defaultSelections"/>
			<xsl:call-template name="simpleLayoutGroupTemplate"/>
		</selectInterval>
	</xsl:template>
	<xsl:template match="baltic:generatedPrompt">
		<generatedPrompt>
			<xsl:call-template name="PromptCommonAttributes"/>
			<xsl:apply-templates select="baltic:useItem"/>
			<xsl:apply-templates select="baltic:defaultSelections"/>
			<xsl:call-template name="simpleLayoutGroupTemplate"/>
		</generatedPrompt>
	</xsl:template>
	<xsl:template match="baltic:promptPageList">
		<promptPages>
			<xsl:apply-templates select="baltic:page"/>
			<xsl:apply-templates select="baltic:useItem"/>
			<xsl:apply-templates select="baltic:defaultSelections"/>
			<xsl:call-template name="simpleLayoutGroupTemplate"/>
		</promptPages>
	</xsl:template>
	<xsl:template match="baltic:useItem">
		<useItem refDataItem="{@refItem}">
			<xsl:apply-templates select="following-sibling::baltic:displayItem | preceding-sibling::baltic:displayItem"/>
		</useItem>
	</xsl:template>
	<xsl:template match="baltic:displayItem">
		<displayItem refDataItem="{@refItem}"/>
	</xsl:template>
	<xsl:template match="baltic:defaultSelections">
		<defaultSelections>
			<xsl:apply-templates select="baltic:defaultSelection"/>
		</defaultSelections>
	</xsl:template>
	<xsl:template match="baltic:defaultSelection">
		<defaultSimpleSelection>
			<xsl:value-of select="."/>
		</defaultSimpleSelection>
	</xsl:template>
	<xsl:template match="baltic:defaultSelections" mode="selectWithSearch">
		<xsl:if test="count(baltic:defaultSelection) &gt; 0">
			<selectOptions>
				<xsl:variable name="v_refVariableExists">
					<xsl:call-template name="checkRefVariableTemplate"/>
				</xsl:variable>
				<xsl:if test="$v_refVariableExists = 'true'">
					<xsl:attribute name="refVariable"><xsl:value-of select="@refVariable"/></xsl:attribute>
				</xsl:if>
				<xsl:for-each select="baltic:defaultSelection">
					<selectOption useValue="{.}"/>
				</xsl:for-each>
			</selectOptions>
		</xsl:if>
	</xsl:template>
	<xsl:template match="baltic:selectOptions">
		<xsl:if test="count(baltic:selectOption) &gt; 0">
			<selectOptions>
				<xsl:variable name="v_refVariableExists">
					<xsl:call-template name="checkRefVariableTemplate"/>
				</xsl:variable>
				<xsl:if test="$v_refVariableExists = 'true'">
					<xsl:attribute name="refVariable"><xsl:value-of select="@refVariable"/></xsl:attribute>
				</xsl:if>
				<xsl:apply-templates select="baltic:selectOption"/>
			</selectOptions>
		</xsl:if>
	</xsl:template>
	<xsl:template match="baltic:selectOption">
		<selectOption>
			<!-- Trakker #529192.1: Copy over the useValue attribute value, even if it is an empty string. -->
			<xsl:if test="@useValue">
				<xsl:attribute name="useValue"><xsl:value-of select="@useValue"/></xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="baltic:displayValue[not(@refVariableValue)]"/>
			<xsl:if test="baltic:displayValue[@refVariableValue]">
				<conditionalDisplayValues>
					<xsl:apply-templates select="baltic:displayValue[@refVariableValue]"/>
				</conditionalDisplayValues>
			</xsl:if>
		</selectOption>
	</xsl:template>
	<xsl:template match="baltic:displayValue[not(@refVariableValue)]">
		<displayValue>
			<xsl:value-of select="@value"/>
		</displayValue>
	</xsl:template>
	<xsl:template match="baltic:displayValue[@refVariableValue]">
		<conditionalDisplayValue refVariableValue="{@refVariableValue}">
			<xsl:value-of select="@value"/>
		</conditionalDisplayValue>
	</xsl:template>
	<xsl:template name="addAttr">
		<xsl:param name="p_name"/>
		<xsl:param name="p_newName" select="$p_name"/>
		<xsl:param name="p_default"/>
		<xsl:variable name="v_attrValue" select="@*[name() = $p_name]"/>
		<xsl:variable name="v_value">
			<xsl:choose>
				<xsl:when test="$v_attrValue != ''">
					<xsl:value-of select="$v_attrValue"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$p_default"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="$v_value != ''">
			<xsl:attribute name="{$p_newName}"><xsl:value-of select="$v_value"/></xsl:attribute>
		</xsl:if>
	</xsl:template>
	<!-- prompt attributes -->
	<xsl:template name="PromptCommonAttributes">
		<xsl:call-template name="addAttr">
			<xsl:with-param name="p_name" select="'parameter'"/>
		</xsl:call-template>
		<xsl:call-template name="addAttr">
			<xsl:with-param name="p_name" select="'required'"/>
		</xsl:call-template>
		<xsl:call-template name="addAttr">
			<xsl:with-param name="p_name" select="'hideAdornments'"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="PromptRangeAttributes">
		<xsl:call-template name="addAttr">
			<xsl:with-param name="p_name" select="'range'"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="PromptMultiSelectAttributes">
		<xsl:call-template name="addAttr">
			<xsl:with-param name="p_name" select="'multiSelect'"/>
			<xsl:with-param name="p_default" select="'false'"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="PromptMissingValueAttributes">
		<xsl:call-template name="addAttr">
			<xsl:with-param name="p_name" select="'allowIsMissing'"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="PromptDateAttributes">
		<xsl:call-template name="addAttr">
			<xsl:with-param name="p_name" select="'calendar'"/>
			<xsl:with-param name="p_default" select="'Gregorian'"/>
		</xsl:call-template>
		<xsl:call-template name="addAttr">
			<xsl:with-param name="p_name" select="'firstDate'"/>
		</xsl:call-template>
		<xsl:call-template name="addAttr">
			<xsl:with-param name="p_name" select="'lastDate'"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="PromptTimeAttributes">
		<xsl:call-template name="addAttr">
			<xsl:with-param name="p_name" select="'mode'"/>
			<xsl:with-param name="p_newName" select="'clockMode'"/>
			<xsl:with-param name="p_default" select="'static'"/>
		</xsl:call-template>
		<xsl:call-template name="addAttr">
			<xsl:with-param name="p_name" select="'showSeconds'"/>
		</xsl:call-template>
		<xsl:call-template name="addAttr">
			<xsl:with-param name="p_name" select="'showMilliseconds'"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="PromptDataDrivenAttributes">
		<xsl:call-template name="addAttr">
			<xsl:with-param name="p_name" select="'rowsPerPage'"/>
			<xsl:with-param name="p_default" select="'5000'"/>
		</xsl:call-template>
		<xsl:call-template name="addAttr">
			<xsl:with-param name="p_name" select="'cascadeOn'"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="NameLayoutAttributes">
		<xsl:call-template name="addAttr">
			<xsl:with-param name="p_name" select="'id'"/>
			<xsl:with-param name="p_newName" select="'name'"/>
		</xsl:call-template>
	</xsl:template>
	<!-- 
    *  Output the sorting element that will be within the prompt element.
    *  @param p_refQuery Name of the Baltic query that we will be generating the 
    *  	sort list for.
   -->
	<xsl:template name="PromptSortList">
		<xsl:param name="p_refQuery"/>
		<xsl:variable name="var_cube">
			<xsl:call-template name="getCube">
				<xsl:with-param name="p_queryName" select="$p_refQuery"/>
			</xsl:call-template>
		</xsl:variable>
		<sortList>
			<xsl:apply-templates select="$var_cube/baltic:cube/*/baltic:level/baltic:item" mode="generate_sortItems"/>
			<xsl:apply-templates select="$var_cube/baltic:cube/baltic:factList/baltic:item" mode="generate_sortItems"/>
		</sortList>
	</xsl:template>
	<!-- 
      *   If the prompt buttons are not present on the page then generate the default buttons. 
      *   in the pages footer.
       *
	   * p_page Prompt page we are working on
      -->
	<xsl:template name="promptPageFooter">
		<xsl:param name="p_page"/>
		<xsl:variable name="v_buttons" select="count($p_page/descendant::baltic:promptButton)"/>
		<xsl:choose>
			<xsl:when test="$v_buttons">
				<!-- The page has at least one prompt button, do not change anything. -->
				<xsl:apply-templates select="$p_page/baltic:pageFooter"/>
			</xsl:when>
			<xsl:otherwise>
				<!-- page has no prompt buttons, so add the defaults. -->
				<xsl:element name="pageFooter">
					<xsl:element name="contents">
						<xsl:choose>
							<xsl:when test="$p_page/baltic:pageFooter">
								<!-- There was a previous page footer.  Wrap its contents into a table row, and put the
                               * default buttons under it.
                               -->
								<table class="tb">
									<tableRows>
										<tableRow>
											<tableCells>
												<tableCell>
													<xsl:for-each select="$p_page/baltic:pageFooter">
														<xsl:call-template name="pageFooterBody"/>
													</xsl:for-each>
												</tableCell>
											</tableCells>
										</tableRow>
										<tableRow>
											<tableCells>
												<tableCell>
													<contents>
														<xsl:call-template name="genDefaultPromptButtons"/>
													</contents>
												</tableCell>
											</tableCells>
										</tableRow>
									</tableRows>
								</table>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="genDefaultPromptButtons"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:element>
				</xsl:element>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Output the default prompt buttons -->
	<xsl:template name="genDefaultPromptButtons">
		<promptButton type="cancel" class="bp">
			<contents/>
			<style>
				<CSS value="margin-right:7px"/>
			</style>
		</promptButton>
		<promptButton type="back" class="bp">
			<contents/>
			<style>
				<CSS value="margin-right:7px"/>
			</style>
		</promptButton>
		<promptButton type="next" class="bp">
			<contents/>
			<style>
				<CSS value="margin-right:7px"/>
			</style>
		</promptButton>
		<promptButton type="finish" class="bp">
			<contents/>
		</promptButton>
	</xsl:template>
</xsl:stylesheet>
