<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl">
	<xsl:template name="radarChartTemplate">
		<radarChart>
			<xsl:if test="baltic:radarChart/@radarType">
				<xsl:attribute name="radarType"><xsl:variable name="v_radarType" select="baltic:radarChart/@radarType"/><xsl:choose><xsl:when test="$v_radarType = 'absoluteLine'">line</xsl:when><xsl:when test="$v_radarType = 'absoluteArea'">area</xsl:when><xsl:when test="$v_radarType = 'stackedArea'">stackedArea</xsl:when></xsl:choose></xsl:attribute>
			</xsl:if>
			<xsl:if test="baltic:radarChart/@spider = 'true'">
				<xsl:attribute name="useSpiderEffects">true</xsl:attribute>
			</xsl:if>
			<xsl:call-template name="chartMarkerTemplate">
				<xsl:with-param name="p_chart" select="baltic:radarChart"/>
			</xsl:call-template>
			<xsl:call-template name="standardChartAttributesTemplate"/>
			<xsl:call-template name="generateMasterDetailLinks2">
				<xsl:with-param name="p_frame" select="."/>
			</xsl:call-template>
			<xsl:call-template name="legendTemplate"/>
			<xsl:call-template name="axisRadarTemplate"/>
			<xsl:call-template name="pointsAndPointClustersTemplate">
				<xsl:with-param name="p_radialClusters" select="'true'"/>
				<xsl:with-param name="p_checkMeasures" select="'never'"/>
			</xsl:call-template>
			<radialMeasure refDataItem="{baltic:chartMeasure/baltic:member/@refMember}"/>
			<xsl:call-template name="commonChartTemplate"/>
			<xsl:call-template name="commonChartMarkerTemplate"/>
			<xsl:call-template name="commonChartBaselineTemplate">
				<xsl:with-param name="chartType" select="'radarChart'"/>
			</xsl:call-template>
		</radarChart>
	</xsl:template>
	<xsl:template name="axisRadarTemplate">
		<xsl:for-each select="baltic:axis">
			<xsl:variable name="v_axisPosition" select="@axisPosition"/>
			<xsl:choose>
				<xsl:when test="$v_axisPosition = 'X'">
					<xsl:call-template name="ordinalAxis">
						<!--can never turn off the gridlines in Baltic, therefore carry over to Bering-->						
						<xsl:with-param name="p_gridLines" select="1"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$v_axisPosition = 'Y1'">
					<numericalAxisRadial>
						<xsl:call-template name="copyAxisAttsTemplate"/>
						<xsl:call-template name="axisTitleTemplate"/>
						<xsl:call-template name="gridlinesTemplate">
							<xsl:with-param name="p_chart" select=".."/>
						</xsl:call-template>
						<xsl:call-template name="mergeStylesFromAxisAndAxisLabelsTemplate"/>
					</numericalAxisRadial>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
