<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl">
	<xsl:template match="baltic:repeater">
		<repeaterTable>
			<!-- originalRefQuery is used by the property list adjuster and will be removed later on. -->
			<xsl:attribute name="originalRefQuery"><xsl:value-of select="@refQuery"/></xsl:attribute>
			<!-- Start of repeaterTable attributes. -->
			<xsl:variable name="var_refQuery" select="@refQuery"/>
			<xsl:variable name="var_beringRefQuery">
				<xsl:call-template name="getQueryTemplate">
					<xsl:with-param name="refQuery" select="$var_refQuery"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:attribute name="refQuery"><xsl:value-of select="$var_beringRefQuery"/></xsl:attribute>
			<xsl:if test="count(@across) = 1">
				<xsl:attribute name="across"><xsl:value-of select="@across"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="count(@down) = 1">
				<xsl:attribute name="down"><xsl:value-of select="@down"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="count(@direction) = 1">
				<xsl:attribute name="direction"><xsl:value-of select="@direction"/></xsl:attribute>
			</xsl:if>
			<xsl:call-template name="addStyle"/>
			<xsl:if test="count(@id) = 1">
				<xsl:attribute name="name"><xsl:value-of select="@id"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="count(@repeatEveryPage) = 1">
				<xsl:attribute name="repeatEveryPage"><xsl:value-of select="@repeatEveryPage"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="count(@shareResultSet) = 1">
				<xsl:attribute name="shareResultSet"><xsl:value-of select="@shareResultSet"/></xsl:attribute>
			</xsl:if>
			<!-- End of repeaterTable attributes. -->
			<xsl:call-template name="generateMasterDetailLinks2">
				<xsl:with-param name="p_frame" select="."/>
			</xsl:call-template>
			<xsl:apply-templates select="baltic:repeaterBody"/>
			<!-- The structure of the V5 repeaterTable grouping is derived from the V4 Cube Dimension Levels. -->
			<xsl:apply-templates select="/baltic:report/baltic:querySet/baltic:BIQuery[@name=$var_refQuery]" mode="repeater">
				<xsl:with-param name="p_refLevel" select="@refLevel"/>
			</xsl:apply-templates>
			<xsl:call-template name="simpleLayoutGroupTemplate"/>
			<xsl:variable name="v_cube">
				<xsl:call-template name="getCube">
					<xsl:with-param name="p_queryName" select="$var_refQuery"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:element name="propertyList"/>
		</repeaterTable>
	</xsl:template>
	<xsl:template match="baltic:repeaterBody">
		<repeaterTableCell>
			<xsl:call-template name="addStyle"/>
			<xsl:call-template name="layoutContainerTemplate"/>
		</repeaterTableCell>
	</xsl:template>
	<!-- Start of templates that generate repeaterGroups. -->
	<xsl:template match="/baltic:report/baltic:querySet/baltic:BIQuery" mode="repeater">
		<xsl:param name="p_refLevel" select="''"/>
		<xsl:variable name="var_cube">
			<xsl:call-template name="getCubeOrCubeReference"/>
		</xsl:variable>
		<xsl:variable name="var_repeaterGroups">
			<xsl:choose>
				<xsl:when test="$p_refLevel != ''">
					<xsl:for-each select="$var_cube/baltic:cube/baltic:dimension/baltic:level[@name=$p_refLevel]/preceding-sibling::baltic:level">
						<xsl:apply-templates select="." mode="repeater"/>
					</xsl:for-each>
					<xsl:apply-templates select="$var_cube/baltic:cube/baltic:dimension/baltic:level[@name=$p_refLevel]" mode="repeater"/>
				</xsl:when>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="$var_repeaterGroups/*">
			<repeaterGroups>
				<xsl:copy-of select="$var_repeaterGroups"/>
			</repeaterGroups>
		</xsl:if>
		<!-- Generate the sortList from the baltic:cube/baltic:factList/baltic:item sort attributes. -->
		<!-- Also, if there is no level specified, also generate the sortList from the baltic:cube/baltic:dimension/baltic:level/baltic:item sort attributes. -->
		<sortList>
			<xsl:choose>
				<xsl:when test="$p_refLevel != ''">
					<xsl:apply-templates select="$var_cube/baltic:cube/baltic:factList/baltic:item" mode="generate_sortItems"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="$var_cube/baltic:cube/baltic:dimension/baltic:level/baltic:item" mode="generate_sortItems"/>
					<xsl:apply-templates select="$var_cube/baltic:cube/baltic:factList/baltic:item" mode="generate_sortItems"/>
				</xsl:otherwise>
			</xsl:choose>
		</sortList>
	</xsl:template>
	<xsl:template match="baltic:cube/baltic:dimension/baltic:level" mode="repeater">
		<xsl:param name="p_repeater"/>
		<xsl:variable name="var_refLevel" select="@name"/>
		<xsl:variable name="v_refDataItem">
			<xsl:call-template name="getKeyItemNameForLevel"/>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$v_refDataItem='ERROR: Cannot find item or dataItem for the level referenced.'">
				<xsl:comment>
					<xsl:call-template name="logError2">
						<xsl:with-param name="p_msgId" select="'RSU_SPC_LEVEL_KEYITEM_MISSING'"/>
						<xsl:with-param name="p_param1" select="'pageGroup'"/>
						<xsl:with-param name="p_param2" select="$var_refLevel"/>
					</xsl:call-template>
				</xsl:comment>
			</xsl:when>
			<xsl:otherwise>
				<repeaterGroup refDataItem="{$v_refDataItem}">
					<!-- Generate sortList from the baltic:item sort attributes up to this level in the current dimension. -->
					<sortList>
						<xsl:apply-templates select="baltic:item" mode="generate_sortItems"/>
					</sortList>
					<xsl:element name="propertyList"/>
				</repeaterGroup>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- End of templates that generate repeaterGroups. -->
</xsl:stylesheet>
