<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" xmlns:qfw="java:com.qfw.V4toV5.V4toV5QuerySet" extension-element-prefixes="xalan java date exsl qfw" exclude-result-prefixes="xalan java baltic date exsl qfw">
	<xsl:template match="baltic:report">
		<xsl:if test="$var_transformationTimeStamp != ''">
			<xsl:comment>
				<xsl:copy-of select="$var_transformationTimeStamp"/>
			</xsl:comment>
		</xsl:if>
		<report>
			<!-- 
			<xsl:attribute name="expressionLocale"><xsl:value-of select="@lang"/></xsl:attribute>
             Does not seem to work when using a DOM document as source.  So we use the for-each below.
-->
			<xsl:for-each select="@*">
				<xsl:if test="name(.) = 'xml:lang'">
					<xsl:attribute name="expressionLocale"><xsl:value-of select="."/></xsl:attribute>
				</xsl:if>
			</xsl:for-each>
			<!-- WO1174 - Baltic Report Styles in Bering -->
			<xsl:attribute name="useStyleVersion"><xsl:value-of select="1"/></xsl:attribute>
			<!-- Trakker 531850.2.  Set interactivePageBreakByFrame attribute to true to maintain Baltic behavior. -->
			<xsl:attribute name="interactivePageBreakByFrame">true</xsl:attribute>
			<xsl:if test="$var_modelConnection != ''">
				<modelPath>
					<xsl:value-of select="$var_modelConnection"/>
				</modelPath>
			</xsl:if>
			<!-- 
				If the upgraded queries element is not empty, 
					Copy the upgraded queries. 
					Modify queries by adding new data items 
					for each level header and footer. 
			-->
			<xsl:choose>
				<xsl:when test="/baltic:report/ret">
					<xsl:if test="count( /baltic:report/ret/node()[local-name()='queries']/node()[local-name()='query'] ) &gt; 0">
						<xsl:apply-templates select="/baltic:report/ret/node()[local-name()='queries']" mode="q">
							<xsl:with-param name="p_report" select="."/>
						</xsl:apply-templates>
					</xsl:if>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="count( //*[local-name()='queries']/node()[local-name()='query'] ) &gt; 0">
						<xsl:apply-templates select="//*[local-name()='queries']" mode="q">
							<xsl:with-param name="p_report" select="."/>
						</xsl:apply-templates>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:apply-templates select="baltic:layoutList"/>
			<xsl:apply-templates select="baltic:variableList"/>
			<xsl:apply-templates select="baltic:burst"/>
			<xsl:if test="count(baltic:XMLAttribute) &gt; 0">
				<xsl:variable name="var_XMLAttributes">
					<xsl:apply-templates select="baltic:XMLAttribute"/>
				</xsl:variable>
				<XMLAttributes>
					<xsl:copy-of select="$var_XMLAttributes"/>
				</XMLAttributes>
			</xsl:if>
			<!-- 
				upgradeInfo is a Cognos8 element used for reporting errors.
				This rule allows the upgradeInfo to be transferred to the Bering specification
				for further processing.
			-->
			<xsl:apply-templates select="baltic:upgradeInfo" mode="upgradeInfo"/>
			<!--
			    Copy over th baltic query section so we can use it during later processing steps.
			 -->
			<xsl:copy-of select="/baltic:report/baltic:querySet"/>
			<!-- copy over the QFW upgrade information for use in intermediate stages.  It will be removed
                    during post processing.
            -->
			<xsl:copy-of select="/baltic:report/ret"/>
		</report>
	</xsl:template>
	<xsl:template match="baltic:modelConnection">
		<source>
			<model>
				<xsl:variable name="v_name" select="/baltic:report/baltic:metadataModel/baltic:value/baltic:item/baltic:searchPath/baltic:value"/>
				<xsl:choose>
					<xsl:when test="$v_name != ''">
						<xsl:value-of select="$v_name"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="@name"/>
					</xsl:otherwise>
				</xsl:choose>
			</model>
		</source>
	</xsl:template>
	<xsl:template name="notImplemented">
		<xsl:param name="p_target"/>
		<xsl:text>&#10;</xsl:text>
		<xsl:comment>
			<xsl:text> NOTE: Migration of "</xsl:text>
			<xsl:copy-of select="$p_target"/>
			<xsl:text>" has not been implemented yet. </xsl:text>
		</xsl:comment>
		<xsl:text>&#10;</xsl:text>
	</xsl:template>
	<!-- Copy over the query.  If it does not have a detailFilters
 * section, and there are some from master/details then add 
 * a new detailFilters section.
  -->
	<xsl:template match="*[local-name()='query']" mode="q">
		<xsl:param name="p_report"/>
		<xsl:element name="query">
			<xsl:for-each select="@*">
				<xsl:attribute name="{name(.)}"><xsl:value-of select="."/></xsl:attribute>
			</xsl:for-each>
			<xsl:apply-templates mode="q">
				<xsl:with-param name="p_report">
					<xsl:copy-of select="$p_report"/>
				</xsl:with-param>
			</xsl:apply-templates>
			<xsl:if test="count(./node()[local-name()='detailFilters']) = 0">
				<xsl:call-template name="generateMasterDetailFilters">
					<xsl:with-param name="p_detailQueryName" select="@name"/>
				</xsl:call-template>
			</xsl:if>
		</xsl:element>
	</xsl:template>
	<!-- Copy over the detailFilters section.
  *  Add any new filters from master/details.
  -->
	<xsl:template match="*[local-name()='detailFilters']" mode="q">
		<xsl:param name="p_report"/>
		<xsl:element name="detailFilters">
			<xsl:for-each select="@*">
				<xsl:attribute name="{name(.)}"><xsl:value-of select="."/></xsl:attribute>
			</xsl:for-each>
			<xsl:apply-templates mode="q">
				<xsl:with-param name="p_report">
					<xsl:copy-of select="$p_report"/>
				</xsl:with-param>
			</xsl:apply-templates>
			<xsl:call-template name="generateMasterDetailFilter">
				<xsl:with-param name="p_detailQueryName" select="../@name"/>
			</xsl:call-template>
		</xsl:element>
	</xsl:template>
	<!--
		Copy all elements under queries element from the migrated query set. 
		Copy all attributes as well. 
	-->
	<xsl:template match="*" mode="q">
		<xsl:param name="p_report"/>
		<xsl:copy>
			<xsl:for-each select="@*">
				<xsl:attribute name="{name(.)}"><xsl:value-of select="."/></xsl:attribute>
			</xsl:for-each>
			<xsl:apply-templates mode="q">
				<xsl:with-param name="p_report">
					<xsl:copy-of select="$p_report"/>
				</xsl:with-param>
			</xsl:apply-templates>
		</xsl:copy>
	</xsl:template>
	<!-- 
		Add new data items under selection for each level header and footer. 
	-->
	<xsl:template match="*[local-name()='selection']" mode="q">
		<xsl:param name="p_report"/>
		<xsl:copy>
			<xsl:for-each select="attribute::*">
				<xsl:copy/>
			</xsl:for-each>
			<xsl:apply-templates mode="q"/>
			<xsl:call-template name="addItems">
				<xsl:with-param name="p_queryName">
					<xsl:value-of select="../@name"/>
				</xsl:with-param>
				<xsl:with-param name="p_report">
					<xsl:copy-of select="$p_report"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:copy>
	</xsl:template>
	<xsl:template name="addItems">
		<xsl:param name="p_queryName"/>
		<xsl:param name="p_report"/>
		<!-- Add a new dataItem for each crosstab header or footer that references the specifed query. -->
		<!--<xsl:comment>
			<xsl:text>Adding H/F dataitems to query: "</xsl:text>
			<xsl:value-of select="$p_queryName"/>
			<xsl:text>".</xsl:text>
		</xsl:comment>-->
		<xsl:apply-templates select="$p_report//baltic:crosstab[@refQuery=$p_queryName]//baltic:levelHeader | $p_report//baltic:crosstab[@refQuery=$p_queryName]//baltic:levelFooter" mode="q">
			<xsl:with-param name="p_report">
				<xsl:copy-of select="$p_report"/>
			</xsl:with-param>
		</xsl:apply-templates>
		<!-- Now do the same for the headers and footers in crosstabs that reference v4 queries that have been mapped to a new v5 query. -->
		<xsl:choose>
			<xsl:when test="/baltic:report/ret">
				<xsl:for-each select="/baltic:report/ret/theMap/node()[local-name()='queryMap' and @equiv=$p_queryName]/@ignored">
					<xsl:variable name="v_v4queryName" select="."/>
					<!--<xsl:comment>
						<xsl:text>Adding H/F dataitems to query: "</xsl:text>
						<xsl:value-of select="$p_queryName"/>
						<xsl:text>" that come from the V4 BIQuery: "</xsl:text>
						<xsl:value-of select="$v_v4queryName"/>
						<xsl:text>".</xsl:text>
					</xsl:comment>-->
					<xsl:apply-templates select="$p_report//baltic:crosstab[@refQuery=$v_v4queryName]//baltic:levelHeader | $p_report//baltic:crosstab[@refQuery=$v_v4queryName]//baltic:levelFooter" mode="q">
						<xsl:with-param name="p_report">
							<xsl:copy-of select="$p_report"/>
						</xsl:with-param>
					</xsl:apply-templates>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:for-each select="//*[local-name()='queryMap' and @equiv=$p_queryName]/@ignored">
					<xsl:variable name="v_v4queryName" select="."/>
					<!--<xsl:comment>
						<xsl:text>Adding H/F dataitems to query: "</xsl:text>
						<xsl:value-of select="$p_queryName"/>
						<xsl:text>" that come from the V4 BIQuery: "</xsl:text>
						<xsl:value-of select="$v_v4queryName"/>
						<xsl:text>".</xsl:text>
					</xsl:comment>-->
					<xsl:apply-templates select="$p_report//baltic:crosstab[@refQuery=$v_v4queryName]//baltic:levelHeader | $p_report//baltic:crosstab[@refQuery=$v_v4queryName]//baltic:levelFooter" mode="q">
						<xsl:with-param name="p_report">
							<xsl:copy-of select="$p_report"/>
						</xsl:with-param>
					</xsl:apply-templates>
				</xsl:for-each>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="baltic:levelHeader | baltic:levelFooter" mode="q">
		<xsl:param name="p_report"/>
		<xsl:variable name="v_name">
			<xsl:call-template name="getItemNameFromLevelReference">
				<xsl:with-param name="p_queryName" select="ancestor::baltic:crosstab[1]/@refQuery"/>
				<xsl:with-param name="p_levelRef" select="../@refLevel"/>
			</xsl:call-template>
		</xsl:variable>
		<dataItem name="aggregate({$v_name})">
			<expression>aggregate(currentMeasure within detail [<xsl:value-of select="$v_name"/>])</expression>
		</dataItem>
	</xsl:template>
	<!-- 
  *   Return the name of the query that should be used.
  *   @param refQuery Name of the query that is being looked up.
  *   @return If the refQuery is being ignored, then return the name of the 
  *      equivelent query. Otherwise return refQuery
  -->
	<xsl:template name="getQueryTemplate">
		<xsl:param name="refQuery"/>
		<xsl:variable name="v_refQuery">
			<xsl:choose>
				<xsl:when test="/baltic:report/ret">
					<xsl:value-of select="/baltic:report/ret/theMap/node()[local-name()='queryMap' and @ignored=$refQuery]/@equiv"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="//*[local-name()='queryMap' and @ignored=$refQuery]/@equiv"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$v_refQuery != ''">
				<xsl:value-of select="$v_refQuery"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$refQuery"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- -->
	<xsl:template name="getCubeOrCubeReference">
		<xsl:param name="p_queryNode" select="."/>
		<xsl:choose>
			<xsl:when test="$p_queryNode/baltic:cube">
				<!--<xsl:comment>Query <xsl:value-of select="$p_queryNode/@name"/> has a cube.</xsl:comment>-->
				<xsl:copy-of select="$p_queryNode/baltic:cube"/>
			</xsl:when>
			<xsl:when test="$p_queryNode/baltic:cubeReference">
				<xsl:variable name="v_refQuery" select="$p_queryNode/baltic:cubeReference/@refQuery"/>
				<!--<xsl:comment>Query <xsl:value-of select="$p_queryNode/@name"/> has a cubeReference to Query <xsl:value-of select="$v_refQuery"/>.</xsl:comment>-->
				<xsl:copy-of select="/baltic:report/baltic:querySet/baltic:BIQuery[@name=$v_refQuery]/baltic:cube"/>
			</xsl:when>
			<!--<xsl:otherwise>
				<xsl:comment>Query <xsl:value-of select="$p_queryNode/@name"/> has no cube or cubeReference.</xsl:comment>
			</xsl:otherwise>-->
		</xsl:choose>
	</xsl:template>
	<!-- Retrieve the cube that goes with a query name.
     * If the query names uses a cube reference, then the
     * derefenced cube is returned.
     *
     * p_queryName Name of the query to use for looking up
     * the cube.
    -->
	<xsl:template name="getCube">
		<xsl:param name="p_queryName"/>
		<xsl:call-template name="getCubeOrCubeReference">
			<xsl:with-param name="p_queryNode" select="/baltic:report/baltic:querySet/baltic:BIQuery[@name=$p_queryName]"/>
		</xsl:call-template>
	</xsl:template>
	<!-- A hard coded message is returned if the key cannot be found 
        * Other templates detect this error message and react to it.
        -->
	<xsl:template name="getKeyItemNameForLevel">
		<xsl:param name="p_level" select="."/>
		<xsl:variable name="v_itemName">
			<xsl:variable name="v_name" select="$p_level/baltic:dataItem[@key='true']/@name"/>
			<xsl:variable name="v_alias" select="$p_level/baltic:item[@key='true']/@alias"/>
			<xsl:variable name="v_refItem" select="$p_level/baltic:item[@key='true']/@refItem"/>
			<xsl:choose>
				<xsl:when test="$v_name!=''">
					<xsl:value-of select="$v_name"/>
				</xsl:when>
				<xsl:when test="$v_alias != ''">
					<xsl:value-of select="$v_alias"/>
				</xsl:when>
				<xsl:when test="$v_refItem != ''">
					<xsl:value-of select="$v_refItem"/>
				</xsl:when>
				<xsl:when test="$p_level/baltic:dataItem/@name">
					<xsl:value-of select="$p_level/baltic:dataItem/@name"/>
				</xsl:when>
				<xsl:when test="$p_level/baltic:item/@alias">
					<xsl:value-of select="$p_level/baltic:item/@alias"/>
				</xsl:when>
				<xsl:when test="$p_level/baltic:item/@refItem">
					<xsl:value-of select="$p_level/baltic:item/@refItem"/>
				</xsl:when>
				<xsl:otherwise>
					<!-- Do NOT log this as an error.  There is code that will accept the error and
                          * still produce valid reports.  
						  * see test case //rspecupgrade/bering/main/rspecupgrade/testdata/V4QSAccept/masters/V5DebugNormalizedReportSpecs/RSUpgrade_v4_QSAccept_21.xml
                          *
                          * See trakker 533492.2 for a gotcha.  Levels without data items or items may not run
                          * correctly in Baltic.
                          -->
					<xsl:value-of select="'ERROR: Cannot find item or dataItem for the level referenced.'"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:value-of select="$v_itemName"/>
	</xsl:template>
	<!-- A hard coded message is returned if the item cannot be found 
        * Other templates detect this error message and react to it.
        * @see getKeyItemNameForLevel
         -->
	<xsl:template name="getItemNameFromLevelReference">
		<xsl:param name="p_queryName"/>
		<xsl:param name="p_levelRef"/>
		<xsl:variable name="var_cube">
			<xsl:call-template name="getCubeOrCubeReference">
				<xsl:with-param name="p_queryNode" select="/baltic:report/baltic:querySet/baltic:BIQuery[@name=$p_queryName]"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="v_refDataItem">
			<xsl:call-template name="getKeyItemNameForLevel">
				<xsl:with-param name="p_level" select="$var_cube/baltic:cube/baltic:dimension/baltic:level[@name=$p_levelRef]"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:value-of select="$v_refDataItem"/>
	</xsl:template>
	<!-- sortItem is the sortOrder attribute value in the item, or if that is 
         * not set, then it is the  value of the sort attribute in the tabular model.
        *  At the point this template is being matched we have a doc fragment
        * with the item as its root, and we cannot go up to look at the tabular
        * model.  All the data items will be entered with some sortOrder 
        * attribute cleaned up in  a different pass.
         -->
	<xsl:template match="baltic:item" mode="generate_sortItems">
		<!-- later passes will handle the case where there is no sorting.  
             * sortOrder being empty signifies that the tabular model is to be examined.
            *  sortOrder being "none" indicates we have examined the sort order, and no tabular model lookup is needed.
            -->
		<xsl:variable name="v_itemName">
			<xsl:choose>
				<xsl:when test="@alias">
					<xsl:value-of select="@alias"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="@refItem"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<sortItem refDataItem="{$v_itemName}" originalRefItem="{@refItem}" sortOrder="{@sort}"/>
	</xsl:template>
	<!-- Copy over all of the upgradeInfo element -->
	<xsl:template match="*" mode="upgradeInfo">
		<xsl:element name="{name()}">
			<xsl:for-each select="@*">
				<xsl:attribute name="{name(.)}"><xsl:value-of select="."/></xsl:attribute>
			</xsl:for-each>
			<xsl:apply-templates mode="upgradeInfo"/>
		</xsl:element>
	</xsl:template>
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<!-- Copy all comments.                                                                                                      -->
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<xsl:template match="comment()">
		<xsl:copy-of select="."/>
	</xsl:template>
</xsl:stylesheet>
