<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->

<!--
*
*  Produces a v5 report specification with a schema location to the report
*  can be validated. Input is a v5 report specification.
*
*  Used for testing only, since report studio will reject reports with
*  the schema directive.
*
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns:bering="http://developer.cognos.com/schemas/report/2.0/" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" xmlns:qfw="java:com.qfw.V4toV5.V4toV5QuerySet" extension-element-prefixes="xalan java date exsl qfw" exclude-result-prefixes="xalan java baltic date exsl qfw">
	<xsl:output method="xml"/>
	<!-- URI where the schema is located. -->
	<xsl:param name="p_schemaLocation_uri" select="'ERROR p_schemaLocation_uri must be defined.'"/>
	<xsl:template match="/bering:report">
		<bering:report>
			<xsl:attribute name="xmlns:xsi">http://www.w3.org/2001/XMLSchema-instance</xsl:attribute>
			<xsl:attribute name="xsi:schemaLocation">http://developer.cognos.com/schemas/report/2.0/ <xsl:value-of select="$p_schemaLocation_uri"/></xsl:attribute>
			<xsl:for-each select="@*">
				<xsl:copy-of select="."/>
			</xsl:for-each>
			<xsl:apply-templates/>
		</bering:report>
	</xsl:template>
	<!-- Copy anything that is unmatched over to output. -->
	<xsl:template match="@*|node()">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
