<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl">
	<xsl:template match="baltic:conditionalStyle">
		<xsl:param name="p_recursive"/>
		<xsl:if test="baltic:style/@refVariableValue">
			<conditionalStyles>
				<conditionalStyleCases refVariable="{@refVariable}">
					<xsl:apply-templates select="baltic:style[@refVariableValue]">
						<xsl:with-param name="p_recursive" select="$p_recursive"/>
					</xsl:apply-templates>
				</conditionalStyleCases>
				<conditionalStyleDefault>
					<xsl:apply-templates select="baltic:style[not(@refVariableValue)]">
						<xsl:with-param name="p_recursive" select="$p_recursive"/>
					</xsl:apply-templates>
				</conditionalStyleDefault>
			</conditionalStyles>
		</xsl:if>
	</xsl:template>
	<xsl:template match="baltic:style[not(@refVariableValue)]">
		<xsl:param name="p_recursive"/>
		<xsl:param name="p_addValue" select="''"/>
		<xsl:param name="p_prependValue" select="''"/>
		<style>
			<!-- NOTE: The refStyle attribute of the V4 style element was never supported, so it is dropped in v5. -->
			<xsl:call-template name="formatGroupTemplate">
				<xsl:with-param name="p_recursive" select="$p_recursive"/>
			</xsl:call-template>
			<xsl:choose>
				<xsl:when test="baltic:CSS">
					<xsl:apply-templates select="baltic:CSS">
						<xsl:with-param name="p_addValue" select="$p_addValue"/>
						<xsl:with-param name="p_prependValue" select="$p_prependValue"/>
					</xsl:apply-templates>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="$p_addValue != ''">
							<CSS>
								<xsl:attribute name="value"><xsl:value-of select="$p_addValue"/></xsl:attribute>
							</CSS>
						</xsl:when>
						<xsl:when test="$p_prependValue != ''">
							<CSS>
								<xsl:attribute name="value"><xsl:value-of select="$p_prependValue"/></xsl:attribute>
							</CSS>
						</xsl:when>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</style>
	</xsl:template>
	<xsl:template match="baltic:conditionalStyle/baltic:style[not(@refVariableValue)]">
		<xsl:param name="p_recursive"/>
		<!-- NOTE: The refStyle attribute of the V4 style element was never supported, so it is dropped in v5. -->
		<xsl:call-template name="formatGroupTemplate">
			<xsl:with-param name="p_recursive" select="$p_recursive"/>
		</xsl:call-template>
		<xsl:apply-templates select="baltic:CSS"/>
	</xsl:template>
	<xsl:template match="baltic:style[@refVariableValue]">
		<xsl:param name="p_recursive"/>
		<xsl:param name="p_addValue" select="''"/>
		<xsl:param name="p_prependValue" select="''"/>
		<conditionalStyle refVariableValue="{@refVariableValue}">
			<!-- NOTE: The refStyle attribute of the V4 style element was never supported, so it is dropped in v5. -->
			<xsl:call-template name="formatGroupTemplate">
				<xsl:with-param name="p_recursive" select="$p_recursive"/>
			</xsl:call-template>
			<xsl:choose>
				<xsl:when test="baltic:CSS">
					<xsl:apply-templates select="baltic:CSS">
						<xsl:with-param name="p_addValue" select="$p_addValue"/>
						<xsl:with-param name="p_prependValue" select="$p_prependValue"/>
					</xsl:apply-templates>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="$p_addValue != ''">
							<CSS>
								<xsl:attribute name="value"><xsl:value-of select="$p_addValue"/></xsl:attribute>
							</CSS>
						</xsl:when>
						<xsl:when test="$p_prependValue != ''">
							<CSS>
								<xsl:attribute name="value"><xsl:value-of select="$p_prependValue"/></xsl:attribute>
							</CSS>
						</xsl:when>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</conditionalStyle>
	</xsl:template>
	<xsl:template match="baltic:XMLAttribute">
		<XMLAttribute>
			<xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute>
			<xsl:if test="@render">
				<xsl:attribute name="render"><xsl:value-of select="@render"/></xsl:attribute>
			</xsl:if>
		</XMLAttribute>
	</xsl:template>
	<xsl:template match="baltic:CSS">
		<xsl:param name="p_addValue" select="''"/>
		<xsl:param name="p_prependValue" select="''"/>
		<CSS>
			<xsl:attribute name="value">
				<xsl:if test="$p_prependValue != ''"><xsl:value-of select="$p_prependValue"/>;</xsl:if>
				<xsl:value-of select="@value"/>
				<xsl:if test="$p_addValue != ''">;<xsl:value-of select="$p_addValue"/></xsl:if>
			</xsl:attribute>
		</CSS>
	</xsl:template>
	<xsl:template name="checkRefVariableTemplate">
		<xsl:param name="p_cur" select="."/>
		<xsl:variable name="v_refVariable" select="$p_cur/@refVariable"/>
		<xsl:if test="/baltic:report/baltic:variableList/baltic:variable[@name=$v_refVariable]">true</xsl:if>
	</xsl:template>
</xsl:stylesheet>
