<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl">
	<!-- Assign class attribute based on Bering default from RSUpgradeStyleMap.xml	-->
	<xsl:template name="addStyle">
		<xsl:param name="el" select="."/>
		<xsl:param name="for" select="local-name($el)"/>
		<xsl:param name="default" select="'true'"/>
		<xsl:variable name="v_class">
			<xsl:value-of select="$el/@class"/>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$v_class != ''">
				<xsl:variable name="v_mappedClass">
					<xsl:value-of select="$var_styles//s[@for = $v_class]/@name"/>
				</xsl:variable>
				<xsl:choose>
					<xsl:when test="$v_mappedClass != ''">
						<xsl:attribute name="class"><xsl:value-of select="$v_mappedClass"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="class"><xsl:value-of select="$v_class"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<!-- No class attribute has been specified on the baltic element. -->
				<xsl:if test="$default = 'true'">
					<xsl:variable name="v_mappedClass">
						<xsl:value-of select="$var_styles//s[@for = $for]/@name"/>
					</xsl:variable>
					<xsl:if test="$v_mappedClass != ''">
						<xsl:attribute name="class"><xsl:value-of select="$v_mappedClass"/></xsl:attribute>
					</xsl:if>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
