<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<!--
	*
	* This stylesheet upgrades the V5 report layout.
	*
	* WO1730 - Fix solve order of summaries in cross-tabs:
	* 
	* + Update the solveOrder attribute of crosstabNodeMembers based on the corresponding QRD valueSet solveOrder attribute.
	* + Remove name attributes from the crosstabNodeMember and defaultMeasure elements.  Those attributes were added
	*   for the sole purpose of mapping QRD valueSet elements back to their corresponding layout elements.
	*   They are NOT part of the V5 spec.
	* + Remove the queryResultDefinitions from the report element.  The QRD was added to the report element as an interim 
	*   upgrade step and must be removed.
	*
-->
<xsl:stylesheet version="1.0" xmlns:v5="http://developer.cognos.com/schemas/report/2.0/" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://developer.cognos.com/schemas/report/2.0/" exclude-result-prefixes="xsl xs xsi v5">
	<xsl:output method="xml" encoding="utf-8"/>
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<!-- Keep a map of valueSet elements keyed by the name attribute.                                                            -->
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<xsl:key name="valueSet" match="v5:valueSet" use="@name"/>
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<!-- Copy all attributes of the current node, except for annotation attributes that must be stripped out.                    -->
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<xsl:template name="copyAttributes">
		<xsl:for-each select="attribute::*">
			<!--Strip out the name attribute.  It is not part of V5.-->
			<xsl:if test="local-name(.) != 'name'">
				<xsl:copy/>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<!-- Copy all attributes of the current node, except for annotation attributes that must be stripped out.                    -->
	<!-- Change the value of the solveOrder attribute to that of p_solveOrder.                                                   -->
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<xsl:template name="changeSolveOrder">
		<xsl:param name="p_solveOrder"/>
		<xsl:for-each select="attribute::*">
			<xsl:choose>
				<xsl:when test="local-name(.) = 'solveOrder'">
					<!-- Change the value of the solveOrder attribute. -->
					<xsl:attribute name="solveOrder">
						<xsl:value-of select="$p_solveOrder"/>
					</xsl:attribute>
				</xsl:when>
				<xsl:when test="local-name(.) = 'name'">
					<!-- Strip out the name attribute.  It is not part of V5. -->
				</xsl:when>
				<xsl:otherwise>
					<!-- Copy all other attributes. -->
					<xsl:copy/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<!-- Using v_name as the key, get the value of the solveOrder attribute of a valueSet element.                               -->
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<xsl:template name="getValueSetSolveOrder">
		<xsl:variable name="v_name">
			<xsl:value-of select="@name"/>
		</xsl:variable>
		<xsl:value-of select="key('valueSet', $v_name)[1]/@solveOrder"/>	
	</xsl:template>
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<!-- Update the solveOrder attribute of the current element based on the corresponding QRD valueSet solveOrder attribute.    -->
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<xsl:template name="upgradeCrosstabAttributes">
		<xsl:variable name="valueSet_solveOrder">
			<xsl:call-template name="getValueSetSolveOrder"/>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$valueSet_solveOrder = ''">
				<!-- The valueSet does not have a solveOrder specified. -->
				<!-- Just copy the existing attributes over. -->
				<xsl:call-template name="copyAttributes"/>
			</xsl:when>
			<xsl:when test="@solveOrder">
				<!-- Both the valueSet and the current element have the solveOrder attribute specified. -->
				<!-- Copy the existing attributes over, but change the value of the solveOrder attribute. -->
				<xsl:call-template name="changeSolveOrder">
					<xsl:with-param name="p_solveOrder" select="$valueSet_solveOrder"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<!-- Only the valueSet has the solveOrder attribute specified. -->
				<!-- Add the solveOrder attribute to the current element. -->
				<xsl:call-template name="copyAttributes"/>
				<xsl:attribute name="solveOrder">
					<xsl:value-of select="$valueSet_solveOrder"/>
				</xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<!-- Upgrade the crosstab/defaultMeasure element.                                                                            -->
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<xsl:template match="v5:defaultMeasure">
		<xsl:copy>
			<xsl:call-template name="upgradeCrosstabAttributes"/>
			<xsl:apply-templates select="node()"/>
		</xsl:copy>
	</xsl:template>
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<!-- Upgrade the crosstabNodeMember element.                                                                                 -->
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<xsl:template match="v5:crosstabNodeMember">
		<xsl:copy>
			<xsl:call-template name="upgradeCrosstabAttributes"/>
			<xsl:apply-templates select="node()"/>
		</xsl:copy>
	</xsl:template>
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<!-- Strip out queryResultDefinitions.                                                                                       -->
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<xsl:template match="v5:queryResultDefinitions">
	</xsl:template>
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<!-- Copy all nodes and attributes by default.                                                                               -->
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<xsl:template match="@*|node()">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
