/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.configtool;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.configtool.VerifyConnection;
import com.cognos.configtool.VerifyMailServer;
import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.ICnfgTest;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.dom4j.Element;

public class VerifyConfig
implements ICnfgTest {
    private static final String SERVER_LOCALE = "serverLocale";
    private static final String RESOURCE = "cnfgtest";
    ICCLConfiguration _configuration = null;
    ResourceBundle _resource = null;
    boolean _isNCDataStore = false;
    static PrintStream _out;
    static boolean _verbose;

    public ICnfgTask[] getTasks(String path, ICnfgFeedback feedback) {
        ArrayList<Object> taskList = new ArrayList<Object>();
        VerifyConfig.debug("getTasks(): Path is " + path);
        if (path.indexOf("NC/database/") != -1) {
            taskList.add(new VerifyConnection(this._configuration, this._resource));
        } else {
            taskList.add(new VerifyMailServer(this._configuration, this._resource));
            if (this._isNCDataStore) {
                taskList.add(new VerifyConnection(this._configuration, this._resource));
            }
        }
        VerifyConfig.debug("getTasks(): Task count is " + taskList.size());
        return taskList.toArray(new ICnfgTask[taskList.size()]);
    }

    public boolean initialize(ICCLConfiguration config, ICnfgFeedback feedback) {
        this._configuration = config;
        VerifyConfig.setOutputSream(System.out);
        boolean success = false;
        this._resource = ResourceBundle.getBundle(RESOURCE, Locale.getDefault());
        try {
            this._isNCDataStore = this.isNCInstanceConfigured(config);
            if (_verbose && this._isNCDataStore) {
                VerifyConfig.debug("initialize(): JSM Datastore config detected");
            }
        }
        catch (CCLConfigurationException e1) {
            success = false;
        }
        success = true;
        return success;
    }

    public void terminate(ICnfgFeedback feedback) {
        this._configuration = null;
        this._resource = null;
        this._isNCDataStore = false;
        VerifyConfig.setOutputSream(null);
    }

    public final void setVerbose(boolean trueFalse) {
        _verbose = trueFalse;
    }

    public static final void setOutputSream(PrintStream stream) {
        _out = stream;
    }

    private boolean isNCInstanceConfigured(ICCLConfiguration config) throws CCLConfigurationException {
        boolean is_instance = false;
        Element root = config.getValueElement("NC", true);
        List elements = root.elements("instances");
        if (elements.size() > 0) {
            is_instance = true;
        }
        return is_instance;
    }

    static void debug(String s) {
        if (_verbose) {
            if (_out == null) {
                VerifyConfig.setOutputSream(System.out);
            }
            _out.println(s);
        }
    }

    static {
        _verbose = false;
    }
}

