/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.configtool;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.configtool.VerifyConfig;
import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.ICnfgTaskPrompt;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.jdbc.ConnectionException;
import com.cognos.jsmcommon.jdbc.ConnectionOpener;
import com.cognos.jsmcommon.jdbc.props.DatabaseType;
import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import com.cognos.jsmcommon.property.CMProperties;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ResourceBundle;

public class VerifyConnection
implements ICnfgTask {
    private ICCLConfiguration _config = null;
    private ResourceBundle _resource = null;
    private int _status = 0;
    private static final String SQL_CREATE_TABLE = "CREATE TABLE NC_CONFIG_TEST (TMP_ID INTEGER NOT NULL)";
    private static final String SQL_INSERT_TABLE = "INSERT INTO NC_CONFIG_TEST(TMP_ID) VALUES (1)";
    private static final String SQL_UPDATE_TABLE = "UPDATE NC_CONFIG_TEST SET TMP_ID = 2 WHERE TMP_ID = 1";
    private static final String SQL_SELECT_TABLE = "SELECT * FROM NC_CONFIG_TEST";
    private static final String SQL_DELETE_TABLE = "DROP TABLE NC_CONFIG_TEST";
    private static final String SQL_CREATE_VIEW = "CREATE VIEW V_NC_CONFIG_TEST AS SELECT TMP_ID FROM NC_CONFIG_TEST";
    private static final String SQL_DELETE_VIEW = "DROP VIEW V_NC_CONFIG_TEST";

    public VerifyConnection(ICCLConfiguration config, ResourceBundle resource) {
        this._config = config;
        this._resource = resource;
    }

    public void cancel(ICnfgFeedback feedback) throws Exception {
        feedback.showInformational(this._resource.getString("test.cancelled"));
    }

    public String getDescription() {
        VerifyConfig.debug("getDescription(): resource locale is " + this._resource.getLocale());
        return this._resource.getString("task1.desc");
    }

    public String getLabel() {
        VerifyConfig.debug("getLabel(): resource locale is " + this._resource.getLocale());
        return this._resource.getString("task1.label");
    }

    public ICnfgTaskPrompt[] getPrompts() {
        return null;
    }

    public int getStatus() {
        return this._status;
    }

    public boolean isMandatory() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
        boolean passed = true;
        VerifyConfig.debug("run(): resource locale is " + this._resource.getLocale());
        VerifyConfig.debug("run(): Initializing properties...");
        CMProperties cmp = this.getProperties();
        cmp.init(this._config);
        VerifyConfig.debug("run(): Initializing connection...");
        Connection connection = null;
        Statement statement = null;
        String currentTaskError = this._resource.getString("message.task1.error");
        JDBCConnectionProperties props = null;
        try {
            VerifyConfig.debug("run(): Resolving properties...");
            props = JDBCConnectionProperties.testInstance((CMProperties)cmp);
            VerifyConfig.debug("run(): " + props.getDBType().toString() + " data store detected.");
            connection = new ConnectionOpener(props.getDriverStr(), props.getUrlStr()).openConnection(props.getUrlStr(), props.getLogId(), props.getPassword());
            if (DatabaseType.SYBASE.equals((Object)props.getDBType())) {
                String connected_db_name = connection.getCatalog();
                String typed_db_name = cmp.getProperty("name");
                if (connected_db_name == null || !connected_db_name.equals(typed_db_name)) {
                    throw new ConnectionException(I18NCode.MSG_DATASTORE_URL_EXCP, new Object[]{typed_db_name});
                }
            }
            VerifyConfig.debug("run(): connection created to " + props.getUrlStr());
            connection.setAutoCommit(false);
            statement = connection.createStatement();
            VerifyConfig.debug("run(): Creating table...");
            boolean createTablePassed = this.executeUpdate(connection, statement, SQL_CREATE_TABLE, "message.task1.create", props, feedback, passed);
            if (createTablePassed) {
                passed = createTablePassed;
                VerifyConfig.debug("run(): Inserting data...");
                passed = this.executeUpdate(connection, statement, SQL_INSERT_TABLE, "message.task1.insert", props, feedback, createTablePassed);
                VerifyConfig.debug("run(): Reading data...");
                passed = this.executeQuery(connection, statement, SQL_SELECT_TABLE, "message.task1.read", props, feedback, passed);
                VerifyConfig.debug("run(): Updating data...");
                passed = this.executeUpdate(connection, statement, SQL_UPDATE_TABLE, "message.task1.update", props, feedback, passed);
                VerifyConfig.debug("run(): Creating view...");
                passed = this.executeUpdate(connection, statement, SQL_CREATE_VIEW, "message.task1.createView", props, feedback, passed);
                if (passed) {
                    VerifyConfig.debug("run(): Dropping view...");
                    passed = this.executeUpdate(connection, statement, SQL_DELETE_VIEW, "message.task1.deleteView", props, feedback, passed);
                }
                VerifyConfig.debug("run(): Dropping table...");
                boolean dropTablePassed = this.executeUpdate(connection, statement, SQL_DELETE_TABLE, "message.task1.delete", props, feedback, createTablePassed);
                passed = dropTablePassed && passed;
            } else {
                passed = false;
            }
        }
        catch (ConnectionException e) {
            passed = false;
            if (VerifyConfig._verbose) {
                e.printStackTrace(VerifyConfig._out);
            }
            feedback.invalidateParameter("dataAccess/NC/database");
            if (e.getI18NCode() == I18NCode.MSG_CLASSNOTF_EXCP || e.getI18NCode() == I18NCode.MSG_OBJECT_CREATE_EXCP) {
                feedback.showError(this._resource.getString("message.task1.noDriver"));
            } else {
                feedback.showError(this._resource.getString("message.task1.noDataStore"));
            }
            feedback.showInformational(e.getMessage());
        }
        catch (SQLException e) {
            passed = false;
            if (VerifyConfig._verbose) {
                e.printStackTrace(VerifyConfig._out);
            }
            feedback.invalidateParameter("dataAccess/NC/database");
            feedback.showError(currentTaskError);
            feedback.showInformational(e.getMessage());
            for (e = e.getNextException(); e != null; e = e.getNextException()) {
                feedback.showInformational(e.getMessage());
            }
        }
        catch (Throwable e) {
            passed = false;
            if (VerifyConfig._verbose) {
                e.printStackTrace(VerifyConfig._out);
            }
            feedback.showInformational(e.getMessage());
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    if (!this.isDBType(props, DatabaseType.SYBASE)) {
                        connection.rollback();
                    }
                    connection.close();
                }
            }
            catch (SQLException e) {}
        }
        if (passed) {
            VerifyConfig.debug("run(): Test passed.");
        } else {
            VerifyConfig.debug("run(): Test failed.");
        }
        return passed;
    }

    protected CMProperties getProperties() {
        return CMProperties.getInstance();
    }

    private boolean executeQuery(Connection connection, Statement statement, String sql, String resourceString, JDBCConnectionProperties props, ICnfgFeedback feedback, boolean success) {
        return this.execute(connection, statement, sql, resourceString, props, feedback, success, false);
    }

    private boolean executeUpdate(Connection connection, Statement statement, String sql, String resourceString, JDBCConnectionProperties props, ICnfgFeedback feedback, boolean success) {
        return this.execute(connection, statement, sql, resourceString, props, feedback, success, true);
    }

    private boolean execute(Connection connection, Statement statement, String sql, String resourceString, JDBCConnectionProperties props, ICnfgFeedback feedback, boolean success, boolean isExecute) {
        if (!success) {
            return success;
        }
        try {
            if (this.isDBType(props, DatabaseType.SYBASE)) {
                Statement sybaseStatement = connection.createStatement();
                if (isExecute) {
                    sybaseStatement.executeUpdate(sql);
                } else {
                    sybaseStatement.executeQuery(sql);
                }
                connection.commit();
                sybaseStatement.close();
            } else if (isExecute) {
                statement.executeUpdate(sql);
            } else {
                statement.executeQuery(sql);
            }
            success = true;
        }
        catch (SQLException e) {
            success = false;
            if (VerifyConfig._verbose) {
                e.printStackTrace(VerifyConfig._out);
            }
            feedback.invalidateParameter("dataAccess/NC/database");
            String currentTaskError = this._resource.getString(resourceString);
            feedback.showError(currentTaskError);
            feedback.showInformational(e.getMessage());
            for (e = e.getNextException(); e != null; e = e.getNextException()) {
                feedback.showInformational(e.getMessage());
            }
        }
        return success;
    }

    private boolean isDBType(JDBCConnectionProperties props, DatabaseType type) {
        if (props == null || type == null) {
            return false;
        }
        return type.equals((Object)props.getDBType());
    }

    public void setStatus(int status) {
        this._status = status;
    }
}

