/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.configtool;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.ICnfgTest;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.dom4j.Element;

public abstract class VerifyConnectionConfigBase
implements ICnfgTest {
    private static final String RESOURCE = "cnfgtest";
    private static PrintStream out;
    private static boolean verbose;
    private ICCLConfiguration configuration;
    private ResourceBundle resource;
    private boolean isDataStoreConfigured;

    protected abstract ICnfgTask createConfigTask(ICCLConfiguration var1, ResourceBundle var2);

    protected abstract String getConfigName();

    public ICnfgTask[] getTasks(String path, ICnfgFeedback feedback) {
        ArrayList<ICnfgTask> taskList = new ArrayList<ICnfgTask>();
        if (this.shouldAddConfigTask()) {
            taskList.add(this.createConfigTask(this.configuration, this.resource));
        }
        VerifyConnectionConfigBase.debug("getTasks(): Path is " + path);
        VerifyConnectionConfigBase.debug("getTasks(): Task count is " + taskList.size());
        return this.toArray(taskList);
    }

    protected boolean shouldAddConfigTask() {
        return this.isDataStoreConfigured;
    }

    private ICnfgTask[] toArray(List<ICnfgTask> taskList) {
        return taskList.toArray(new ICnfgTask[taskList.size()]);
    }

    public boolean initialize(ICCLConfiguration config, ICnfgFeedback feedback) {
        this.configuration = config;
        this.setOutputSream(System.out);
        this.resource = ResourceBundle.getBundle(RESOURCE, Locale.getDefault());
        try {
            this.isDataStoreConfigured = this.hasDatabaseNodeConfigured(config);
            if (this.isDataStoreConfigured) {
                VerifyConnectionConfigBase.debug("initialize(): Datastore config detected");
            }
            return true;
        }
        catch (CCLConfigurationException e1) {
            return false;
        }
    }

    public void terminate(ICnfgFeedback feedback) {
        this.configuration = null;
        this.resource = null;
        this.isDataStoreConfigured = false;
        this.setOutputSream(null);
    }

    private boolean hasDatabaseNodeConfigured(ICCLConfiguration config) throws CCLConfigurationException {
        Element root = config.getValueElement(this.getConfigName(), true);
        List elements = root.elements("instances");
        return !elements.isEmpty();
    }

    private static void debug(String s) {
        if (verbose) {
            out.println(s);
        }
    }

    public final void setVerbose(boolean trueFalse) {
        verbose = trueFalse;
    }

    public final void setOutputSream(PrintStream stream) {
        out = stream;
    }
}

