/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.configtool;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.configtool.VerifyConfig;
import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.ICnfgTaskPrompt;
import com.cognos.jsmcommon.mailUtils.MailUtil;
import com.cognos.jsmcommon.property.CRNProperties;
import java.util.Date;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;

public class VerifyMailServer
implements ICnfgTask {
    private static final String MAIL_RECIPIENT = "mail.recipient";
    private static final String MAIL_HOST = "mail.host";
    private static final String MAIL_PORT = "mail.port";
    private static final String AUTHENTICATE = "mail.smtp.auth";
    private static final String SMTP_TIMEOUT = "60000";
    private ICCLConfiguration _config = null;
    private ResourceBundle _resource = null;
    private int _status = 0;

    public VerifyMailServer(ICCLConfiguration config, ResourceBundle resource) {
        this._config = config;
        this._resource = resource;
    }

    public void cancel(ICnfgFeedback feedback) throws Exception {
        feedback.showInformational(this._resource.getString("test.cancelled"));
    }

    public String getDescription() {
        return this._resource.getString("task2.desc");
    }

    public String getLabel() {
        return this._resource.getString("task2.label");
    }

    public ICnfgTaskPrompt[] getPrompts() {
        return null;
    }

    public int getStatus() {
        return this._status;
    }

    public boolean isMandatory() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
        boolean success = false;
        Transport transport = null;
        Session session = null;
        CRNProperties crnp = new CRNProperties();
        try {
            crnp.init(this._config);
            final String username = crnp.getProperty("username");
            final String password = crnp.getProperty("password");
            boolean doAuthentication = username != null && !"".equals(username);
            crnp.setProperty(AUTHENTICATE, String.valueOf(doAuthentication));
            this.setMailHost(crnp);
            Properties props = crnp.getProperties();
            props.setProperty("mail.smtp.timeout", SMTP_TIMEOUT);
            props.setProperty("mail.smtp.connectiontimeout", SMTP_TIMEOUT);
            props.put("mail.ssl.encryption.enabled", "" + MailUtil.isSmtpsEncryptionEnabled((CRNProperties)crnp));
            if (MailUtil.isTlsEnabled()) {
                props.put("mail.smtp.starttls.enable", "true");
                props.put("mail.smtp.starttls.required", "true");
                if (MailUtil.getSMTP_SSL_Protocols() != null && MailUtil.getSMTP_SSL_Protocols().length() > 0) {
                    props.put("mail.smtp.ssl.protocols", MailUtil.getSMTP_SSL_Protocols());
                } else {
                    props.put("mail.smtp.ssl.protocols", "SSLv3 TLSv1 TLSv1.1 TLSv1.2");
                }
            }
            session = doAuthentication ? Session.getDefaultInstance((Properties)props, (Authenticator)new Authenticator(){

                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password);
                }
            }) : Session.getDefaultInstance((Properties)props);
            if (VerifyConfig._verbose) {
                session.setDebug(true);
                session.setDebugOut(VerifyConfig._out);
            }
            String host = crnp.getProperty(MAIL_HOST);
            int port = -1;
            try {
                port = Integer.parseInt(crnp.getProperty(MAIL_PORT));
            }
            catch (NumberFormatException e) {
                throw new Exception(e.getMessage());
            }
            VerifyConfig.debug("run(): SMTP Host " + host);
            VerifyConfig.debug("run(): SMTP Port " + port);
            VerifyConfig.debug("run(): SMTP Username " + username);
            String inputUserName = username;
            String inputPassword = password;
            if (inputUserName != null) {
                String string = inputUserName = inputUserName.length() == 0 ? null : inputUserName;
            }
            if (inputPassword != null) {
                inputPassword = inputPassword.length() == 0 ? null : inputPassword;
            }
            URLName urlName = new URLName(MailUtil.getMailProtocol((CRNProperties)crnp), host, port, null, inputUserName, inputPassword);
            transport = session.getTransport(urlName);
            transport.connect();
            success = true;
            try {
                String to = crnp.getProperty(MAIL_RECIPIENT);
                InternetAddress[] recipients = InternetAddress.parse((String)to, (boolean)false);
                MimeMessage message = new MimeMessage(session);
                message.setFrom((Address)new InternetAddress(to));
                message.setRecipients(Message.RecipientType.TO, (Address[])recipients);
                String subject = MimeUtility.encodeText((String)this._resource.getString("task2.subject"), (String)"UTF-8", (String)"B");
                message.setSubject(subject, "UTF-8");
                message.setSentDate(new Date());
                message.setText("");
                transport.sendMessage((Message)message, (Address[])recipients);
            }
            catch (Throwable e) {
                VerifyConfig.debug("run(): Send failed - " + e.getMessage());
                VerifyConfig.debug("******* Check your email server is running and email is configured correctly in c8 *******");
            }
        }
        catch (AuthenticationFailedException e) {
            feedback.invalidateParameter("dataAccess/NC/smtpAccount");
            feedback.showError(this._resource.getString("message.task2.authenticate.fail"));
        }
        catch (MessagingException e) {
            feedback.invalidateParameter("dataAccess/NC/smtpMailServer");
            feedback.showError(this._resource.getString("message.task2.error"));
        }
        finally {
            if (transport != null) {
                transport.close();
            }
        }
        if (success) {
            VerifyConfig.debug("run(): Test passed.");
        } else {
            VerifyConfig.debug("run(): Test failed.");
        }
        return success;
    }

    public void setStatus(int status) {
        this._status = status;
    }

    private void setMailHost(CRNProperties crnp) throws Exception {
        String server = crnp.getProperties().getProperty("smtpMailServer");
        String host = null;
        String domain = null;
        if (null == server) {
            throw new NullPointerException("server is null");
        }
        URLName urlName = new URLName(MailUtil.getMailProtocol((CRNProperties)crnp) + "://" + server);
        host = urlName.getHost();
        crnp.setProperty(MAIL_HOST, host);
        crnp.setProperty(MAIL_PORT, String.valueOf(urlName.getPort()));
        int i = host.indexOf(46);
        domain = host.substring(++i);
        String sender = crnp.getProperties().getProperty("defaultSender");
        if (null == sender || sender.length() < 1) {
            crnp.setProperty(MAIL_RECIPIENT, "user@" + domain);
        } else {
            crnp.setProperty(MAIL_RECIPIENT, sender);
        }
    }
}

