/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config;

import com.ibm.bi.config.external.FixedDelayPollingSchedulerOnYourExecutor;
import com.ibm.bi.config.external.PropertiesReader;
import com.ibm.bi.config.setup.ArchaiusSetup;
import com.ibm.bi.config.setup.ConfigurationSourceFactory;
import com.ibm.bi.config.util.ConfigurationUtils;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicContextualProperty;
import com.netflix.config.DynamicDoubleProperty;
import com.netflix.config.DynamicFloatProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicLongProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationPropertyFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationPropertyFactory.class);
    private static ConfigurationPropertyFactory instance;
    private DynamicPropertyFactory dynamicPropertyFactory;
    private ArchaiusSetup archaiusSetup;
    private boolean ready = false;
    private ScheduledExecutorService readyCheckScheduledExecSvc;
    private ScheduledFuture<?> scheduledReadyCheck;
    private ReadyChecker readyChecker;
    private List<Consumer<ConfigurationPropertyFactory>> waitingForConfig;

    protected static void setDisableDefaultConfig(String value) {
        System.setProperty("archaius.dynamicProperty.disableDefaultConfig", value);
    }

    private static void makeConfigurationPropertyFactory() {
        ConfigurationSourceFactory configSourceFactory = new ConfigurationSourceFactory();
        ScheduledExecutorService executorService = FixedDelayPollingSchedulerOnYourExecutor.makePollingExecutorService("com.ibm.bi.config.Poller");
        PropertiesReader propertiesReader = new PropertiesReader(ConfigurationUtils.getRepositoryRoot(), executorService);
        ArchaiusSetup archaiusSetup = new ArchaiusSetup(configSourceFactory, propertiesReader, executorService);
        instance = new ConfigurationPropertyFactory(archaiusSetup);
        archaiusSetup.initialize();
        instance.initialize();
    }

    ConfigurationPropertyFactory(ArchaiusSetup archaiusSetup) {
        this.archaiusSetup = archaiusSetup;
        this.dynamicPropertyFactory = DynamicPropertyFactory.getInstance();
    }

    public static synchronized ConfigurationPropertyFactory getInstance() {
        if (instance == null) {
            ConfigurationPropertyFactory.makeConfigurationPropertyFactory();
        }
        return instance;
    }

    public static void setInstance(ConfigurationPropertyFactory instance) {
        ConfigurationPropertyFactory.instance = instance;
    }

    public static void whenReady(Consumer<ConfigurationPropertyFactory> configConsumer) {
        ConfigurationPropertyFactory.getInstance().produceWhenReady(configConsumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void produceWhenReady(Consumer<ConfigurationPropertyFactory> configConsumer) {
        ConfigurationPropertyFactory configurationPropertyFactory = this;
        synchronized (configurationPropertyFactory) {
            if (this.ready) {
                LOG.debug("produceWhenReady: config is ready so give it to consumer {} on calling thread.", (Object)configConsumer);
                configConsumer.accept(instance);
            } else {
                LOG.debug("produceWhenReady: config is NOT ready.  Will call consumer {} when it is ready.", (Object)configConsumer);
                if (this.waitingForConfig == null) {
                    this.waitingForConfig = new ArrayList<Consumer<ConfigurationPropertyFactory>>();
                }
                this.waitingForConfig.add(configConsumer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize() {
        ConfigurationPropertyFactory configurationPropertyFactory = this;
        synchronized (configurationPropertyFactory) {
            if (this.archaiusSetup.configSourcesReady()) {
                this.ready = true;
            } else {
                LOG.debug("initialize: config sources are NOT ready. Scheduling periodic checks");
                this.readyCheckScheduledExecSvc = FixedDelayPollingSchedulerOnYourExecutor.makePollingExecutorService("com.ibm.bi.config.readyChecker");
                this.readyChecker = new ReadyChecker();
                this.scheduledReadyCheck = this.readyCheckScheduledExecSvc.scheduleAtFixedRate(this.readyChecker, 100L, 100L, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeReady() {
        ArrayList<Consumer<ConfigurationPropertyFactory>> pending = new ArrayList<Consumer<ConfigurationPropertyFactory>>();
        ConfigurationPropertyFactory configurationPropertyFactory = this;
        synchronized (configurationPropertyFactory) {
            this.ready = true;
            this.scheduledReadyCheck.cancel(false);
            this.scheduledReadyCheck = null;
            this.readyCheckScheduledExecSvc.shutdown();
            this.readyCheckScheduledExecSvc = null;
            this.readyChecker = null;
            if (this.waitingForConfig != null) {
                pending.addAll(this.waitingForConfig);
                this.waitingForConfig.clear();
                this.waitingForConfig = null;
            }
        }
        LOG.debug("configuration is ready, so pass it to any waiting consumers");
        pending.stream().forEach(c -> {
            LOG.debug("provide config to consumer {}", c);
            c.accept(instance);
            LOG.debug("returned from consumer {}", c);
        });
    }

    public ArchaiusSetup getArchaiusSetup() {
        return this.archaiusSetup;
    }

    public ArrayList<String> getKeyNames(String keypath) {
        return this.archaiusSetup.getKeyNames(keypath);
    }

    public String getNoneSensitiveKeyname(String keyname) {
        return this.archaiusSetup.getNonSensitiveFullKeyname(keyname);
    }

    public DynamicStringProperty getStringProperty(String propName) {
        String defaultValue = "default";
        propName = ConfigurationUtils.replacePathDelimiter(propName);
        DynamicStringProperty propValue = this.dynamicPropertyFactory.getStringProperty(propName, defaultValue);
        LOG.debug("getStringProperty({}) returns \"{}\".", (Object)propName, (Object)propValue.get());
        return propValue;
    }

    public DynamicStringProperty getStringProperty(String propName, String defaultValue) {
        propName = ConfigurationUtils.replacePathDelimiter(propName);
        DynamicStringProperty propValue = this.dynamicPropertyFactory.getStringProperty(propName, defaultValue);
        LOG.debug("getStringProperty({},{}) returns \"{}\".", propName, defaultValue, propValue.get());
        return propValue;
    }

    public DynamicStringProperty getStringProperty(String propName, String defaultValue, Runnable propertyChangeCallback) {
        propName = ConfigurationUtils.replacePathDelimiter(propName);
        DynamicStringProperty propValue = this.dynamicPropertyFactory.getStringProperty(propName, defaultValue, propertyChangeCallback);
        LOG.debug("getStringProperty({},{},propertyChangeCallback) returns \"{}\".", propName, defaultValue, propValue.get());
        return propValue;
    }

    public DynamicIntProperty getIntProperty(String propName, int defaultValue) {
        propName = ConfigurationUtils.replacePathDelimiter(propName);
        DynamicIntProperty propValue = this.dynamicPropertyFactory.getIntProperty(propName, defaultValue);
        LOG.debug("getIntProperty({},{}) returns \"{}\".", propName, defaultValue, propValue.get());
        return propValue;
    }

    public DynamicIntProperty getIntProperty(String propName, int defaultValue, Runnable propertyChangeCallback) {
        propName = ConfigurationUtils.replacePathDelimiter(propName);
        DynamicIntProperty propValue = this.dynamicPropertyFactory.getIntProperty(propName, defaultValue, propertyChangeCallback);
        LOG.debug("getIntProperty({},{},propertyChangeCallback) returns \"{}\".", propName, defaultValue, propValue.get());
        return propValue;
    }

    public DynamicLongProperty getLongProperty(String propName, long defaultValue) {
        propName = ConfigurationUtils.replacePathDelimiter(propName);
        DynamicLongProperty propValue = this.dynamicPropertyFactory.getLongProperty(propName, defaultValue);
        LOG.debug("getLongProperty({},{}) returns \"{}\".", propName, defaultValue, propValue.get());
        return propValue;
    }

    public DynamicLongProperty getLongProperty(String propName, long defaultValue, Runnable propertyChangeCallback) {
        propName = ConfigurationUtils.replacePathDelimiter(propName);
        DynamicLongProperty propValue = this.dynamicPropertyFactory.getLongProperty(propName, defaultValue, propertyChangeCallback);
        LOG.debug("getLongProperty({},{},propertyChangeCallback) returns \"{}\".", propName, defaultValue, propValue.get());
        return propValue;
    }

    public DynamicBooleanProperty getBooleanProperty(String propName, boolean defaultValue) {
        propName = ConfigurationUtils.replacePathDelimiter(propName);
        DynamicBooleanProperty propValue = this.dynamicPropertyFactory.getBooleanProperty(propName, defaultValue);
        LOG.debug("getBooleanProperty({},{}) returns \"{}\".", propName, defaultValue, propValue.get());
        return propValue;
    }

    public DynamicBooleanProperty getBooleanProperty(String propName, boolean defaultValue, Runnable propertyChangeCallback) {
        propName = ConfigurationUtils.replacePathDelimiter(propName);
        DynamicBooleanProperty propValue = this.dynamicPropertyFactory.getBooleanProperty(propName, defaultValue, propertyChangeCallback);
        LOG.debug("getBooleanProperty({},{},propertyChangeCallback returns \"{}\".", propName, defaultValue, propValue.get());
        return propValue;
    }

    public DynamicFloatProperty getFloatProperty(String propName, float defaultValue) {
        propName = ConfigurationUtils.replacePathDelimiter(propName);
        DynamicFloatProperty propValue = this.dynamicPropertyFactory.getFloatProperty(propName, defaultValue);
        LOG.debug("getFloatProperty({},{}) returns \"{}\".", propName, Float.valueOf(defaultValue), Float.valueOf(propValue.get()));
        return propValue;
    }

    public DynamicFloatProperty getFloatProperty(String propName, float defaultValue, Runnable propertyChangeCallback) {
        propName = ConfigurationUtils.replacePathDelimiter(propName);
        DynamicFloatProperty propValue = this.dynamicPropertyFactory.getFloatProperty(propName, defaultValue, propertyChangeCallback);
        LOG.debug("getFloatProperty({},{},propertyChangeCallback) returns \"{}\".", propName, Float.valueOf(defaultValue), Float.valueOf(propValue.get()));
        return propValue;
    }

    public DynamicDoubleProperty getDoubleProperty(String propName, double defaultValue) {
        propName = ConfigurationUtils.replacePathDelimiter(propName);
        DynamicDoubleProperty propValue = this.dynamicPropertyFactory.getDoubleProperty(propName, defaultValue);
        LOG.debug("getDoubleProperty({},{}) returns \"{}\".", propName, defaultValue, propValue.get());
        return this.dynamicPropertyFactory.getDoubleProperty(propName, defaultValue);
    }

    public DynamicDoubleProperty getDoubleProperty(String propName, double defaultValue, Runnable propertyChangeCallback) {
        propName = ConfigurationUtils.replacePathDelimiter(propName);
        DynamicDoubleProperty propValue = this.dynamicPropertyFactory.getDoubleProperty(propName, defaultValue, propertyChangeCallback);
        LOG.debug("getDoubleProperty({},{},propertyChangeCallback) returns \"{}\".", propName, defaultValue, propValue.get());
        return propValue;
    }

    public <T> DynamicContextualProperty<T> getContextualProperty(String propName, T defaultValue) {
        propName = ConfigurationUtils.replacePathDelimiter(propName);
        return this.dynamicPropertyFactory.getContextualProperty(propName, defaultValue);
    }

    public <T> DynamicContextualProperty<T> getContextualProperty(String propName, T defaultValue, Runnable propertyChangeCallback) {
        propName = ConfigurationUtils.replacePathDelimiter(propName);
        return this.dynamicPropertyFactory.getContextualProperty(propName, defaultValue, propertyChangeCallback);
    }

    @Deprecated
    public void setProperty(String key, String value) throws Exception {
    }

    @Deprecated
    public void deleteProperty(String key) throws Exception {
        throw new Exception("deleteProperty not implemented in java API");
    }

    static {
        ConfigurationPropertyFactory.setDisableDefaultConfig("true");
        System.setProperty("archaius.configuration.disableDelimiterParsing", "true");
    }

    private class ReadyChecker
    implements Runnable {
        private ReadyChecker() {
        }

        @Override
        public void run() {
            try {
                if (ConfigurationPropertyFactory.this.archaiusSetup.configSourcesReady()) {
                    LOG.info("ReadyChecker: config sources are ready.");
                    ConfigurationPropertyFactory.this.makeReady();
                }
            }
            catch (Exception x) {
                LOG.error("error checking if configuration is ready", x);
            }
        }
    }
}

