/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config.external;

import com.ibm.bi.config.external.CheckedFileContentException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckedFileInputStream
extends InputStream {
    private static final Logger LOG = LoggerFactory.getLogger(CheckedFileInputStream.class);
    private static final int HDRSIZE = 128;
    private RandomAccessFile raf;

    public CheckedFileInputStream(File file) throws IOException {
        this.raf = new RandomAccessFile(file, "rw");
        if (this.getChecksumFromHeader(this.raf) != this.getContentChecksum(this.raf)) {
            throw new CheckedFileContentException("checksum of content does not match header");
        }
        this.raf.seek(128L);
    }

    long getChecksumFromHeader(RandomAccessFile raf) throws CheckedFileContentException {
        try {
            byte[] buffer = new byte[128];
            if (128 != raf.read(buffer)) {
                throw new CheckedFileContentException("failed to read entire checksum header");
            }
            if (!CheckedFileInputStream.startsWithCRC32Prefix(buffer)) {
                throw new CheckedFileContentException("malformed checksum header: missing prefix");
            }
            return CheckedFileInputStream.parseChecksum(buffer);
        }
        catch (NumberFormatException nfx) {
            throw new CheckedFileContentException("checksum header is invalid, does not parse as long");
        }
        catch (CheckedFileContentException cfcx) {
            throw cfcx;
        }
        catch (IOException iox) {
            LOG.debug("failed to read checksum header", iox);
            throw new CheckedFileContentException("failed to read checksum header");
        }
    }

    static boolean startsWithCRC32Prefix(byte[] buffer) {
        byte[] CRCHDR = "{crc32}".getBytes();
        return Arrays.equals(CRCHDR, ArrayUtils.subarray(buffer, 0, CRCHDR.length));
    }

    static long parseChecksum(byte[] buffer) {
        byte[] CRCHDR = "{crc32}".getBytes();
        return Long.parseLong(new String(ArrayUtils.subarray(buffer, CRCHDR.length, 128)).trim());
    }

    long getContentChecksum(final RandomAccessFile raf) throws IOException {
        raf.seek(128L);
        CheckedInputStream chkIn = new CheckedInputStream(new InputStream(){

            @Override
            public int read() throws IOException {
                return raf.read();
            }

            @Override
            public int read(byte[] b) throws IOException {
                return raf.read(b);
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                return raf.read(b, off, len);
            }
        }, new CRC32());
        IOUtils.copy((InputStream)chkIn, (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
        return chkIn.getChecksum().getValue();
    }

    @Override
    public int read() throws IOException {
        return this.raf.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.raf.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.raf.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }
}

