/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config.external;

import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.config.external.flipper.FlipperRestInterface;
import com.netflix.config.PollResult;
import com.netflix.config.PolledConfigurationSource;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Consumer;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlipperConfigurationSource
implements PolledConfigurationSource,
Consumer<ConfigurationPropertyFactory> {
    private static final Logger LOG = LoggerFactory.getLogger(FlipperConfigurationSource.class);
    private String path;
    private FlipperRestInterface flipperRest;

    public FlipperConfigurationSource(String path, FlipperRestInterface flipperRest) {
        this.path = path;
        this.flipperRest = flipperRest;
        ConfigurationPropertyFactory.whenReady(this);
    }

    @Override
    public PollResult poll(boolean initial, Object checkPoint) throws Exception {
        PropertiesConfiguration configuration = this.flipperRest.getConfiguration(this.path);
        if (configuration != null && (initial || this.flipperRest.configurationChanged(this.path))) {
            return this.load(configuration);
        }
        return PollResult.createFull(null);
    }

    private PollResult load(PropertiesConfiguration configuration) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator<String> keys = configuration.getKeys();
        while (keys.hasNext()) {
            String key = keys.next();
            map.put(key, configuration.getProperty(key));
        }
        LOG.debug("Updated configuration file {} loaded from flipper", (Object)this.path);
        return PollResult.createFull(map);
    }

    @Override
    public void accept(ConfigurationPropertyFactory t) {
    }
}

