/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config.external;

import com.ibm.bi.config.external.DecodedKeyFactory;
import com.ibm.bi.config.external.DynamicFileConfiguration;
import com.ibm.bi.config.external.DynamicFlipperConfiguration;
import com.ibm.bi.config.util.ConfigurationUtils;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesReader {
    private static final int DELAY = 10000;
    private static final int INITIAL_DELAY = 0;
    private static final int INITIAL_FLIPPER_DELAY = 0;
    public static final String CONFIGURATION_NAME = "com.ibm.bi.config.external.PropertiesReader.configurationName";
    public static final String EMPTY_CONFIGURATION = "com.ibm.bi.config.external.PropertiesReader.configurationEmpty";
    private static final Logger log = LoggerFactory.getLogger(PropertiesReader.class);
    private String localPath;
    private HashMap<String, AbstractConfiguration> fileConfigurationMap;
    protected DecodedKeyFactory decodedKeyFactory = new DecodedKeyFactory();
    private File repositoryRoot;
    private final ScheduledExecutorService executorService;

    public PropertiesReader(File repositoryRoot, ScheduledExecutorService executorService) {
        this.repositoryRoot = repositoryRoot;
        this.executorService = executorService;
        this.fileConfigurationMap = new HashMap();
    }

    String getLocalPath() {
        return this.localPath;
    }

    public File getFileForPath(String path, int layer) {
        File file = new File(this.repositoryRoot, path);
        return new File(file, this.getPropertyFilename(layer));
    }

    protected String addPropfileToPath(String path, int layer) {
        return path + "/" + this.getPropertyFilename(layer);
    }

    private String getPropertyFilename(int layer) {
        return "configuration" + layer + ".properties";
    }

    public AbstractConfiguration getNamedConfigurationForPath(String path, int layer) {
        AbstractConfiguration configurationForPath = this.getFileConfigurationForPath(path, layer);
        configurationForPath.setProperty(EMPTY_CONFIGURATION, configurationForPath.isEmpty());
        configurationForPath.setProperty(CONFIGURATION_NAME, this.getNameForPath(path, layer));
        return configurationForPath;
    }

    public static boolean namedConfigurationIsEmpty(Configuration config) {
        return config.isEmpty() || config.getBoolean(EMPTY_CONFIGURATION, false);
    }

    private String getNameForPath(String path, int layer) {
        return FilenameUtils.separatorsToUnix(FilenameUtils.concat(path, this.getPropertyFilename(layer)));
    }

    public String setLocalURI(String localUri) {
        try {
            URI uri = new URI(localUri);
            String host = uri.getHost();
            int port = uri.getPort();
            this.localPath = host + "_" + port;
            this.decodedKeyFactory.setLocalPath(this.localPath);
        }
        catch (Exception e) {
            log.error("invalid local Uri", e);
        }
        return this.localPath;
    }

    protected AbstractConfiguration getFileConfigurationForPath(String path, int layer) {
        String propPath = this.addPropfileToPath(path, layer);
        AbstractConfiguration propertiesConfiguration = this.fileConfigurationMap.get(propPath);
        if (propertiesConfiguration == null) {
            propertiesConfiguration = this.createConfiguration(propPath, path.equals("global"));
            this.fileConfigurationMap.put(propPath, propertiesConfiguration);
        }
        return propertiesConfiguration;
    }

    private AbstractConfiguration createConfiguration(String propPath, boolean isGlobal) {
        if (ConfigurationUtils.runningOnCloud() && isGlobal) {
            return new DynamicFlipperConfiguration(this.executorService, 0, 10000, false, propPath, ConfigurationUtils.getFlipperhost(), ConfigurationUtils.getFlipperPort());
        }
        File propertyFile = new File(this.repositoryRoot, propPath);
        return new DynamicFileConfiguration(this.executorService, true, 0, 10000, false, propertyFile);
    }
}

