/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config.external.flipper;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.ibm.bi.config.RequestContext;
import com.ibm.bi.config.external.flipper.ResourceConverter;
import com.ibm.bi.config.external.flipper.TaggedResource;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientConfig;
import com.ibm.bi.rest.RESTClientFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public abstract class CachingRESTClient<T> {
    static final String USER_NAME_HDR = "x-bi-flipper-username";
    private RESTClientFactory restClientFactory;
    private ResourceConverter<T> converter;
    private String baseURL;
    protected Cache<String, TaggedResource<T>> cache;

    abstract Logger getLogger();

    protected CachingRESTClient() {
    }

    protected CachingRESTClient(RESTClientFactory restClientFactory, ResourceConverter<T> converter, String baseURL) {
        this.restClientFactory = restClientFactory;
        this.converter = converter;
        this.baseURL = baseURL;
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).maximumSize(8L).build();
    }

    protected RESTClient getRESTClient() {
        RESTClient client = this.restClientFactory.getClient(new RESTClientConfig());
        client.setRequestHeader("Cache-Control", "no-cache");
        boolean res = client.makeTrusted("config-service");
        this.getLogger().debug("CachingRESTClient::getRESTClient - makeTrusted('config-service') returned {}", (Object)res);
        this.addUserInfo(client);
        return client;
    }

    void addUserInfo(RESTClient restClient) {
        String userName;
        RequestContext.Info info = RequestContext.getInfo();
        if (info != null && !StringUtils.isEmpty(userName = info.getUserName())) {
            this.getLogger().debug("pass user name {} to flipper", (Object)userName);
            restClient.setRequestHeader(USER_NAME_HDR, userName);
        }
    }

    private String buildURL(String path) {
        return this.baseURL + path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T get(String path) throws Exception {
        String ifNoneMatch = null;
        TaggedResource<T> cachedResource = this.cache.getIfPresent(path);
        if (cachedResource != null) {
            ifNoneMatch = cachedResource.getTagAsEtag();
        } else {
            this.getLogger().debug("resource {} not found in cache", (Object)path);
        }
        try (RESTClient client = this.getRESTClient();){
            client.accept("application/octet-stream");
            if (StringUtils.isNotEmpty(ifNoneMatch)) {
                client.setRequestHeader("If-None-Match", ifNoneMatch);
            }
            int statusCode = client.getResource(this.buildURL(path));
            if (cachedResource != null && statusCode == Response.Status.NOT_MODIFIED.getStatusCode()) {
                cachedResource.setChanged(false);
                this.getLogger().debug("returning cached value for {}", (Object)path);
                T t = cachedResource.getResource();
                return t;
            }
            if (statusCode == Response.Status.NOT_FOUND.getStatusCode()) {
                throw new FileNotFoundException("resource not found: " + path);
            }
            if (statusCode >= Response.Status.BAD_REQUEST.getStatusCode()) {
                throw new Exception(Response.Status.fromStatusCode((int)statusCode).toString());
            }
            this.getLogger().debug("loading resource from response {}", (Object)path);
            T resource = this.converter.load(client.getResponseStream());
            cachedResource = new TaggedResource<T>(resource, client.getResponseHeader("Etag"));
            cachedResource.setChanged(true);
            this.cache.put(path, cachedResource);
            T t = resource;
            return t;
        }
        catch (FileNotFoundException e) {
            this.getLogger().debug("resource not found {}", (Object)e.getMessage());
            throw e;
        }
        catch (IOException e) {
            this.getLogger().warn("GET() Exception - {}", (Object)e.getMessage());
            throw e;
        }
    }

    public int put(String path, T t) throws Exception {
        int statusCode = 500;
        try (RESTClient client = this.getRESTClient();){
            statusCode = client.updateResource(this.buildURL(path), "application/octet-stream", -1L, this.converter.asStream(t));
            this.cache.invalidate(path);
        }
        catch (IOException e) {
            this.getLogger().warn("PUT() Exception - " + e.getMessage());
            throw e;
        }
        return statusCode;
    }

    public int post(String path, T t) throws Exception {
        int statusCode = 500;
        try (RESTClient client = this.getRESTClient();){
            statusCode = client.createResource(this.buildURL(path), "application/octet-stream", -1L, this.converter.asStream(t));
            this.cache.invalidate(path);
        }
        catch (IOException e) {
            this.getLogger().warn("PUT() Exception - " + e.getMessage());
            throw e;
        }
        return statusCode;
    }

    public int delete(String path) throws Exception {
        int statusCode = 500;
        try (RESTClient client = this.getRESTClient();){
            statusCode = client.deleteResource(this.buildURL(path), "application/octet-stream");
            this.cache.invalidate(path);
        }
        catch (IOException e) {
            this.getLogger().warn("PUT() Exception - " + e.getMessage());
            throw e;
        }
        return statusCode;
    }
}

