/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config.external.flipper;

import com.ibm.bi.config.external.flipper.CachingRESTClient;
import com.ibm.bi.config.external.flipper.FlipperRestInterface;
import com.ibm.bi.config.external.flipper.PropertiesConfigurationConverter;
import com.ibm.bi.config.external.flipper.TaggedResource;
import com.ibm.bi.config.util.ConfigurationUtils;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlipperREST
extends CachingRESTClient<PropertiesConfiguration>
implements FlipperRestInterface {
    private static final Logger log = LoggerFactory.getLogger(FlipperREST.class);
    private static final String FLIPPER_CONTEXTPATH = "/flipper-service/v1/flipper/";
    private static final String FLIPPER_CONTEXTPATH_FILES = "files/config/";
    private static final String FLIPPER_CONTEXTPATH_FOLDERS = "folders/config/";
    private static final String FLIPPER_CONTEXTPATH_REPOS = "repos";
    private static final String SCHEME_HTTPS = "https";
    private int port;
    private String hostname;
    private String urlscheme;
    private static boolean isForTest = false;

    @Override
    Logger getLogger() {
        return log;
    }

    public FlipperREST() {
    }

    public static void setIsForTest(boolean bTest) {
        isForTest = bTest;
    }

    public FlipperREST(String hostname, int port) {
        super(RESTClientFactory.getInstance(), new PropertiesConfigurationConverter(), FlipperREST.makeURL(port, hostname));
        this.port = port;
        this.hostname = hostname;
        this.urlscheme = FlipperREST.getURLScheme();
        log.info("config-service talks to flipper-service using host:port, {}://{}:{}", this.urlscheme, hostname, port);
    }

    static String makeURL(int port, String hostname) {
        return FlipperREST.getURLScheme() + "://" + hostname + ":" + port + FLIPPER_CONTEXTPATH + FLIPPER_CONTEXTPATH_FILES;
    }

    static String getURLScheme() {
        if (ConfigurationUtils.runningOnCloud() || isForTest) {
            return ConfigurationUtils.getFlipperScheme();
        }
        return SCHEME_HTTPS;
    }

    String makeFlipperURL(String path) {
        return this.urlscheme + "://" + this.hostname + ":" + this.port + FLIPPER_CONTEXTPATH + path;
    }

    @Override
    public PropertiesConfiguration getConfiguration(String pathName) {
        try {
            return (PropertiesConfiguration)this.get(pathName);
        }
        catch (FileNotFoundException e) {
            log.debug("resource not found: " + pathName);
        }
        catch (Exception e) {
            log.error("get of {} from flipper failed", (Object)pathName);
            log.error("with exception", e);
        }
        return null;
    }

    @Override
    public void store(String pathName, PropertiesConfiguration config) throws Exception {
        int statusCode = this.put(pathName, config);
        if (statusCode == 404) {
            this.getLogger().debug("PUT to {} failed with 404, retry as POST", (Object)pathName);
            statusCode = this.post(pathName, config);
            this.getLogger().debug("POST to {} result {}", (Object)pathName, (Object)statusCode);
        } else if (statusCode >= 300) {
            this.getLogger().warn("POST to {}, unexpected status code {}", (Object)pathName, (Object)statusCode);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<String> listPaths() throws Exception {
        try (RESTClient client = this.getRESTClient();){
            JsonObject result = client.getResource(this.makeFlipperURL(FLIPPER_CONTEXTPATH_FOLDERS), "application/json");
            if (client.getResponseCode() >= Response.Status.BAD_REQUEST.getStatusCode()) {
                throw new Exception(Response.Status.fromStatusCode((int)client.getResponseCode()).toString());
            }
            ArrayList<String> folderNames = new ArrayList<String>();
            for (Object folderObj : result.getArray("folders")) {
                JsonObject folder = (JsonObject)folderObj;
                folderNames.add(folder.getString("name"));
            }
            ArrayList<String> arrayList = folderNames;
            return arrayList;
        }
        catch (IOException e) {
            log.warn("listPaths() Exception - " + e.getMessage());
            throw e;
        }
    }

    @Override
    public boolean configurationChanged(String pathName) {
        TaggedResource cachedResource = (TaggedResource)this.cache.getIfPresent(pathName);
        return cachedResource == null ? false : cachedResource.isChanged();
    }

    @Override
    protected RESTClient getRESTClient() {
        RESTClient client = super.getRESTClient();
        client.makeTrusted("config-service");
        return client;
    }

    @Override
    public boolean testReady() {
        boolean isReady = false;
        try (RESTClient client = this.getRESTClient();){
            client.accept("application/json");
            String pingurl = this.makeFlipperURL(FLIPPER_CONTEXTPATH_REPOS);
            int statusCode = client.getResource(pingurl);
            this.getLogger().debug("testReady() - ping flipper service  return {}", (Object)statusCode);
            if (statusCode == 200) {
                isReady = true;
                this.getLogger().info("testReady - flipper service is ready.");
            }
        }
        catch (Exception e) {
            this.getLogger().debug("testReady() - ping flipper service return Exception - " + e.getMessage());
        }
        return isReady;
    }
}

