/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config.setup;

import com.ibm.bi.config.external.DynamicFileConfiguration;
import com.ibm.bi.config.external.PropertiesReader;
import com.ibm.bi.config.setup.CogLocaleConfiguration;
import com.ibm.bi.config.setup.CogXMLConfiguration;
import com.ibm.bi.config.setup.CogstartupConfiguration;
import com.ibm.bi.config.setup.ConfigurationSourceFactoryInt;
import com.ibm.bi.config.setup.PredefinedConfiguration;
import com.ibm.bi.config.setup.WhitelistEnvironmentConfiguration;
import com.ibm.bi.config.util.ConfigurationUtils;
import com.ibm.bi.config.util.PropertiesConfigurationFactory;
import com.ibm.bi.rest.RESTClientFactory;
import com.netflix.config.ConcurrentCompositeConfiguration;
import com.netflix.config.ConcurrentMapConfiguration;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicURLConfiguration;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchaiusSetup {
    private static final Logger log = LoggerFactory.getLogger(ArchaiusSetup.class);
    public static final int NUM_GLOBAL_LAYERS = 4;
    private HashMap<String, String> sensitiveConfigEntries = new HashMap();
    static final String COGSTARTUP_FILE_NAME = "configuration/cogstartup.xml";
    static final String COGLOCALE_FILE_NAME = "configuration/coglocale.xml";
    private static final String WHITELIST_FILENAME = "configuration/bi-environment-whitelist";
    private static final int initialDelayMillis = 0;
    private static final int delayMillis = 10000;
    private static final String STATIC_CONFIGURATION = "configuration/startup-configuration.properties";
    private static final String DISPATCHER_GLOBAL_CONFIGURATION = "configuration/dispatcher_global.properties";
    public static final String META_FILENAME = "configuration/metadata/xml/category_definition.xml";
    private final ConcurrentCompositeConfiguration compositeConfiguration = new ConcurrentCompositeConfiguration();
    private ConfigurationSourceFactoryInt configurationSourceFactory;
    private CogstartupConfiguration cogstartupConfigurationInst;
    private CogLocaleConfiguration coglocaleConfigurationInst;
    private PropertiesReader propertiesReaderInst;
    private ArrayList<PredefinedConfiguration> predefinedConfigurationInst;
    private String localNodeName;
    private int indexBottomGlobal;
    private final ScheduledExecutorService executorService;

    public ArchaiusSetup(ConfigurationSourceFactoryInt configurationSourceFactory, PropertiesReader propertiesReader, ScheduledExecutorService executorService) {
        this.configurationSourceFactory = configurationSourceFactory;
        this.executorService = executorService;
        this.propertiesReaderInst = propertiesReader;
    }

    protected void setCogstartupConfigurationInst(CogstartupConfiguration configInst) {
        this.cogstartupConfigurationInst = configInst;
    }

    public void setConfigurationSourceFactory(ConfigurationSourceFactoryInt configurationSourceFactory) {
        this.configurationSourceFactory = configurationSourceFactory;
    }

    public CogstartupConfiguration getCogStartupConfig() throws ConfigurationException {
        if (this.cogstartupConfigurationInst != null) {
            return this.cogstartupConfigurationInst;
        }
        throw new ConfigurationException("CogStartupConfiguration is null.");
    }

    public CogLocaleConfiguration getCogLocaleConfig() throws ConfigurationException {
        if (this.coglocaleConfigurationInst != null) {
            return this.coglocaleConfigurationInst;
        }
        throw new ConfigurationException("CogLocaleConfiguration is null.");
    }

    public PropertiesReader getPropertiesReader() {
        return this.propertiesReaderInst;
    }

    public ArrayList<PredefinedConfiguration> getPredefinedConfiguration() {
        return this.predefinedConfigurationInst;
    }

    public ArrayList<String> getPredefinedSecureKeys() {
        ArrayList<String> predefinedSecureKeys = new ArrayList<String>();
        if (this.predefinedConfigurationInst != null) {
            for (PredefinedConfiguration predConfig : this.predefinedConfigurationInst) {
                if (predConfig == null || predConfig.getSecureKeys().size() <= 0) continue;
                predefinedSecureKeys.addAll(predConfig.getSecureKeys());
            }
        }
        return predefinedSecureKeys;
    }

    public void initialize() {
        if (ConfigurationManager.isConfigurationInstalled()) {
            this.compositeConfiguration.clear();
        }
        this.addEnvironmentConfiguration();
        this.predefinedConfigurationInst = this.loadPredefinedConfiguration();
        if (!ConfigurationManager.isConfigurationInstalled()) {
            DynamicPropertyFactory.initWithConfigurationSource(this.compositeConfiguration);
        }
        this.addConfiguration(this.propertiesReaderInst);
        this.addDispatcherProperties();
        this.addPredefinedConfiguration(this.predefinedConfigurationInst);
        this.addFileProperties(STATIC_CONFIGURATION, false);
    }

    public void addConfiguration(PropertiesReader propertiesReader) {
        this.cogstartupConfigurationInst = this.addCogstartupConfiguration();
        this.addSensitiveConfigEntries(this.cogstartupConfigurationInst);
        this.setupNodeName(this.cogstartupConfigurationInst, propertiesReader);
        this.coglocaleConfigurationInst = this.addCogLocaleConfiguration();
        if (ConfigurationUtils.runningOnCloud()) {
            this.startRestClientFactory();
        }
        this.addFileProperties(DISPATCHER_GLOBAL_CONFIGURATION, false);
        this.addPropertiesConfiguration(propertiesReader);
        this.addCloudConfigEntries();
    }

    protected void addCloudConfigEntries() {
        if (this.getCogstartupConfigInst() == null) {
            log.error("cogstartup config Inst not initialized yet.");
            return;
        }
        try {
            this.addCloudConfigEntry("externalDispatcherScheme");
            this.addCloudConfigEntry("externalDispatcherHost");
            this.addCloudConfigEntryInt("externalDispatcherPort");
        }
        catch (Exception e) {
            log.error("addCloudConfigEntries - unable to add cloud config entries with exception: ", e);
        }
    }

    protected void addCloudConfigEntry(String keyname) {
        String keyvalue = this.getCogstartupConfigInst().getString(keyname);
        if (!StringUtils.isBlank(keyvalue)) {
            ConfigurationUtils.addCloudConfigEntry(keyname, keyvalue);
            log.debug("addCloudConfigEntry - add key='{}', value='{}'", (Object)keyname, (Object)keyvalue);
        }
    }

    protected CogstartupConfiguration getCogstartupConfigInst() {
        return this.cogstartupConfigurationInst;
    }

    protected void addCloudConfigEntryInt(String keyname) {
        int keyvalue = this.getCogstartupConfigInst().getInt(keyname);
        String keystr = Integer.toString(keyvalue);
        if (!StringUtils.isBlank(keystr)) {
            ConfigurationUtils.addCloudConfigEntry(keyname, keystr);
            log.debug("addCloudConfigEntryInt - add key='{}', value='{}'", (Object)keyname, (Object)keystr);
        }
    }

    public void setupNodeName(CogstartupConfiguration cogstartupConfig, PropertiesReader propertiesReader) {
        String externalDispatcher = null;
        if (cogstartupConfig != null) {
            externalDispatcher = cogstartupConfig.getString("externalDispatcher");
        }
        if (externalDispatcher == null || externalDispatcher.isEmpty()) {
            externalDispatcher = "http://localhost:9300/p2pd/dispatch";
        }
        this.localNodeName = propertiesReader.setLocalURI(externalDispatcher);
    }

    private void addSensitiveConfigEntries(CogstartupConfiguration cogstartupConfig) {
        if (cogstartupConfig != null) {
            this.addSensitiveConfigEntries(cogstartupConfig.getSensitiveConfigEntries());
            this.addSensitiveConfigEntries(cogstartupConfig.getGlobalSensDataEntry());
        }
    }

    public ArrayList<PredefinedConfiguration> loadPredefinedConfiguration() {
        ArrayList<PredefinedConfiguration> predConfigList = new ArrayList<PredefinedConfiguration>();
        String metadataPath = this.configurationSourceFactory.getMetadataPath();
        log.debug("metadata path is: {}", (Object)metadataPath);
        ArrayList<String> metadataFiles = ConfigurationUtils.getMetadataFiles(this.configurationSourceFactory.getMetadataPath());
        if (metadataFiles != null && !metadataFiles.isEmpty()) {
            for (String filePath : metadataFiles) {
                try {
                    log.debug("processing metadata file:" + filePath);
                    PredefinedConfiguration config = new PredefinedConfiguration(filePath);
                    predConfigList.add(config);
                }
                catch (ConfigurationException e) {
                    log.error("Exception occurred during adding metadata configuration. FilePath=" + filePath + ". Details:\r\n" + e.getLocalizedMessage());
                    log.debug("exception details", e);
                }
            }
        }
        return predConfigList;
    }

    private void addPredefinedConfiguration(ArrayList<PredefinedConfiguration> predConfigList) {
        if (predConfigList != null && !predConfigList.isEmpty()) {
            for (PredefinedConfiguration config : predConfigList) {
                if (config == null) continue;
                this.addCogXMLConfiguration(config, "metadata");
            }
        }
    }

    private CogLocaleConfiguration addCogLocaleConfiguration() {
        CogLocaleConfiguration config = null;
        if (!ConfigurationUtils.isCMEnabled()) {
            return null;
        }
        try {
            config = this.configurationSourceFactory.getCogLocaleConfiguration();
            this.addCogXMLConfiguration(config, "cogLocale");
        }
        catch (ConfigurationException e) {
            log.error("Exception occurred during adding CogLocale configuration. \r\n" + e.getMessage());
            log.debug("exception details", e);
        }
        return config;
    }

    private CogstartupConfiguration addCogstartupConfiguration() {
        CogstartupConfiguration config = null;
        try {
            config = this.configurationSourceFactory.getCogstartupConfiguration();
            this.addCogXMLConfiguration(config, "cogstartup");
        }
        catch (ConfigurationException e) {
            log.error("Unable to parse startup file, ignored ", e);
        }
        return config;
    }

    private void addCogXMLConfiguration(CogXMLConfiguration config, String fileName) {
        ConcurrentMapConfiguration cogXMLConfig = new ConcurrentMapConfiguration(config);
        this.addConfiguration(fileName, cogXMLConfig);
    }

    public void addPropertiesConfiguration(PropertiesReader propertiesReader) {
        this.addConfigurationWithName(propertiesReader.getNamedConfigurationForPath(this.localNodeName, 0));
        for (int layer = 0; layer < 4; ++layer) {
            this.addConfigurationWithName(propertiesReader.getNamedConfigurationForPath("global", layer));
        }
        this.indexBottomGlobal = this.compositeConfiguration.getConfigurations().size() - 1;
    }

    public boolean configSourcesReady() {
        return ConfigurationUtils.runningOnCloud() || !PropertiesReader.namedConfigurationIsEmpty(this.compositeConfiguration.getConfiguration(this.indexBottomGlobal)) && !PropertiesReader.namedConfigurationIsEmpty(this.compositeConfiguration.getConfiguration(this.indexBottomGlobal - 1));
    }

    public void startRestClientFactory() {
        RESTClientFactory.getInstance().startup();
    }

    protected void addConfigurationWithName(AbstractConfiguration localConfiguration) {
        String name = localConfiguration.getString("com.ibm.bi.config.external.PropertiesReader.configurationName");
        this.addConfiguration(name, localConfiguration);
    }

    private void addDispatcherProperties() {
        URL dispatcherProperties = this.getDispatcherPropertiesFilename();
        try {
            if ("jar".equals(dispatcherProperties.getProtocol())) {
                DynamicURLConfiguration propertiesConfiguration = new DynamicURLConfiguration(0, 10000, true, dispatcherProperties.toString());
                this.addConfiguration(dispatcherProperties.toString(), propertiesConfiguration);
            } else {
                String dispatcherPath = Paths.get(dispatcherProperties.toURI()).toString();
                this.addFileProperties(dispatcherPath, false);
            }
        }
        catch (URISyntaxException e) {
            log.error("unexpected exception", e);
        }
    }

    public URL getDispatcherPropertiesFilename() {
        return this.configurationSourceFactory.getDispatcherPropertiesFilename();
    }

    public void addFileProperties(String propertiesFilename, boolean checkCRC) {
        try {
            File propFile = this.getPropertiesFile(propertiesFilename);
            DynamicFileConfiguration propertiesConfiguration = new DynamicFileConfiguration(this.executorService, checkCRC, 0, 10000, true, propFile);
            this.addConfiguration(propertiesFilename, propertiesConfiguration);
        }
        catch (Exception e) {
            log.error("Unable to parse dispatcher configuration ", e);
        }
    }

    private File getPropertiesFile(String propertiesFilename) {
        String fileName = ConfigurationUtils.resolvePath(propertiesFilename);
        File propertiesFile = new File(fileName);
        this.maybeCreatePropertiesFile(propertiesFile);
        return propertiesFile;
    }

    private void maybeCreatePropertiesFile(File propertiesFile) {
        try {
            propertiesFile.createNewFile();
        }
        catch (IOException e) {
            log.error("Unable to create empty properties file: \"" + propertiesFile + "\"", e);
        }
    }

    public void addConfiguration(String name, AbstractConfiguration propertiesConfiguration) {
        this.compositeConfiguration.addConfiguration(propertiesConfiguration, name);
    }

    private void addEnvironmentConfiguration() {
        Set<String> whitelist = this.loadWhitelistFromFile();
        WhitelistEnvironmentConfiguration envConfig = new WhitelistEnvironmentConfiguration(whitelist);
        this.compositeConfiguration.addConfiguration(envConfig, "archaius.dynamicPropertyFactory.ENV_CONFIG");
    }

    private Set<String> loadWhitelistFromFile() {
        try {
            List<String> lines = FileUtils.readLines(new File(ConfigurationUtils.resolvePath(WHITELIST_FILENAME)), "utf-8");
            return new HashSet<String>(lines);
        }
        catch (IOException e) {
            return new HashSet<String>();
        }
    }

    public ArrayList<String> getKeyNames(String keypath) {
        ArrayList<String> keylist = new ArrayList<String>();
        ConcurrentCompositeConfiguration sysConfig = (ConcurrentCompositeConfiguration)ConfigurationManager.getConfigInstance();
        List<String> namedConfigs = sysConfig.getConfigurationNameList();
        for (String name : namedConfigs) {
            if (name == null || !name.startsWith(keypath)) continue;
            Configuration config = sysConfig.getConfiguration(name);
            Iterator<String> it = config.getKeys();
            while (it.hasNext()) {
                String key = it.next();
                if (key == null || key.length() <= 0) continue;
                keylist.add(key);
            }
        }
        return keylist;
    }

    public HashMap<String, String> getSensitiveConfigEntries() {
        return this.sensitiveConfigEntries;
    }

    public void addSensitiveConfigEntries(HashMap<String, String> sensitiveConfigEntries) {
        this.sensitiveConfigEntries.putAll(sensitiveConfigEntries);
    }

    public String getNonSensitiveFullKeyname(String keyname) {
        int last = keyname.lastIndexOf(".");
        if (last > 0) {
            String lastpart = keyname.substring(last + 1, keyname.length());
            String nonsen = this.findNonSensitiveKeyName(lastpart);
            return keyname.substring(0, last + 1) + nonsen;
        }
        return this.findNonSensitiveKeyName(keyname);
    }

    private String findNonSensitiveKeyName(String keyname) {
        String nonsen = this.sensitiveConfigEntries.get(keyname);
        if (nonsen != null && nonsen.length() > 0) {
            return nonsen;
        }
        return keyname;
    }

    public PropertiesConfiguration getMetadataProperties() {
        PropertiesConfiguration settings = PropertiesConfigurationFactory.make();
        for (PredefinedConfiguration predefinedConfiguration : this.getPredefinedConfiguration()) {
            settings.copy(predefinedConfiguration);
        }
        return settings;
    }

    static {
        System.setProperty("archaius.dynamicProperty.disableDefaultConfig", "true");
        System.setProperty("archaius.configuration.disableDelimiterParsing", "true");
    }
}

