/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config.setup;

import com.ibm.bi.config.setup.CogXMLConfiguration;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CogLocaleConfiguration
extends CogXMLConfiguration {
    private static final long serialVersionUID = -351722910794800959L;
    private static final Logger log = LoggerFactory.getLogger(CogLocaleConfiguration.class);
    private static final String SUPPORTED_CONTENT_LOCALES = "supportedContentLocales";
    private static final String SUPPORTED_PRODUCT_LOCALES = "supportedProductLocales";
    private static final String TIMEZONES = "timeZones";
    private static final String JSONARRAY_VALUE_LEADING = "{";
    private static final String JSONARRAY_VALUE_ENDING = "}";
    private static final String JSONARRAY_ITEM_DELIMETER = ",";
    private static ArrayList<String> localizedParmList = new ArrayList();
    private static ArrayList<TimeZone> canonicalSortedTimeZoneList;
    private ArrayList<String> productLocalesList = new ArrayList();

    public CogLocaleConfiguration(String string) throws ConfigurationException {
        super(string);
    }

    public CogLocaleConfiguration(URL url) throws ConfigurationException {
        super(url);
    }

    @Override
    protected void constructHierarchy(Document document) {
        this.constructLocalesHierachy(document);
        this.constructTimeZonesHierarchy(document);
    }

    private void constructLocalesHierachy(Document document) {
        HierarchicalConfiguration.Node parentNode = this.getRoot();
        Element documentElement = document.getDocumentElement();
        NodeList paramList = documentElement.getChildNodes();
        for (int i = 0; i < paramList.getLength(); ++i) {
            Node paramNode = paramList.item(i);
            if (!(paramNode instanceof Element)) continue;
            Element param = (Element)paramNode;
            this.addParamToHierachy(parentNode, param);
        }
    }

    private void addParamToHierachy(HierarchicalConfiguration.Node parentNode, Element param) {
        String parmName = param.getTagName();
        String value = null;
        if ("parameter".equals(parmName) || "crn:parameter".equals(parmName)) {
            parmName = param.getAttribute("name");
            if ("aliasRoots".equals(parmName)) {
                NodeList valueNodes = param.getElementsByTagName("value");
                if (valueNodes != null) {
                    Element valueElem = (Element)valueNodes.item(0);
                    value = this.serialized(valueElem);
                }
            } else {
                value = param.getTextContent().trim();
            }
            parentNode.addChild(new HierarchicalConfiguration.Node(parmName, value));
        } else {
            String elementTag = param.getTagName();
            if (elementTag.equals(SUPPORTED_PRODUCT_LOCALES)) {
                NodeList nodeList = param.getChildNodes();
                ArrayList<String> list = this.getList(nodeList);
                this.constructLocalizedLocaleNode(list, parentNode, elementTag);
                this.productLocalesList = list;
            } else if (elementTag.equals(SUPPORTED_CONTENT_LOCALES)) {
                NodeList nodeList = param.getChildNodes();
                ArrayList<String> list = this.getList(nodeList);
                if (this.productLocalesList == null) {
                    log.error("supportedProductLocales should be listed before supportedContentLocales in coglocale.xml");
                }
                this.constructLocalizedLocaleNode(list, parentNode, elementTag);
            } else {
                value = this.constructValue(param);
                parentNode.addChild(new HierarchicalConfiguration.Node(parmName, value));
            }
        }
    }

    private void constructLocalizedLocaleNode(ArrayList<String> localeList, HierarchicalConfiguration.Node parentNode, String elementTag) {
        ArrayList<String> listToLoop = elementTag.equals(SUPPORTED_CONTENT_LOCALES) ? this.productLocalesList : localeList;
        for (String localeId : listToLoop) {
            String parmName = elementTag + "_" + localeId;
            String value = this.constructSortedLocalizedValue(localeList, localeId, elementTag);
            parentNode.addChild(new HierarchicalConfiguration.Node(parmName, value));
        }
    }

    private String constructSortedLocalizedValue(ArrayList<String> list, String localeId, String elementTag) {
        StringBuilder ret = new StringBuilder(JSONARRAY_VALUE_LEADING);
        TreeMap<String, String> sortedMap = this.getSortedLocalizedMap(list, localeId);
        Set<String> set = sortedMap.keySet();
        Iterator<String> iter = set.iterator();
        while (iter.hasNext()) {
            String localizedName = iter.next();
            if (!elementTag.contains("Locale")) continue;
            ret.append((CharSequence)this.getOneItem(localizedName, sortedMap.get(localizedName)));
            if (!iter.hasNext()) continue;
            ret.append(JSONARRAY_ITEM_DELIMETER);
        }
        ret.append(JSONARRAY_VALUE_ENDING);
        return ret.toString();
    }

    private StringBuilder getOneItem(String localizedName, String localeId) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("\"");
        buffer.append(localeId);
        buffer.append("\"");
        buffer.append(":");
        buffer.append("\"");
        buffer.append(localizedName);
        buffer.append("\"");
        return buffer;
    }

    private TreeMap<String, String> getSortedLocalizedMap(ArrayList<String> list, String localeId) {
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        for (String oneId : list) {
            sorted.put(this.getLocaleName(localeId, oneId), oneId);
        }
        return sorted;
    }

    private ArrayList<String> getList(NodeList localeList) {
        ArrayList<String> retList = new ArrayList<String>();
        for (int i = 0; i < localeList.getLength(); ++i) {
            Node localeNode = localeList.item(i);
            if (!(localeNode instanceof Element)) continue;
            Element elem = (Element)localeNode;
            String localeId = elem.getAttribute("id");
            retList.add(localeId);
        }
        return retList;
    }

    private String constructValue(Element param) {
        String elementTag = param.getTagName();
        String value = "<value>";
        if (param.hasChildNodes()) {
            String serialized = this.serialized(param);
            serialized = serialized.substring(elementTag.length() + 2, serialized.length() - elementTag.length() - 4);
            value = value + serialized.trim();
        }
        value = value + "</value>";
        return value;
    }

    private String getLocaleName(String localeToDisplayWith, String localeToDisplay) {
        return ULocale.getDisplayName(localeToDisplay, localeToDisplayWith);
    }

    protected void constructTimeZonesHierarchy(Document document) {
        HierarchicalConfiguration.Node rootNode = this.getRoot();
        if (this.productLocalesList.isEmpty()) {
            this.productLocalesList.add("en");
        }
        for (String localeId : this.productLocalesList) {
            String parmName = "timeZones_" + localeId;
            Element tzsElement = document.createElement(parmName);
            String value = this.constructTimeZoneValue(document, tzsElement, localeId);
            rootNode.addChild(new HierarchicalConfiguration.Node(parmName, value));
        }
    }

    protected String constructTimeZoneValue(Document doc, Element tzParentElement, String localeId) {
        ULocale locale = new ULocale(localeId);
        StringBuilder tzBuf = new StringBuilder(JSONARRAY_VALUE_LEADING);
        ArrayList<TimeZone> tzList = CogLocaleConfiguration.getCanonicalTimeZones();
        int size = tzList.size();
        for (int i = 0; i < size; ++i) {
            TimeZone tz = tzList.get(i);
            tzBuf.append((CharSequence)this.getOneItem(this.getTimeZoneDisplayName(tz, locale), tz.getID()));
            if (i >= size - 1) continue;
            tzBuf.append(JSONARRAY_ITEM_DELIMETER);
        }
        tzBuf.append(JSONARRAY_VALUE_ENDING);
        return tzBuf.toString();
    }

    private static ArrayList<TimeZone> getCanonicalTimeZones() {
        if (canonicalSortedTimeZoneList != null) {
            return canonicalSortedTimeZoneList;
        }
        Set<String> idlist = TimeZone.getAvailableIDs(TimeZone.SystemTimeZoneType.CANONICAL, null, null);
        ArrayList<TimeZone> tzList = new ArrayList<TimeZone>();
        for (String id : idlist) {
            String region;
            TimeZone tz = TimeZone.getTimeZone(id);
            if (tz == null || (region = TimeZone.getRegion(tz.getID())) == null || "001".equals(region)) continue;
            tzList.add(tz);
        }
        CogLocaleConfiguration.sortTimeZoneListByOffset(tzList);
        canonicalSortedTimeZoneList = tzList;
        return canonicalSortedTimeZoneList;
    }

    private String getTimeZoneDisplayName(TimeZone tz, ULocale locale) {
        return "(" + tz.getDisplayName(false, 5, locale) + ") " + tz.getDisplayName(false, 7, locale);
    }

    private static void sortTimeZoneListByOffset(List<TimeZone> tzList) {
        try {
            Collections.sort(tzList, new Comparator<TimeZone>(){

                @Override
                public int compare(TimeZone tz1, TimeZone tz2) {
                    int offset2;
                    int offset1 = tz1.getRawOffset();
                    if (offset1 > (offset2 = tz2.getRawOffset())) {
                        return 1;
                    }
                    if (offset1 < offset2) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        catch (Exception e) {
            log.debug("Unable to sort time zone list: " + e);
        }
    }

    public void processGlobalLocaleSettings(ArrayList<String> globalSettings) {
        for (String localizedParam : localizedParmList) {
            if (!globalSettings.contains(localizedParam)) continue;
            Iterator<String> it = this.getKeys();
            while (it.hasNext()) {
                String key = it.next();
                if (key == null || !key.startsWith(localizedParam + "_")) continue;
                globalSettings.add(key);
            }
        }
    }

    static {
        localizedParmList.add(SUPPORTED_CONTENT_LOCALES);
        localizedParmList.add(SUPPORTED_PRODUCT_LOCALES);
        localizedParmList.add(TIMEZONES);
        canonicalSortedTimeZoneList = null;
    }
}

