/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config.setup;

import com.ibm.bi.config.setup.CogXMLConfiguration;
import com.ibm.bi.config.util.ConfigurationUtils;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class CogstartupConfiguration
extends CogXMLConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CogstartupConfiguration.class);
    private static final long serialVersionUID = 8023874574825161305L;
    private HashMap<String, String> sensitiveConfigEntries;

    public CogstartupConfiguration() {
    }

    public CogstartupConfiguration(String string) throws ConfigurationException {
        super(string);
    }

    public CogstartupConfiguration(URL url) throws ConfigurationException {
        super(url);
    }

    public HashMap<String, String> getSensitiveConfigEntries() {
        return this.sensitiveConfigEntries;
    }

    @Override
    protected void constructHierarchy(Document document) {
        this.sensitiveConfigEntries = new HashMap();
        HierarchicalConfiguration.Node parentNode = this.getRoot();
        Element element = document.getDocumentElement();
        NodeList paramsList = element.getChildNodes();
        for (int i = 0; i < paramsList.getLength(); ++i) {
            Element param;
            Node w3cnode = paramsList.item(i);
            if (!(w3cnode instanceof Element) || this.isDisabled(param = (Element)w3cnode)) continue;
            this.constructHierarchyForParam(parentNode, param);
        }
    }

    private boolean isDisabled(Element elem) {
        String attrDisabled = elem.getAttribute("disabled");
        return attrDisabled != null && attrDisabled.equalsIgnoreCase("true");
    }

    private void fixupPath(Element valueElem) {
        String resolvedPath;
        String pathValue;
        if (valueElem == null) {
            return;
        }
        String attrType = valueElem.getAttribute("xsi:type");
        if (!(attrType == null || attrType.compareTo("cfg:folderPath") != 0 && attrType.compareTo("cfg:filePath") != 0 || (pathValue = this.getText(valueElem)).length() <= 0 || ConfigurationUtils.isAbsolutePath(pathValue) || (resolvedPath = ConfigurationUtils.resolvePath("bin/" + pathValue)) == null || resolvedPath.length() <= 0)) {
            valueElem.setTextContent(resolvedPath);
        }
    }

    private Element getChildElement(Element currentElement, String nodeName, String attrName) {
        if (currentElement != null) {
            NodeList childList = currentElement.getChildNodes();
            for (int j = 0; j < childList.getLength(); ++j) {
                String nodetagname;
                Node w3cNode = childList.item(j);
                if (!(w3cNode instanceof Element) || (nodetagname = w3cNode.getNodeName()) == null || !nodetagname.equals(nodeName)) continue;
                if (attrName != null) {
                    String nodeattrname = ((Element)w3cNode).getAttribute("name");
                    if (nodeattrname == null || !nodeattrname.equals(attrName)) continue;
                    return (Element)w3cNode;
                }
                return (Element)w3cNode;
            }
        }
        return null;
    }

    private void processOpaqueParameter(HierarchicalConfiguration.Node parentNode, Element value, String paramName) {
        String attrType = value.getAttribute("xsi:type");
        if (attrType == null || attrType.length() == 0) {
            String valueStr = this.serialized(value);
            HierarchicalConfiguration.Node node = new HierarchicalConfiguration.Node(paramName, valueStr);
            parentNode.addChild(node);
            String valueStrNoSen = this.serializeWithoutSensitiveData(value);
            if (valueStrNoSen != null) {
                HierarchicalConfiguration.Node nodeNoSen = new HierarchicalConfiguration.Node(paramName + "_NOSENSDATA", valueStrNoSen);
                parentNode.addChild(nodeNoSen);
                this.sensitiveConfigEntries.put(paramName, paramName + "_NOSENSDATA");
            }
            if (paramName.equals("CM")) {
                this.extracCMParameters(node, value);
            }
            if (paramName.equals("AAA")) {
                this.extractAAAParameters(node, value);
            }
        }
    }

    private String serializeWithoutSensitiveData(Element value) {
        Element valueNoSensitiveData = (Element)value.cloneNode(true);
        if (this.clearSensitiveData(valueNoSensitiveData)) {
            return this.serialized(valueNoSensitiveData);
        }
        return null;
    }

    private boolean clearSensitiveData(Element currentElement) {
        boolean foundSensitiveData = false;
        if (currentElement != null) {
            NodeList childList = currentElement.getChildNodes();
            for (int j = 0; j < childList.getLength(); ++j) {
                Node w3cNode = childList.item(j);
                if (!(w3cNode instanceof Element)) continue;
                String nodetagname = w3cNode.getNodeName();
                Element elem = (Element)w3cNode;
                if (nodetagname != null && nodetagname.equals("crn:value") && this.isValueSensitiveData(elem)) {
                    elem.setTextContent("");
                    foundSensitiveData = true;
                }
                boolean childrenSen = this.clearSensitiveData(elem);
                foundSensitiveData = foundSensitiveData || childrenSen;
            }
        }
        return foundSensitiveData;
    }

    private boolean isValueSensitiveData(Element elem) {
        String encryptedAttr = elem.getAttribute("encrypted");
        if (encryptedAttr != null && encryptedAttr.equalsIgnoreCase("true")) {
            return true;
        }
        String xsitypeAttr = elem.getAttribute("xsi:type");
        return xsitypeAttr != null && (xsitypeAttr.equalsIgnoreCase("cfg:systemPassword") || xsitypeAttr.equalsIgnoreCase("cfg:credential"));
    }

    private void extracCMParameters(HierarchicalConfiguration.Node parentNode, Element value) {
        Element valueElem;
        Element paramElem;
        Element fsInst;
        Element eosinstances;
        Element csInst;
        Element dbinstances = this.getChildElement(value, "crn:instances", "database");
        if (dbinstances != null && (csInst = this.getChildElement(dbinstances, "crn:instance", null)) != null && (eosinstances = this.getChildElement(csInst, "crn:instances", "eos")) != null && (fsInst = this.getChildElement(eosinstances, "crn:instance", null)) != null && (paramElem = this.getChildElement(fsInst, "crn:parameter", "fileStoreURI")) != null && (valueElem = this.getChildElement(paramElem, "crn:value", null)) != null) {
            Element unixURIElem;
            String winurivalue = "";
            String unixurivalue = "";
            Element winURIElem = this.getChildElement(valueElem, "crn:item", "winURI");
            if (winURIElem != null) {
                winurivalue = winURIElem.getTextContent();
            }
            if ((unixURIElem = this.getChildElement(valueElem, "crn:item", "unixURI")) != null) {
                unixurivalue = unixURIElem.getTextContent();
            }
            HierarchicalConfiguration.Node eosnode = new HierarchicalConfiguration.Node("eos", "");
            parentNode.addChild(eosnode);
            HierarchicalConfiguration.Node fsnode = new HierarchicalConfiguration.Node("fileStoreURI", "");
            eosnode.addChild(fsnode);
            HierarchicalConfiguration.Node winurinode = new HierarchicalConfiguration.Node("winURI", winurivalue);
            fsnode.addChild(winurinode);
            HierarchicalConfiguration.Node unixurinode = new HierarchicalConfiguration.Node("unixURI", unixurivalue);
            fsnode.addChild(unixurinode);
        }
    }

    private void extractAAAParameters(HierarchicalConfiguration.Node parentNode, Element value) {
        String hostname;
        String[] values;
        String connection;
        Element valueElem;
        Element paramElem;
        NodeList instanceList;
        Element cogEx;
        Element authProviders = this.getChildElement(value, "crn:instances", "authProvider");
        if (authProviders != null && (cogEx = this.getInstanceByIDValue(instanceList = authProviders.getElementsByTagName("crn:instance"), "CognosEx")) != null && (paramElem = this.getChildElement(cogEx, "crn:parameter", "connection")) != null && (valueElem = this.getChildElement(paramElem, "crn:value", null)) != null && (connection = valueElem.getTextContent()) != null && (values = connection.split(":")).length == 2 && (hostname = values[0]).length() > 0) {
            this.createApacheHostNode(hostname);
        }
    }

    public Element getInstanceByIDValue(NodeList instanceList, String idValue) {
        Element instance = null;
        for (int i = 0; i < instanceList.getLength(); ++i) {
            Element valueElem;
            instance = (Element)instanceList.item(i);
            Element paramElem = this.getChildElement(instance, "crn:parameter", "id");
            if (paramElem == null || !(valueElem = this.getChildElement(paramElem, "crn:value", null)).getTextContent().equals(idValue)) continue;
            return instance;
        }
        return null;
    }

    private void createApacheHostNode(String hostname) {
        HierarchicalConfiguration.Node rootNode = this.getRoot();
        HierarchicalConfiguration.Node confignode = new HierarchicalConfiguration.Node("Configuration", "");
        rootNode.addChild(confignode);
        HierarchicalConfiguration.Node apachenode = new HierarchicalConfiguration.Node("ApacheDS", "");
        confignode.addChild(apachenode);
        HierarchicalConfiguration.Node hostnode = new HierarchicalConfiguration.Node("host", hostname);
        apachenode.addChild(hostnode);
    }

    protected void createExternalDispatcherNodes(HierarchicalConfiguration.Node parentNode, String urlvalue) {
        String dispScheme = "";
        String dispHostName = "";
        int dispPort = -1;
        try {
            URI uri = new URI(urlvalue);
            dispScheme = uri.getScheme();
            dispHostName = uri.getHost();
            dispPort = uri.getPort();
        }
        catch (Exception e) {
            log.error("createExternalDispatcherNodes - invalid externalDispatcher Uri '{}'", (Object)urlvalue, (Object)e);
            return;
        }
        HierarchicalConfiguration.Node schemenode = new HierarchicalConfiguration.Node("externalDispatcherScheme", dispScheme);
        parentNode.addChild(schemenode);
        HierarchicalConfiguration.Node hostnode = new HierarchicalConfiguration.Node("externalDispatcherHost", dispHostName);
        parentNode.addChild(hostnode);
        HierarchicalConfiguration.Node portnode = new HierarchicalConfiguration.Node("externalDispatcherPort", dispPort);
        parentNode.addChild(portnode);
        log.debug("createExternalDispatcherNodes - add 3 nodes for scheme = '{}', host = '{}', port = '{}'", dispScheme, dispHostName, dispPort);
    }

    private void constructHierarchyForParam(HierarchicalConfiguration.Node parentNode, Element param) {
        Element value;
        String paramName = param.getAttribute("name");
        String parentNodeName = parentNode.getName();
        HierarchicalConfiguration.Node paramNode = null;
        String eName = param.getNodeName();
        if (eName.equals("crn:parameter")) {
            value = (Element)param.getElementsByTagName("crn:value").item(0);
            String opaque = param.getAttribute("opaque");
            if (opaque != null && opaque.equalsIgnoreCase("true")) {
                this.processOpaqueParameter(parentNode, value, paramName);
            } else {
                this.fixupPath(value);
                this.clearSensitiveDataForValueElem(value, paramName, parentNode);
            }
        } else {
            value = param;
        }
        NodeList valueChildList = value.getChildNodes();
        for (int j = 0; j < valueChildList.getLength(); ++j) {
            Node w3cNode = valueChildList.item(j);
            if (w3cNode instanceof Text) {
                Text data = (Text)w3cNode;
                String text = data.getData().trim();
                if (text.isEmpty()) continue;
                HierarchicalConfiguration.Node node = new HierarchicalConfiguration.Node(paramName, text);
                parentNode.addChild(node);
                if (!paramName.equals("externalDispatcher")) continue;
                this.createExternalDispatcherNodes(parentNode, text);
                continue;
            }
            if (!(w3cNode instanceof Element) || this.isDisabled((Element)w3cNode)) continue;
            String nodeName = w3cNode.getNodeName();
            if (nodeName.equals("crn:item")) {
                HierarchicalConfiguration.Node node = new HierarchicalConfiguration.Node(paramName, this.getText(w3cNode));
                parentNode.addChild(node);
                continue;
            }
            if (!nodeName.equals("crn:parameter") && !nodeName.equals("crn:instances") && !nodeName.equals("crn:instance")) continue;
            if (paramNode == null) {
                if (parentNodeName != null && parentNodeName.equals("authProvider") && eName.equals("crn:instance")) {
                    paramName = this.getChildIdValue(paramName, param);
                }
                if (paramName.startsWith(".")) {
                    paramName = "ARCHNODE" + paramName;
                }
                paramNode = new HierarchicalConfiguration.Node(paramName);
                parentNode.addChild(paramNode);
            }
            this.constructHierarchyForParam(paramNode, (Element)w3cNode);
        }
    }

    private String getChildIdValue(String paramName, Element instanceElem) {
        Element valueElem;
        String value = paramName;
        Element paramElem = this.getChildElement(instanceElem, "crn:parameter", "id");
        if (paramElem != null && (valueElem = this.getChildElement(paramElem, "crn:value", null)) != null) {
            value = valueElem.getTextContent();
        }
        return value;
    }

    private void clearSensitiveDataForValueElem(Element valueElement, String paramName, HierarchicalConfiguration.Node parentNode) {
        if (this.isValueSensitiveData(valueElement)) {
            HierarchicalConfiguration.Node node = new HierarchicalConfiguration.Node(paramName + "_NOSENSDATA", "");
            parentNode.addChild(node);
            this.sensitiveConfigEntries.put(paramName, paramName + "_NOSENSDATA");
        }
    }

    private String getText(Node w3cNode) {
        StringBuffer buffer = new StringBuffer();
        NodeList nodeList = w3cNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Text)) continue;
            Text data = (Text)node;
            buffer.append(data.getData());
        }
        return buffer.toString();
    }

    public HashMap<String, String> getGlobalSensDataEntry() {
        HashMap<String, String> globalEntries = new HashMap<String, String>();
        if (this.sensitiveConfigEntries.get("CM") == null) {
            globalEntries.put("CM", "CM_NOSENSDATA");
        }
        if (this.sensitiveConfigEntries.get("AAA") == null) {
            globalEntries.put("AAA", "AAA_NOSENSDATA");
        }
        return globalEntries;
    }
}

