/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config.setup;

import com.ibm.bi.config.setup.CogXMLConfiguration;
import com.ibm.bi.config.setup.ServiceProperty;
import com.ibm.json.java.JSONObject;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PredefinedConfiguration
extends CogXMLConfiguration {
    private static final long serialVersionUID = -4098774197679062939L;
    private HierarchicalConfiguration.Node metadataNode = null;
    private ArrayList<String> globalSettings;
    private ArrayList<String> secureKeys;

    public PredefinedConfiguration(String string) throws ConfigurationException {
        super(string);
    }

    public PredefinedConfiguration(URL url) throws ConfigurationException {
        super(url);
    }

    @Override
    protected void constructHierarchy(Document document) {
        this.getGlobalSettings();
        this.getSecureKeys();
        Element documentElement = document.getDocumentElement();
        String serviceName = documentElement.getTagName();
        HierarchicalConfiguration.Node parentNode = new HierarchicalConfiguration.Node(serviceName, documentElement.getAttribute("label"));
        HierarchicalConfiguration.Node parentNode_metadata = new HierarchicalConfiguration.Node(serviceName, documentElement.getAttribute("label"));
        NodeList parametersList = documentElement.getChildNodes();
        for (int i = 0; i < parametersList.getLength(); ++i) {
            Node paramNode = parametersList.item(i);
            if (!(paramNode instanceof Element)) continue;
            Element parameters = (Element)paramNode;
            NodeList parmList = parameters.getElementsByTagName("parameter");
            for (int j = 0; j < parmList.getLength(); ++j) {
                Element param = (Element)parmList.item(j);
                ServiceProperty serviceProperty = new ServiceProperty(serviceName, param);
                this.addParamToHierachy(parentNode, serviceProperty);
                this.addMetadataToHierachy(parentNode_metadata, serviceProperty);
                this.addGlobalSettings(serviceProperty);
                this.addSecureKeys(serviceProperty);
            }
        }
        this.getRoot().addChild(parentNode);
        this.addToMetadata(parentNode_metadata);
    }

    private void addMetadataToHierachy(HierarchicalConfiguration.Node parentNode, ServiceProperty serviceProperty) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("type", serviceProperty.getType());
        jsonObj.put("defaultValue", serviceProperty.getDefault());
        jsonObj.put("label", serviceProperty.getLabel());
        jsonObj.put("minValue", serviceProperty.getMinValue());
        jsonObj.put("maxValue", serviceProperty.getMaxValue());
        parentNode.addChild(new HierarchicalConfiguration.Node(serviceProperty.getName(), jsonObj.toString()));
    }

    private void addToMetadata(HierarchicalConfiguration.Node parentNode) {
        if (this.metadataNode == null) {
            this.metadataNode = new HierarchicalConfiguration.Node("metadata");
            this.metadataNode.setParent(this.getRoot());
            this.getRoot().addChild(this.metadataNode);
        }
        this.metadataNode.addChild(parentNode);
    }

    private void addParamToHierachy(HierarchicalConfiguration.Node parentNode, ServiceProperty serviceProperty) {
        parentNode.addChild(new HierarchicalConfiguration.Node(serviceProperty.getName(), serviceProperty.getDefault()));
    }

    private void addGlobalSettings(ServiceProperty serviceProperty) {
        if (serviceProperty.isGlobal()) {
            this.getGlobalSettings().add(serviceProperty.getFullName());
        }
    }

    private void addSecureKeys(ServiceProperty serviceProperty) {
        if (serviceProperty.isSecureKey()) {
            this.getSecureKeys().add(serviceProperty.getFullName());
        }
    }

    public ArrayList<String> getGlobalSettings() {
        if (this.globalSettings == null) {
            this.globalSettings = new ArrayList();
        }
        return this.globalSettings;
    }

    public ArrayList<String> getSecureKeys() {
        if (this.secureKeys == null) {
            this.secureKeys = new ArrayList();
        }
        return this.secureKeys;
    }
}

