/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config.upgrade.cmplugin;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.config.util.XMLUtils;
import com.ibm.bi.json.JsonObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class UpgradeUiTheme
implements CMUpgradePlugin {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeUiTheme.class);
    protected static final String CONFIG_PARM_DEFAULTVALUE = "default";
    protected static final String CM_PROPERTY_NAME = "userProfileSettings";
    protected static final String CONFIG_KEY_NAME_THEME = "Glass.defaultTheme";
    protected static final String CMVALUE_JSONKEY_NAME_THEME = "ui_theme";
    protected static final String CONFIG_KEY_NAME_WELCOME = "Glass.welcomePage";
    protected static final String CMVALUE_JSONKEY_NAME_WELCOME = "ui_homePage";
    protected static final String CONFIG_KEY_NAME_LOGIN = "Glass.loginPage";
    protected static final String CMVALUE_JSONKEY_NAME_LOGIN = "ui_loginPage";
    protected static final HashMap<String, String> namesMapping = new HashMap();
    protected HashMap<String, String> valuesToUpdate = new HashMap();

    public void initialize(CMPluginDescriptor arg0, ICCLConfiguration arg1) throws Exception {
        this.valuesToUpdate = this.getValuesFromConfig();
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (data == null || this.valuesToUpdate.size() == 0) {
            LOG.info("No Glass extensions update found. Nothing to copy from config service to CM.");
            return null;
        }
        String upgradeFrom = (String)data.getPropertyValue("UPGRADE_FROM");
        String propXML = (String)data.getPropertyValue(CM_PROPERTY_NAME);
        CMUpgradeResult result = new CMUpgradeResult();
        boolean needUpgrade = this.checkForUpgrade(upgradeFrom);
        if (needUpgrade) {
            String updatedValue = this.upgradeCMPropValue(propXML);
            HashMap<String, String> upgradedData = new HashMap<String, String>();
            upgradedData.put(CM_PROPERTY_NAME, updatedValue);
            result.setData(upgradedData);
            result.setUpgradeStatus(1);
        } else {
            result.setUpgradeStatus(0);
        }
        result.setNextAction(1);
        return result;
    }

    protected String upgradeCMPropValue(String propXML) throws Exception {
        LOG.debug("Original data from CM is: {}", (Object)propXML);
        String propValue = null;
        try {
            Element root = XMLUtils.getDocElementFromXMLString(propXML);
            Element valueElem = XMLUtils.getChildElement(root, "value", null);
            String OrigValue = valueElem.getTextContent();
            LOG.debug("CM value after XML parsing: {}", (Object)OrigValue);
            String updatedString = this.updateExtension(OrigValue);
            valueElem.setTextContent(updatedString);
            propValue = XMLUtils.serializeToString(root);
        }
        catch (Exception ex) {
            LOG.error("Exception occurred when parsing prop value from CM. {}", (Object)propXML);
            throw ex;
        }
        LOG.debug("Upgraded propValue is: \r\n {}", (Object)propValue);
        return propValue;
    }

    protected String updateExtension(String origValue) {
        String upgraded = origValue;
        JsonObject extensionJson = null;
        try {
            extensionJson = JsonObject.parseString(origValue, false);
        }
        catch (IOException e) {
            LOG.error("Json parsing error for string: {}, caused by exception: {}", (Object)origValue, (Object)e.getMessage());
            return upgraded;
        }
        Set<String> propList = this.valuesToUpdate.keySet();
        for (String name : propList) {
            LOG.debug("name, {}, value to update: {}", (Object)name, (Object)this.valuesToUpdate.get(name));
            extensionJson.put(name, (Object)this.valuesToUpdate.get(name));
        }
        return extensionJson.toString();
    }

    protected HashMap<String, String> getValuesFromConfig() {
        Set<String> configParms = namesMapping.keySet();
        for (String name : configParms) {
            String configValue = ConfigurationPropertyFactory.getInstance().getStringProperty(name).get();
            if (!this.isSet(configValue)) continue;
            this.addConfigValues(name, configValue);
        }
        return this.valuesToUpdate;
    }

    protected void addConfigValues(String name, String configValue) {
        String jsonPropName = namesMapping.get(name);
        if (StringUtils.isNotBlank(jsonPropName)) {
            this.valuesToUpdate.put(jsonPropName, configValue);
        }
    }

    protected boolean isSet(String value) {
        return !StringUtils.isBlank(value) && !value.equals(CONFIG_PARM_DEFAULTVALUE);
    }

    protected boolean checkForUpgrade(String upgradeFrom) {
        return "DB".equals(upgradeFrom);
    }

    public void terminate() throws Exception {
    }

    static {
        namesMapping.put(CONFIG_KEY_NAME_THEME, CMVALUE_JSONKEY_NAME_THEME);
        namesMapping.put(CONFIG_KEY_NAME_WELCOME, CMVALUE_JSONKEY_NAME_WELCOME);
        namesMapping.put(CONFIG_KEY_NAME_LOGIN, CMVALUE_JSONKEY_NAME_LOGIN);
    }
}

