/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config.util;

import com.ibm.bi.platform.commons.crypto.CAMCryptoException;
import com.ibm.bi.platform.commons.crypto.JCAMCrypto;
import com.ibm.bi.platform.commons.crypto.internal.session.EncryptingSession;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AAAUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AAAUtils.class);
    public static final String CREDENTIAL = "credential";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    private static EncryptingSession es = null;

    public static void setES(EncryptingSession es) {
        AAAUtils.es = es;
    }

    public static String encryptString(String data) {
        try {
            return AAAUtils.encryptBytes(data.getBytes("utf-8"));
        }
        catch (Exception e) {
            LOG.error("Unable to encrypt data, {}, exception occurred: {}", (Object)data, (Object)e);
            throw new RuntimeException("Unable to encrypt data.", e);
        }
    }

    public static String encryptBytes(byte[] bytes) throws CAMCryptoException {
        EncryptingSession es = AAAUtils.getEncryptingSession();
        byte[] encrypted = es.encryptData(bytes);
        return Base64.getEncoder().encodeToString(encrypted);
    }

    protected static EncryptingSession getEncryptingSession() throws CAMCryptoException {
        if (es != null) {
            return es;
        }
        return JCAMCrypto.createEncryptingSession();
    }

    public static String decryptString(String data) {
        return AAAUtils.decryptBytes(Base64.getDecoder().decode(data));
    }

    public static String decryptBytes(byte[] encrypted) {
        try {
            EncryptingSession es = AAAUtils.getEncryptingSession();
            byte[] decrypted = es.decryptData(encrypted);
            return new String(decrypted, "utf-8");
        }
        catch (Exception e) {
            LOG.error("Unable to decrypt data", e);
            throw new RuntimeException(e);
        }
    }
}

