/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config.util;

import com.ibm.bi.config.util.AAAUtils;
import com.ibm.bi.config.util.XMLUtils;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigAAAXML2JsonConvertor {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigAAAXML2JsonConvertor.class);
    private JsonObject authenticationJson;
    private JsonArray authProviders;
    private Map<String, JsonObject> listOfProviders = new HashMap<String, JsonObject>();
    private Map<String, Element> listOfInstanceElem = new HashMap<String, Element>();
    private Element rootElem;
    private Element instancesElem;
    private boolean shouldDecrypt = false;

    public ConfigAAAXML2JsonConvertor(String aaaSettings) throws ConfigurationException {
        this.parse(aaaSettings);
    }

    public ConfigAAAXML2JsonConvertor(String aaaSettings, boolean toDecrypt) throws ConfigurationException {
        this.shouldDecrypt = toDecrypt;
        this.parse(aaaSettings);
    }

    private void parse(String aaaSettings) throws ConfigurationException {
        try {
            this.rootElem = XMLUtils.getAAARoot(aaaSettings);
            this.parseAAA(this.rootElem);
        }
        catch (Exception e) {
            LOG.error("XML parsing error:", e);
            throw new ConfigurationException("XML parsing error: " + e.getMessage());
        }
    }

    public boolean shouldDecrypt() {
        return this.shouldDecrypt;
    }

    public JsonArray getAuthProviders() {
        return this.authProviders;
    }

    public JsonObject getAuthentication() {
        return this.authenticationJson;
    }

    public JsonObject getAuthProvider(String id) {
        return this.listOfProviders.get(id);
    }

    public Set<String> getListOfProviderIDs() {
        return this.listOfProviders.keySet();
    }

    private void parseAAA(Element param) {
        String eName = param.getNodeName();
        if (eName.equals("crn:parameter")) {
            Element value = (Element)param.getElementsByTagName("crn:value").item(0);
            this.extractAAAParameters(value);
        }
    }

    private void extractAAAParameters(Element valueElem) {
        this.setAuthenticationNode(valueElem);
        this.setAuthProvidersNode(valueElem);
    }

    private void setAuthProvidersNode(Element valueElem) {
        this.authProviders = this.getAuthProviders(valueElem);
    }

    private JsonArray getAuthProviders(Element valueElem) {
        this.instancesElem = this.getChildElement(valueElem, "crn:instances", "authProvider");
        JsonArray providerList = new JsonArray();
        if (this.instancesElem != null) {
            NodeList instanceList = this.instancesElem.getElementsByTagName("crn:instance");
            for (int i = 0; i <= instanceList.getLength(); ++i) {
                Node instanceNode = instanceList.item(i);
                if (!(instanceNode instanceof Element)) continue;
                JsonObject provider = this.getOneProvider((Element)instanceNode);
                providerList.add(provider);
                this.listOfProviders.put(provider.getString("id"), provider);
                this.listOfInstanceElem.put(provider.getString("id"), (Element)instanceNode);
            }
        }
        return providerList;
    }

    private JsonObject getOneProvider(Element instanceElem) {
        JsonObject provider = new JsonObject();
        provider.put("name", (Object)instanceElem.getAttribute("name"));
        provider.put("class", (Object)instanceElem.getAttribute("class"));
        NodeList params = instanceElem.getChildNodes();
        for (int i = 0; i < params.getLength(); ++i) {
            Element parmElem;
            Node node = params.item(i);
            if (!(node instanceof Element) || !(parmElem = (Element)params.item(i)).getTagName().equals("crn:parameter")) continue;
            this.addParameter(provider, parmElem);
        }
        return provider;
    }

    private void addParameter(JsonObject jsonObj, Element parmElem) {
        String nodeattrname = parmElem.getAttribute("name");
        Object value = this.getValue(parmElem);
        jsonObj.put(nodeattrname, value);
    }

    private void setAuthenticationNode(Element valueElem) {
        this.authenticationJson = this.getAuthenticationJson(valueElem);
    }

    private JsonObject getAuthenticationJson(Element valueElem) {
        JsonObject authenticationObj = new JsonObject();
        if (valueElem != null) {
            NodeList childList = valueElem.getChildNodes();
            for (int j = 0; j < childList.getLength(); ++j) {
                Element parmElem;
                Node w3cNode = childList.item(j);
                if (!(w3cNode instanceof Element) || !(parmElem = (Element)w3cNode).getTagName().equals("crn:parameter")) continue;
                this.addParameter(authenticationObj, parmElem);
            }
        }
        return authenticationObj;
    }

    private Object getValue(Element parentNode) {
        Object value;
        Element valueElem = this.getChildElement(parentNode, "crn:value", null);
        String type = this.getType(valueElem);
        String encryptedAttr = valueElem.getAttribute("encrypted");
        if (this.shouldDecrypt && !StringUtils.isBlank(encryptedAttr)) {
            String encrypted = valueElem.getTextContent();
            value = this.getDecryptValue(encrypted);
        } else {
            value = type.startsWith("xsd:") ? valueElem.getTextContent() : (type.equals("cfg:tenancyInfo") ? this.getTenancyInfo(valueElem) : (type.equals("cfg:array") ? this.getArrayValue(valueElem) : (type.equals("cfg:credential") ? this.getCredentialValue(valueElem) : valueElem.getTextContent())));
        }
        return value;
    }

    protected String getDecryptValue(String encrypted) {
        return AAAUtils.decryptString(encrypted);
    }

    private Object getCredentialValue(Element valueElem) {
        Object value = valueElem.getTextContent();
        if (this.shouldDecrypt && value != null) {
            String decryptedXML = this.getDecryptValue(value.toString());
            value = ConfigAAAXML2JsonConvertor.getCredentialJson(decryptedXML);
        }
        return value;
    }

    public static Object getCredentialJson(String decryptedXML) {
        Element rootElem = XMLUtils.getDocElementFromXMLString(decryptedXML);
        JsonObject value = null;
        if (rootElem != null && rootElem.getTagName().equals("credential")) {
            value = new JsonObject();
            Element userName = XMLUtils.getChildElement(rootElem, "username", null);
            value.put("username", (Object)userName.getTextContent());
            Element password = XMLUtils.getChildElement(rootElem, "password", null);
            value.put("password", (Object)password.getTextContent());
        }
        return value;
    }

    private JsonObject getArrayValue(Element valueElem) {
        JsonObject settings = new JsonObject();
        NodeList params = valueElem.getElementsByTagName("crn:parameter");
        for (int i = 0; i < params.getLength(); ++i) {
            Element parmElem = (Element)params.item(i);
            this.addParameter(settings, parmElem);
        }
        return settings;
    }

    private JsonObject getTenancyInfo(Element valueElem) {
        JsonObject value = new JsonObject();
        Element itemElem = this.getChildElement(valueElem, "crn:item", null);
        value.put(itemElem.getAttribute("name"), (Object)itemElem.getTextContent());
        return value;
    }

    private String getType(Element valueElem) {
        return valueElem.getAttribute("xsi:type");
    }

    private Element getChildElement(Element currentElement, String nodeName, String attrName) {
        if (currentElement != null) {
            NodeList childList = currentElement.getChildNodes();
            for (int j = 0; j < childList.getLength(); ++j) {
                String nodetagname;
                Node w3cNode = childList.item(j);
                if (!(w3cNode instanceof Element) || (nodetagname = w3cNode.getNodeName()) == null || !nodetagname.equals(nodeName)) continue;
                if (attrName != null) {
                    String nodeattrname = ((Element)w3cNode).getAttribute("name");
                    if (nodeattrname == null || !nodeattrname.equals(attrName)) continue;
                    return (Element)w3cNode;
                }
                return (Element)w3cNode;
            }
        }
        return null;
    }

    public String removeAuthProvider(String nsid) {
        if (this.rootElem == null) {
            throw new IllegalArgumentException("ConfigAAAXML2JsonConvertor is not initialized properly.");
        }
        Element instanceElem = this.listOfInstanceElem.get(nsid);
        this.instancesElem.removeChild(instanceElem);
        this.authProviders.remove(this.getAuthProvider(nsid));
        this.listOfProviders.remove(nsid);
        String aaaSettings = XMLUtils.serializeToString(this.rootElem);
        return aaaSettings;
    }
}

