/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.crypto.tool;

import com.ibm.bi.platform.commons.crypto.CAMCryptoException;
import com.ibm.bi.platform.commons.crypto.CamCryptoMessageKeys;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.stream.Collectors;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CliUtils {
    private static final HelpFormatter FORMATTER = new HelpFormatter();
    public static PrintStream cliOut = System.out;
    public static InputStream cliIn = System.in;
    private static String helpText;

    private static CmdOption[] cmdOptionsOfGroup(CmdOptionGroup group) {
        return (CmdOption[])Arrays.stream(CmdOption.values()).filter(cmdOption -> cmdOption.group.equals((Object)group)).toArray(CmdOption[]::new);
    }

    private static Map<Option, Integer> buildOptionsGroupRank() {
        HashMap<Option, Integer> map = new HashMap<Option, Integer>();
        for (CmdOption cmdOption : CmdOption.values()) {
            map.put(cmdOption.option, cmdOption.group.rank);
        }
        return map;
    }

    private static String optionsGroupText(String header, Options options) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(header + "\n");
        StringWriter stringWriter = new StringWriter();
        FORMATTER.printOptions(new PrintWriter(stringWriter), 74, options, 1, 3);
        stringBuilder.append(stringWriter.toString());
        return stringBuilder.toString();
    }

    private static Options toApacheOptions(CmdOption ... cmdOptions) {
        Options options = new Options();
        for (CmdOption cmdOption : cmdOptions) {
            options.addOption(cmdOption.option);
        }
        return options;
    }

    private static String commandUsageText(String header, Options options) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(header + "\n");
        StringWriter stringWriter = new StringWriter();
        FORMATTER.printUsage(new PrintWriter(stringWriter), 74, "ThirdPartyCertificateTool.(bat|sh)", options);
        stringBuilder.append(stringWriter.toString());
        return stringBuilder.toString();
    }

    public static String askForInfo(String question) {
        cliOut.println(question);
        while (true) {
            try {
                String response = new Scanner(cliIn).next(".*");
                return response;
            }
            catch (NoSuchElementException noSuchElementException) {
                continue;
            }
            break;
        }
    }

    public static YesNoAnswer askYesNoQuestion(String question) {
        cliOut.println(question);
        while (true) {
            try {
                cliOut.println("yes|no|y|n");
                String response = new Scanner(cliIn).next("yes|y|no|n");
                return YesNoAnswer.fromString(response);
            }
            catch (NoSuchElementException noSuchElementException) {
                continue;
            }
            break;
        }
    }

    public static void printlnInfo(String info) {
        cliOut.println(info);
    }

    public static void printHelp() {
        cliOut.print(helpText);
    }

    public static String trimMsg(String cryptoMessage) {
        return cryptoMessage.replaceAll("COM-CRP-\\d{4}\\s(.*)", "$1");
    }

    static {
        CmdOption[] operationModeOptsGroup = CliUtils.cmdOptionsOfGroup(CmdOptionGroup.OPERATION_MODE);
        CmdOption[] operationModifiersOptsGroup = CliUtils.cmdOptionsOfGroup(CmdOptionGroup.OPERATION_MODIFIER);
        CmdOption[] infoFlagsOptsGroup = CliUtils.cmdOptionsOfGroup(CmdOptionGroup.INFO_FLAG);
        Map<Option, Integer> optionGroupRank = CliUtils.buildOptionsGroupRank();
        FORMATTER.setOptionComparator((o1, o2) -> (Integer)optionGroupRank.get((Option)o1) - (Integer)optionGroupRank.get((Option)o2));
        StringBuilder helpTextBuilder = new StringBuilder();
        helpTextBuilder.append(CliUtils.trimMsg(CamCryptoMessageKeys.cli_help.buildMessage().getLocalizedMessage()));
        helpTextBuilder.append("\n\n");
        helpTextBuilder.append(CliUtils.optionsGroupText(CliUtils.trimMsg(CamCryptoMessageKeys.cli_operation_mode.buildMessage().getLocalizedMessage()), CliUtils.toApacheOptions(operationModeOptsGroup)));
        helpTextBuilder.append("\n");
        helpTextBuilder.append(CliUtils.optionsGroupText(CliUtils.trimMsg(CamCryptoMessageKeys.cli_operation_modifier.buildMessage().getLocalizedMessage()), CliUtils.toApacheOptions(operationModifiersOptsGroup)));
        helpTextBuilder.append("\n");
        helpTextBuilder.append(CliUtils.optionsGroupText(CliUtils.trimMsg(CamCryptoMessageKeys.cli_information_flag.buildMessage().getLocalizedMessage()), CliUtils.toApacheOptions(infoFlagsOptsGroup)));
        helpTextBuilder.append("\n");
        helpTextBuilder.append(CliUtils.trimMsg(CamCryptoMessageKeys.cli_usage.buildMessage().getLocalizedMessage()));
        helpTextBuilder.append("\n\n");
        String commandsUsageText = Arrays.stream(Command.values()).map(command -> CliUtils.commandUsageText(((Command)command).description, ((Command)command).options)).collect(Collectors.joining("\n"));
        helpTextBuilder.append(commandsUsageText);
        helpText = helpTextBuilder.toString();
    }

    public static enum Command {
        IMPORT_CRYPTO_TARGET_CERT(CliUtils.trimMsg(CamCryptoMessageKeys.cli_import_crypto_target_cert.buildMessage().getLocalizedMessage()), CmdOption.IMPORT_MODE.asRequired(), CmdOption.CRYPTO_COMMAND.asRequired(), CmdOption.CERT_LOCATION.asRequired(), CmdOption.CERT_CHAIN_LOCATION.asRequired(), CmdOption.KEY_STORE_PASSWORD.asNotRequired()),
        IMPORT_TRUSTED_CERT(CliUtils.trimMsg(CamCryptoMessageKeys.cli_import_trusted_cert.buildMessage().getLocalizedMessage()), CmdOption.IMPORT_MODE.asRequired(), CmdOption.TRUST_STORE_COMMAND.asRequired(), CmdOption.CERT_LOCATION.asRequired(), CmdOption.KEY_STORE_PASSWORD.asNotRequired()),
        IMPORT_CRYPTO_KEY_SEPARATE_ENTRIES(CliUtils.trimMsg(CamCryptoMessageKeys.cli_import_crypto_key_separate_entries.buildMessage().getLocalizedMessage()), CmdOption.IMPORT_MODE.asRequired(), CmdOption.CRYPTO_COMMAND.asRequired(), CmdOption.PRIVATE_KEY_LOCATION.asRequired(), CmdOption.KEY_SOURCE_PASSWORD.asRequired(), CmdOption.CERT_LOCATION.asRequired(), CmdOption.CERT_CHAIN_LOCATION.asRequired(), CmdOption.CRYPTO_ALGORITHM.asRequired(), CmdOption.KEY_STORE_PASSWORD.asNotRequired()),
        IMPORT_CRYPTO_KEY_PKCS12(CliUtils.trimMsg(CamCryptoMessageKeys.cli_import_crypto_key_pkcs12.buildMessage().getLocalizedMessage()), CmdOption.IMPORT_MODE.asRequired(), CmdOption.CRYPTO_COMMAND.asRequired(), CmdOption.PKCS12_KEY_CERTS_LOCATION.asRequired(), CmdOption.KEY_SOURCE_PASSWORD.asRequired(), CmdOption.CRYPTO_ALGORITHM.asRequired(), CmdOption.KEY_STORE_PASSWORD.asNotRequired()),
        EXPORT_CRYPTO_CERT(CliUtils.trimMsg(CamCryptoMessageKeys.cli_export_crypto_cert.buildMessage().getLocalizedMessage()), CmdOption.EXPORT_MODE.asRequired(), CmdOption.CRYPTO_COMMAND.asRequired(), CmdOption.CERT_LOCATION.asRequired(), CmdOption.KEY_STORE_PASSWORD.asNotRequired()),
        EXPORT_CA_CERT(CliUtils.trimMsg(CamCryptoMessageKeys.cli_export_ca_cert.buildMessage().getLocalizedMessage()), CmdOption.EXPORT_MODE.asRequired(), CmdOption.TRUST_STORE_COMMAND.asRequired(), CmdOption.CERT_LOCATION.asRequired(), CmdOption.KEY_STORE_PASSWORD.asNotRequired()),
        GENERATE_CSR(CliUtils.trimMsg(CamCryptoMessageKeys.cli_generate_csr.buildMessage().getLocalizedMessage()), CmdOption.CSR_MODE.asRequired(), CmdOption.CRYPTO_COMMAND.asRequired(), CmdOption.DISTINGUISHED_NAME.asRequired(), CmdOption.CSR_LOCATION.asRequired(), CmdOption.SUBJECT_ALTERNATIVE_NAME_DNS_NAMES.asNotRequired(), CmdOption.SUBJECT_ALTERNATIVE_NAME_IP_ADDRESSES.asNotRequired(), CmdOption.SUBJECT_ALTERNATIVE_NAME_EMAIL_ADDRESSES.asNotRequired(), CmdOption.CRYPTO_ALGORITHM.asRequired(), CmdOption.KEY_STORE_PASSWORD.asNotRequired());

        private final Options options;
        private final String description;
        private CommandLine commandLine;

        private Command(String description, CmdOption ... partialOptions) {
            this.description = description;
            this.options = new Options();
            for (CmdOption cmdOption : partialOptions) {
                this.options.addOption(cmdOption.option);
            }
        }

        public static Command fromArgs(String[] args) throws CAMCryptoException {
            BasicParser commandLineParser = new BasicParser();
            return Arrays.stream(Command.values()).map(command -> {
                try {
                    command.commandLine = commandLineParser.parse(command.options, args);
                    return command;
                }
                catch (ParseException parseException) {
                    return null;
                }
            }).filter(command -> command != null).findFirst().orElseThrow(() -> new CAMCryptoException(CamCryptoMessageKeys.could_not_parse_command.buildMessage()));
        }

        public String optionValue(CmdOption cmdOption) {
            return this.commandLine.getOptionValue(cmdOption.option.getOpt());
        }
    }

    public static enum CmdOption {
        IMPORT_MODE("i", CliUtils.trimMsg(CamCryptoMessageKeys.i_cli_option.buildMessage().getLocalizedMessage()), CmdOptionGroup.OPERATION_MODE),
        EXPORT_MODE("E", CliUtils.trimMsg(CamCryptoMessageKeys.big_e_cli_option.buildMessage().getLocalizedMessage()), CmdOptionGroup.OPERATION_MODE),
        CSR_MODE("c", CliUtils.trimMsg(CamCryptoMessageKeys.c_cli_option.buildMessage().getLocalizedMessage()), CmdOptionGroup.OPERATION_MODE),
        JRE_PUBLISHER_CERTS_MODE("P", CliUtils.trimMsg(CamCryptoMessageKeys.big_p_cli_option.buildMessage().getLocalizedMessage()), CmdOptionGroup.OPERATION_MODE),
        CRYPTO_COMMAND("e", CliUtils.trimMsg(CamCryptoMessageKeys.e_cli_option.buildMessage().getLocalizedMessage()), CmdOptionGroup.OPERATION_MODIFIER),
        TRUST_STORE_COMMAND("T", CliUtils.trimMsg(CamCryptoMessageKeys.big_t_cli_option.buildMessage().getLocalizedMessage()), CmdOptionGroup.OPERATION_MODIFIER),
        PRIVATE_KEY_LOCATION("k", "path/to/PKCS#8", CliUtils.trimMsg(CamCryptoMessageKeys.k_cli_option.buildMessage().getLocalizedMessage()), CmdOptionGroup.INFO_FLAG),
        PKCS12_KEY_CERTS_LOCATION("K", "path/to/PKCS#12", CliUtils.trimMsg(CamCryptoMessageKeys.big_k_cli_option.buildMessage().getLocalizedMessage()), CmdOptionGroup.INFO_FLAG),
        CERT_LOCATION("r", "path/to/CertOrCSR", CliUtils.trimMsg(CamCryptoMessageKeys.r_cli_option.buildMessage().getLocalizedMessage()), CmdOptionGroup.INFO_FLAG),
        CSR_LOCATION("r", "path/to/CertOrCSR", CliUtils.trimMsg(CamCryptoMessageKeys.r_cli_option.buildMessage().getLocalizedMessage()), CmdOptionGroup.INFO_FLAG),
        CERT_CHAIN_LOCATION("t", "path/to/CertChain", CliUtils.trimMsg(CamCryptoMessageKeys.t_cli_option.buildMessage().getLocalizedMessage()), CmdOptionGroup.INFO_FLAG),
        CRYPTO_ALGORITHM("a", "keyPairAlgorithm", CliUtils.trimMsg(CamCryptoMessageKeys.a_cli_option.buildMessage().getLocalizedMessage()), CmdOptionGroup.INFO_FLAG),
        KEY_STORE_PASSWORD("p", "keystorePassword", CliUtils.trimMsg(CamCryptoMessageKeys.p_cli_option.buildMessage().getLocalizedMessage()), CmdOptionGroup.INFO_FLAG),
        KEY_SOURCE_PASSWORD("w", "privateKeySourcePassword", CliUtils.trimMsg(CamCryptoMessageKeys.w_cli_option.buildMessage().getLocalizedMessage()), CmdOptionGroup.INFO_FLAG),
        DISTINGUISHED_NAME("d", "dn", CliUtils.trimMsg(CamCryptoMessageKeys.d_cli_option.buildMessage().getLocalizedMessage()), CmdOptionGroup.INFO_FLAG),
        JRE_CERTS_KEYSTORE_PASSWORD("j", "jreCertsKeystorePassword", CliUtils.trimMsg(CamCryptoMessageKeys.j_cli_option.buildMessage().getLocalizedMessage()), CmdOptionGroup.INFO_FLAG),
        SUBJECT_ALTERNATIVE_NAME_DNS_NAMES("H", "subjectAlternativeNameDnsNames", CliUtils.trimMsg(CamCryptoMessageKeys.big_h_cli_option.buildMessage().getLocalizedMessage()), CmdOptionGroup.INFO_FLAG),
        SUBJECT_ALTERNATIVE_NAME_IP_ADDRESSES("I", "subjectAlternativeIpAddresses", CliUtils.trimMsg(CamCryptoMessageKeys.big_i_cli_option.buildMessage().getLocalizedMessage()), CmdOptionGroup.INFO_FLAG),
        SUBJECT_ALTERNATIVE_NAME_EMAIL_ADDRESSES("M", "subjectAlternativeEmailAddresses", CliUtils.trimMsg(CamCryptoMessageKeys.big_m_cli_option.buildMessage().getLocalizedMessage()), CmdOptionGroup.INFO_FLAG);

        public final Option option;
        public final CmdOptionGroup group;

        private CmdOption(String shortName, String description, CmdOptionGroup group) {
            this.option = new Option(shortName, false, description);
            this.group = group;
        }

        private CmdOption(String shortName, String argName, String description, CmdOptionGroup group) {
            this.option = new Option(shortName, true, description);
            this.option.setArgName(argName);
            this.group = group;
        }

        public CmdOption asRequired() {
            this.option.setRequired(true);
            return this;
        }

        public CmdOption asNotRequired() {
            this.option.setRequired(false);
            return this;
        }
    }

    public static enum CmdOptionGroup {
        OPERATION_MODE(1),
        OPERATION_MODIFIER(2),
        INFO_FLAG(3);

        public final int rank;

        private CmdOptionGroup(int rank) {
            this.rank = rank;
        }
    }

    public static enum YesNoAnswer {
        YES,
        NO;


        public static YesNoAnswer fromString(String str) {
            if (str.matches("yes|y")) {
                return YES;
            }
            if (str.matches("no|n")) {
                return NO;
            }
            throw new IllegalArgumentException("Only yes or no please");
        }
    }
}

