/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.crypto.tool;

import com.ibm.bi.platform.commons.crypto.JCAMCryptoConfiguration;
import com.ibm.bi.platform.commons.crypto.internal.utils.GenericUtils;
import java.io.File;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    public static final char[] CA_KEYSTORE_DEFAULT_PASSWORD = new String("NoPassWordSet").toCharArray();
    public static final char[] CA_JRE_PUBLISHER_KEYSTORE_PASSWORD = GenericUtils.systemProperty("ca.jre.publisher.keystore.password").orElse(new String("changeit")).toCharArray();
    public static final char[] JRE_PUBLISHER_CERTS_PASSWORD = GenericUtils.systemProperty("jre.publisher.certs.password").orElse(new String("changeit")).toCharArray();
    private static final Logger LOGGER = LoggerFactory.getLogger(Config.class);
    public static String PKCS12_CAM_KEYSTORE_FILE;
    public static String JKS_CAM_KEYSTORE_FILE;
    public static String JRE_PUBLISHER_CERTS_FILE;
    public static String CAM_KEYSTORE_LOCK_FILE;

    static {
        if (!GenericUtils.systemProperty("install.dir").isPresent()) {
            String installDir = null;
            try {
                installDir = new File(Config.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getParentFile().getParent();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.setProperty("install.dir", Optional.ofNullable(installDir).orElse("#"));
        }
        LOGGER.info("The install.dir property is set to {}", (Object)GenericUtils.systemProperty("install.dir").orElse("#"));
        JKS_CAM_KEYSTORE_FILE = JCAMCryptoConfiguration.getProvider().getCamKeystoreFile();
        LOGGER.info("The JKS CAM Keystore location is {}", (Object)JKS_CAM_KEYSTORE_FILE);
        String jksCAMKeyStoreFile = JCAMCryptoConfiguration.getProvider().getCamKeystoreFile();
        try {
            int jksExtensionIndex = jksCAMKeyStoreFile.lastIndexOf(".jks");
            PKCS12_CAM_KEYSTORE_FILE = jksCAMKeyStoreFile.substring(0, jksExtensionIndex);
        }
        catch (RuntimeException e) {
            PKCS12_CAM_KEYSTORE_FILE = jksCAMKeyStoreFile;
        }
        LOGGER.info("The PKCS12 CAM Keystore location is {}", (Object)PKCS12_CAM_KEYSTORE_FILE);
        String javaHomePath = System.getProperty("java.home");
        assert (javaHomePath != null);
        JRE_PUBLISHER_CERTS_FILE = javaHomePath + "/lib/security/cacerts".replace('/', File.separatorChar);
        LOGGER.info("The JRE publisher cert file location is {}", (Object)JRE_PUBLISHER_CERTS_FILE);
        CAM_KEYSTORE_LOCK_FILE = PKCS12_CAM_KEYSTORE_FILE + ".lock";
        LOGGER.info("CAM keystore lock file location is {}", (Object)CAM_KEYSTORE_LOCK_FILE);
    }
}

