/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.crypto.tool;

import com.ibm.bi.crypto.tool.CliUtils;
import com.ibm.bi.crypto.tool.Config;
import com.ibm.bi.platform.commons.crypto.CAMCryptoException;
import com.ibm.bi.platform.commons.crypto.CAMCryptoRuntimeException;
import com.ibm.bi.platform.commons.crypto.CamCryptoMessageKeys;
import com.ibm.bi.platform.commons.crypto.internal.keystore.CAMKeyStore;
import com.ibm.bi.platform.commons.crypto.internal.keystore.CAMKeyStoreJKS;
import com.ibm.bi.platform.commons.crypto.internal.keystore.CAMKeyStorePKCS12;
import com.ibm.bi.platform.commons.crypto.internal.utils.CAMValidators;
import com.ibm.bi.platform.commons.crypto.internal.utils.CertificatesUtils;
import com.ibm.bi.platform.commons.crypto.internal.utils.CryptoParams;
import com.ibm.bi.platform.commons.crypto.internal.utils.FileLockResource;
import com.ibm.bi.platform.commons.crypto.internal.utils.KeysAndCertsGenerator;
import com.ibm.bi.platform.commons.crypto.internal.utils.KeysAndCertsLoader;
import com.ibm.bi.platform.commons.crypto.internal.utils.Tuples;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.cert.jcajce.JcaX500NameUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThirdPartyCertificateTool {
    public static final String SUCCESS = CliUtils.trimMsg(CamCryptoMessageKeys.success.buildMessage().getLocalizedMessage());
    public static final String FAILURE = CliUtils.trimMsg(CamCryptoMessageKeys.failure.buildMessage().getLocalizedMessage());
    public static final String THIRD_PARTY_TOOL_GENERIC_ERROR = CliUtils.trimMsg(CamCryptoMessageKeys.third_party_generic_error.buildMessage().getLocalizedMessage());
    private static final Logger LOGGER = LoggerFactory.getLogger(ThirdPartyCertificateTool.class);
    public static boolean EXIT_JVM = true;

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        lockFolder = new File(Config.CAM_KEYSTORE_LOCK_FILE).getParentFile();
        lockFolder.mkdirs();
        try {
            keyStoreLockResource = new FileLockResource(Config.CAM_KEYSTORE_LOCK_FILE);
            var3_4 = null;
            try {
                command = CliUtils.Command.fromArgs(args);
                switch (1.$SwitchMap$com$ibm$bi$crypto$tool$CliUtils$Command[command.ordinal()]) {
                    case 1: {
                        ThirdPartyCertificateTool.importPkiTargetCertificate(command);
                        ** break;
lbl13:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        ThirdPartyCertificateTool.importPkiTrustedCertificate(command);
                        ** break;
lbl17:
                        // 1 sources

                        break;
                    }
                    case 3: {
                        ThirdPartyCertificateTool.importPkiPrivateKeyUsingSeparateEntries(command);
                        ** break;
lbl21:
                        // 1 sources

                        break;
                    }
                    case 4: {
                        ThirdPartyCertificateTool.importPkiPrivateKeyFromPKCS12(command);
                        ** break;
lbl25:
                        // 1 sources

                        break;
                    }
                    case 5: {
                        ThirdPartyCertificateTool.exportPkiTargetCertificate(command);
                        ** break;
lbl29:
                        // 1 sources

                        break;
                    }
                    case 6: {
                        ThirdPartyCertificateTool.exportRootCACert(command);
                        ** break;
lbl33:
                        // 1 sources

                        break;
                    }
                    case 7: {
                        ThirdPartyCertificateTool.generateCertificateSigningRequestFromANewKeyPair(command);
                        break;
                    }
                    ** default:
lbl38:
                    // 1 sources

                    break;
                }
            }
            catch (Throwable var4_8) {
                var3_4 = var4_8;
                throw var4_8;
            }
            finally {
                if (keyStoreLockResource != null) {
                    if (var3_4 != null) {
                        try {
                            keyStoreLockResource.close();
                        }
                        catch (Throwable var4_7) {
                            var3_4.addSuppressed(var4_7);
                        }
                    } else {
                        keyStoreLockResource.close();
                    }
                }
            }
        }
        catch (CAMCryptoException | CAMCryptoRuntimeException e) {
            cryptoException = ThirdPartyCertificateTool.toCAMCryptoException(e);
            if (cryptoException != null && !((CAMCryptoException)e).getMessageKey().equals(CamCryptoMessageKeys.could_not_parse_command)) {
                CliUtils.printlnInfo(CliUtils.trimMsg(ThirdPartyCertificateTool.errorMessage(cryptoException)));
            } else {
                CliUtils.printHelp();
            }
            ThirdPartyCertificateTool.LOGGER.error("Exception", e);
        }
        if (ThirdPartyCertificateTool.EXIT_JVM) {
            System.exit(0);
        }
    }

    private static void importPkiTargetCertificate(CliUtils.Command command) {
        try {
            PrivateKey targetPrivateKey;
            char[] keyStorePassword = ThirdPartyCertificateTool.cliKeyStorePasswordOrElseDefault(command);
            String targetCertLocation = command.optionValue(CliUtils.CmdOption.CERT_LOCATION);
            String certChainLocation = command.optionValue(CliUtils.CmdOption.CERT_CHAIN_LOCATION);
            X509Certificate targetCertificate = KeysAndCertsLoader.certificateFromPemEncodedX509(ThirdPartyCertificateTool.fileInputStream(targetCertLocation));
            List<X509Certificate> certChain = KeysAndCertsLoader.tryToLoadCertificatesFromSimpleResource(ThirdPartyCertificateTool.fileInputStream(certChainLocation));
            Certificate[] certChainStartingWithTarget = ThirdPartyCertificateTool.fullCertChain(targetCertificate, certChain);
            CliUtils.printlnInfo(CliUtils.trimMsg(CamCryptoMessageKeys.importing_target_cert_info.buildMessage(CertificatesUtils.certChainToString(certChainStartingWithTarget)).getLocalizedMessage()));
            CAMKeyStorePKCS12 camKeyStore = ThirdPartyCertificateTool.pkcs12CAMKeyStoreWithValidators(Config.PKCS12_CAM_KEYSTORE_FILE, keyStorePassword);
            X509Certificate olderTargetCertVersion = ThirdPartyCertificateTool.olderPKITrustedAndSelfSignedVersionOfTheTargetCert(camKeyStore, targetCertificate);
            if (olderTargetCertVersion != null) {
                CliUtils.printlnInfo("-->" + CliUtils.trimMsg(CamCryptoMessageKeys.deleting_older_cert_info.buildMessage(CertificatesUtils.certToString(olderTargetCertVersion)).getLocalizedMessage()));
                LOGGER.info("Deleting an older target certificate {}", (Object)CertificatesUtils.certToString(olderTargetCertVersion));
                camKeyStore.deleteTrustedCertificate(olderTargetCertVersion);
            }
            if ((targetPrivateKey = camKeyStore.getPrivateKey("encryption")) == null) {
                throw new CAMCryptoException(CamCryptoMessageKeys.no_encryption_entry.buildMessage());
            }
            ThirdPartyCertificateTool.importPrivateKeyAlongWithFullCertChain(camKeyStore, targetPrivateKey, (X509Certificate[])certChainStartingWithTarget);
        }
        catch (CAMCryptoException | CAMCryptoRuntimeException e) {
            LOGGER.info("Failure while importing a target certificate", e);
            ThirdPartyCertificateTool.handleKnownFailure(e);
        }
        catch (RuntimeException e) {
            LOGGER.info("Failure while importing a target certificate", e);
            CliUtils.printlnInfo(THIRD_PARTY_TOOL_GENERIC_ERROR);
            CliUtils.printlnInfo(FAILURE);
        }
    }

    private static void handleKnownFailure(Exception e) {
        CAMCryptoException cryptoException = ThirdPartyCertificateTool.toCAMCryptoException(e);
        CliUtils.printlnInfo(CliUtils.trimMsg(ThirdPartyCertificateTool.errorMessage(cryptoException)));
        CliUtils.printlnInfo(FAILURE);
    }

    private static CAMCryptoException toCAMCryptoException(Exception e) {
        CAMCryptoException cryptoException = null;
        cryptoException = e instanceof CAMCryptoRuntimeException ? (CAMCryptoException)e.getCause() : (CAMCryptoException)e;
        return cryptoException;
    }

    private static X509Certificate olderPKITrustedAndSelfSignedVersionOfTheTargetCert(CAMKeyStore camKeyStore, X509Certificate targetCertificate) throws CAMCryptoException {
        X509Certificate olderCert = ThirdPartyCertificateTool.olderPKITrustedAndSelfSignedTargetCert(camKeyStore);
        if (olderCert != null && JcaX500NameUtil.getSubject((X509Certificate)olderCert).equals((Object)JcaX500NameUtil.getSubject((X509Certificate)olderCert))) {
            return olderCert;
        }
        return null;
    }

    private static X509Certificate olderPKITrustedAndSelfSignedTargetCert(CAMKeyStore camKeyStore) throws CAMCryptoException {
        X509Certificate olderCert;
        Certificate[] certificateChain = camKeyStore.getCertificateChain("encryption");
        if (certificateChain != null && certificateChain.length == 1 && CertificatesUtils.isCertSelfSigned(olderCert = (X509Certificate)certificateChain[0]) && camKeyStore.getTrustedCertificates().contains(olderCert)) {
            return olderCert;
        }
        return null;
    }

    private static void importPkiTrustedCertificate(CliUtils.Command command) {
        try {
            char[] keyStorePassword = ThirdPartyCertificateTool.cliKeyStorePasswordOrElseDefault(command);
            String certLocation = command.optionValue(CliUtils.CmdOption.CERT_LOCATION);
            X509Certificate certificate = KeysAndCertsLoader.certificateFromPemEncodedX509(ThirdPartyCertificateTool.fileInputStream(certLocation));
            CliUtils.printlnInfo(CliUtils.trimMsg(CamCryptoMessageKeys.importing_trusted_cert_info.buildMessage(CertificatesUtils.certToString(certificate)).getLocalizedMessage()));
            LOGGER.info("Importing trusted certificate {}", (Object)CertificatesUtils.certToString(certificate));
            CAMKeyStorePKCS12 camKeyStorePKCS12 = ThirdPartyCertificateTool.pkcs12CAMKeyStoreWithValidators(Config.PKCS12_CAM_KEYSTORE_FILE, keyStorePassword);
            LOGGER.info("Checking if {} already belongs to trust store {}", (Object)CertificatesUtils.certToString(certificate), (Object)CertificatesUtils.certChainToString(camKeyStorePKCS12.getTrustedCertificates().toArray(new Certificate[0])));
            if (!camKeyStorePKCS12.getTrustedCertificates().contains(certificate)) {
                camKeyStorePKCS12.addTrustedCertificate(ThirdPartyCertificateTool.trustedCertAlias(camKeyStorePKCS12, certificate), certificate);
                CAMKeyStoreJKS camKeyStoreJKS = camKeyStorePKCS12.toJksCAMKeyStoreWithNoValidations(Config.JKS_CAM_KEYSTORE_FILE);
                camKeyStorePKCS12.persist();
                camKeyStoreJKS.persist();
                CliUtils.printlnInfo(SUCCESS);
            } else {
                CliUtils.printlnInfo(CliUtils.trimMsg(CamCryptoMessageKeys.cert_already_exists.buildMessage().getLocalizedMessage()));
            }
        }
        catch (CAMCryptoException | CAMCryptoRuntimeException e) {
            LOGGER.info("Failure while importing a trusted certificate", e);
            ThirdPartyCertificateTool.handleKnownFailure(e);
        }
        catch (RuntimeException e) {
            LOGGER.info("Failure while importing a trusted certificate", e);
            CliUtils.printlnInfo(THIRD_PARTY_TOOL_GENERIC_ERROR);
            CliUtils.printlnInfo(FAILURE);
        }
    }

    private static String errorMessage(CAMCryptoException e) {
        return ThirdPartyCertificateTool.localizedMessage(e).orElse(CamCryptoMessageKeys.third_party_generic_error.buildMessage().getLocalizedMessage());
    }

    private static Optional<String> localizedMessage(CAMCryptoException e) {
        String locMessage = null;
        try {
            locMessage = CliUtils.trimMsg(e.getLocalizedMessage());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Optional.ofNullable(locMessage);
    }

    private static void importPkiPrivateKeyUsingSeparateEntries(CliUtils.Command command) {
        try {
            char[] keyStorePassword = ThirdPartyCertificateTool.cliKeyStorePasswordOrElseDefault(command);
            String privateKeyLocation = command.optionValue(CliUtils.CmdOption.PRIVATE_KEY_LOCATION);
            String targetCertificateLocation = command.optionValue(CliUtils.CmdOption.CERT_LOCATION);
            String certChainLocation = command.optionValue(CliUtils.CmdOption.CERT_CHAIN_LOCATION);
            String cryptoAlgorithm = command.optionValue(CliUtils.CmdOption.CRYPTO_ALGORITHM);
            char[] keySourcePassword = command.optionValue(CliUtils.CmdOption.KEY_SOURCE_PASSWORD).toCharArray();
            PrivateKey privateKey = KeysAndCertsLoader.privateKeyFromPEMEncodedPKCS8Encrypted(ThirdPartyCertificateTool.fileInputStream(privateKeyLocation), keySourcePassword, cryptoAlgorithm);
            X509Certificate targetCertificate = KeysAndCertsLoader.certificateFromPemEncodedX509(ThirdPartyCertificateTool.fileInputStream(targetCertificateLocation));
            List<X509Certificate> certChain = KeysAndCertsLoader.tryToLoadCertificatesFromSimpleResource(ThirdPartyCertificateTool.fileInputStream(certChainLocation));
            Certificate[] certChainStartingWithTarget = ThirdPartyCertificateTool.fullCertChain(targetCertificate, certChain);
            CliUtils.printlnInfo(CliUtils.trimMsg(CamCryptoMessageKeys.importing_private_key_info.buildMessage(cryptoAlgorithm, CertificatesUtils.certChainToString(certChainStartingWithTarget)).getLocalizedMessage()));
            ThirdPartyCertificateTool.importPrivateKeyAlongWithFullCertChain(keyStorePassword, privateKey, (X509Certificate[])certChainStartingWithTarget);
        }
        catch (CAMCryptoException | CAMCryptoRuntimeException e) {
            LOGGER.info("Failure while importing a private key", e);
            ThirdPartyCertificateTool.handleKnownFailure(e);
        }
        catch (RuntimeException e) {
            LOGGER.info("Failure while importing a private key", e);
            CliUtils.printlnInfo(THIRD_PARTY_TOOL_GENERIC_ERROR);
            CliUtils.printlnInfo(FAILURE);
        }
    }

    private static char[] cliKeyStorePasswordOrElseDefault(CliUtils.Command command) {
        try {
            return command.optionValue(CliUtils.CmdOption.KEY_STORE_PASSWORD).toCharArray();
        }
        catch (Throwable t) {
            return Config.CA_KEYSTORE_DEFAULT_PASSWORD;
        }
    }

    private static X509Certificate[] fullCertChain(X509Certificate targetCertificate, List<X509Certificate> certChain) {
        X509Certificate[] certChainStartingWithTarget = null;
        certChainStartingWithTarget = ThirdPartyCertificateTool.targetMayBeAlsoTheTrustAnchor(targetCertificate, certChain) ? (X509Certificate[])certChain.stream().toArray(X509Certificate[]::new) : (X509Certificate[])Stream.concat(Stream.of(targetCertificate), certChain.stream()).toArray(X509Certificate[]::new);
        return certChainStartingWithTarget;
    }

    private static boolean targetMayBeAlsoTheTrustAnchor(X509Certificate targetCertificate, List<X509Certificate> certChain) {
        return certChain.size() == 1 && certChain.get(0).equals(targetCertificate);
    }

    private static void importPrivateKeyAlongWithFullCertChain(char[] keyStorePassword, PrivateKey privateKey, X509Certificate[] fullCertChain) throws CAMCryptoException {
        CAMKeyStorePKCS12 camKeyStore = ThirdPartyCertificateTool.pkcs12CAMKeyStoreWithValidators(Config.PKCS12_CAM_KEYSTORE_FILE, keyStorePassword);
        ThirdPartyCertificateTool.importPrivateKeyAlongWithFullCertChain(camKeyStore, privateKey, fullCertChain);
    }

    private static void importPrivateKeyAlongWithFullCertChain(CAMKeyStore camKeyStorePKCS12, PrivateKey privateKey, X509Certificate[] fullCertChain) throws CAMCryptoException {
        try {
            LOGGER.info("Importing private key and certificates target/chain {}", (Object)CertificatesUtils.certChainToString(fullCertChain));
            camKeyStorePKCS12.addPrivateKeyWithCertChain("encryption", privateKey, fullCertChain);
        }
        catch (CAMCryptoException e) {
            if (ThirdPartyCertificateTool.isCertChainNotValidException(e)) {
                LOGGER.info("Given cert chain {} is not valid according to the current settings", (Object)CertificatesUtils.certChainToString(fullCertChain));
                CliUtils.printlnInfo(CliUtils.trimMsg(CamCryptoMessageKeys.given_chain_not_valid_info.buildMessage().getLocalizedMessage()));
                Certificate[] certChainToBeUsed = ThirdPartyCertificateTool.induceChainAndAskToUseIt(camKeyStorePKCS12, fullCertChain[0], Arrays.stream(fullCertChain).skip(1L).collect(Collectors.toList()));
                camKeyStorePKCS12.addPrivateKeyWithCertChain("encryption", privateKey, certChainToBeUsed);
            }
            throw e;
        }
        CAMKeyStoreJKS camKeyStoreJKS = ((CAMKeyStorePKCS12)camKeyStorePKCS12).toJksCAMKeyStoreWithNoValidations(Config.JKS_CAM_KEYSTORE_FILE);
        camKeyStorePKCS12.persist();
        camKeyStoreJKS.persist();
        CliUtils.printlnInfo(SUCCESS);
    }

    private static CAMKeyStorePKCS12 pkcs12CAMKeyStoreWithValidators(String path, char[] keyStorePassword) throws CAMCryptoException {
        CAMKeyStore camKeyStore = CAMKeyStore.newInstance("pkcs12", path, keyStorePassword);
        camKeyStore.addPrivateKeyValidators(CAMValidators.PRIVATE_KEY_MIN_LENGTH_VALIDATOR);
        camKeyStore.addKeyPairValidators(CAMValidators.KEY_PAIR_MATCH_VALIDATOR);
        camKeyStore.addCertificateValidators(CAMValidators.CERTIFICATE_VALIDATOR);
        camKeyStore.addCertChainValidators(CAMValidators.certificateChainPkixValidator(camKeyStore));
        return (CAMKeyStorePKCS12)camKeyStore;
    }

    private static boolean isCertChainNotValidException(CAMCryptoException e) {
        return CamCryptoMessageKeys.cert_chain_not_valid.equals(e.getMessageKey());
    }

    private static X509Certificate[] induceChainAndAskToUseIt(CAMKeyStore camKeyStore, X509Certificate targetCertificate, List<X509Certificate> certChain) throws CAMCryptoException {
        Set<X509Certificate> trustAnchors = camKeyStore.getTrustedCertificates();
        X509Certificate[] inducedCertChain = CertificatesUtils.buildPkixValidCertChain(targetCertificate, certChain, trustAnchors);
        CliUtils.YesNoAnswer isInducedChainToBeUsed = CliUtils.askYesNoQuestion(ThirdPartyCertificateTool.doYouWantToUseTheInducedChainQuestion(inducedCertChain));
        if (isInducedChainToBeUsed == CliUtils.YesNoAnswer.YES) {
            return inducedCertChain;
        }
        throw new CAMCryptoException(null);
    }

    private static String doYouWantToUseTheInducedChainQuestion(X509Certificate[] inducedChain) {
        return CamCryptoMessageKeys.induced_chain_question.buildMessage(CertificatesUtils.certChainToString(inducedChain)).getLocalizedMessage();
    }

    private static void importPkiPrivateKeyFromPKCS12(CliUtils.Command command) {
        try {
            char[] keyStorePassword = ThirdPartyCertificateTool.cliKeyStorePasswordOrElseDefault(command);
            String pkcs12Location = command.optionValue(CliUtils.CmdOption.PKCS12_KEY_CERTS_LOCATION);
            String cryptoAlgorithm = command.optionValue(CliUtils.CmdOption.CRYPTO_ALGORITHM);
            char[] keySourcePassword = command.optionValue(CliUtils.CmdOption.KEY_SOURCE_PASSWORD).toCharArray();
            InputStream pkcs12Source = ThirdPartyCertificateTool.fileInputStream(pkcs12Location);
            Tuples.Tuple2<PrivateKey, List<X509Certificate>> privateKeyCertChainTuple = ThirdPartyCertificateTool.privateKeyAndCertChainFromPkcs12ThatMayHaveManyAliases(pkcs12Source, keySourcePassword, cryptoAlgorithm);
            PrivateKey privateKey = (PrivateKey)privateKeyCertChainTuple._1;
            Certificate[] fullCertChain = ((List)privateKeyCertChainTuple._2).toArray(new X509Certificate[0]);
            CliUtils.printlnInfo(CliUtils.trimMsg(CamCryptoMessageKeys.importing_private_key_info.buildMessage(cryptoAlgorithm, CertificatesUtils.certChainToString(fullCertChain)).getLocalizedMessage()));
            ThirdPartyCertificateTool.importPrivateKeyAlongWithFullCertChain(keyStorePassword, privateKey, (X509Certificate[])fullCertChain);
        }
        catch (CAMCryptoException | CAMCryptoRuntimeException e) {
            LOGGER.info("Failure while importing a private key", e);
            ThirdPartyCertificateTool.handleKnownFailure(e);
        }
        catch (RuntimeException e) {
            LOGGER.info("Failure while importing a private key", e);
            CliUtils.printlnInfo(THIRD_PARTY_TOOL_GENERIC_ERROR);
            CliUtils.printlnInfo(FAILURE);
        }
    }

    private static void exportPkiTargetCertificate(CliUtils.Command command) {
        String resourceType = CliUtils.trimMsg(CamCryptoMessageKeys.target_certificate.buildMessage().getLocalizedMessage());
        try {
            char[] keyStorePassword = ThirdPartyCertificateTool.cliKeyStorePasswordOrElseDefault(command);
            String certDestination = command.optionValue(CliUtils.CmdOption.CERT_LOCATION);
            CAMKeyStorePKCS12 camKeyStore = ThirdPartyCertificateTool.pkcs12CAMKeyStoreWithValidators(Config.PKCS12_CAM_KEYSTORE_FILE, keyStorePassword);
            Certificate targetCertificate = camKeyStore.getTargetCertificate("encryption");
            CliUtils.printlnInfo("Exporting " + resourceType + CertificatesUtils.certToString(targetCertificate));
            LOGGER.info("Exporting {} {}", (Object)resourceType, (Object)CertificatesUtils.certToString(targetCertificate));
            if (targetCertificate != null) {
                byte[] targetCertPemContent = KeysAndCertsGenerator.pemEncodedCertificateContent(targetCertificate);
                ThirdPartyCertificateTool.saveContentToFile(resourceType, targetCertPemContent, certDestination);
                CliUtils.printlnInfo(SUCCESS);
            } else {
                CliUtils.printlnInfo(CliUtils.trimMsg(CamCryptoMessageKeys.resource_not_available.buildMessage(resourceType).getLocalizedMessage()));
            }
        }
        catch (CAMCryptoException | CAMCryptoRuntimeException e) {
            LOGGER.info("Failure while exporting the target certificateencryption", e);
            ThirdPartyCertificateTool.handleKnownFailure(e);
        }
        catch (RuntimeException e) {
            LOGGER.info("Failure while exporting the target certificateencryption", e);
            CliUtils.printlnInfo(THIRD_PARTY_TOOL_GENERIC_ERROR);
            CliUtils.printlnInfo(FAILURE);
        }
    }

    private static void exportRootCACert(CliUtils.Command command) {
        String resourceType = CliUtils.trimMsg(CamCryptoMessageKeys.ca_certificate.buildMessage().getLocalizedMessage());
        try {
            char[] keyStorePassword = ThirdPartyCertificateTool.cliKeyStorePasswordOrElseDefault(command);
            String certDestination = command.optionValue(CliUtils.CmdOption.CERT_LOCATION);
            CAMKeyStorePKCS12 camKeyStore = ThirdPartyCertificateTool.pkcs12CAMKeyStoreWithValidators(Config.PKCS12_CAM_KEYSTORE_FILE, keyStorePassword);
            Certificate targetCertificate = Stream.of(camKeyStore.getTargetCertificate("ca"), camKeyStore.getTrustedCertificate("ca")).filter(certificate -> certificate != null).findFirst().orElse(null);
            CliUtils.printlnInfo("Exporting " + resourceType + CertificatesUtils.certToString(targetCertificate));
            LOGGER.info("Exporting {} {}", (Object)resourceType, (Object)CertificatesUtils.certToString(targetCertificate));
            if (targetCertificate != null) {
                byte[] targetCertPemContent = KeysAndCertsGenerator.pemEncodedCertificateContent(targetCertificate);
                ThirdPartyCertificateTool.saveContentToFile(resourceType, targetCertPemContent, certDestination);
                CliUtils.printlnInfo(SUCCESS);
            } else {
                CliUtils.printlnInfo(CliUtils.trimMsg(CamCryptoMessageKeys.resource_not_available.buildMessage(resourceType).getLocalizedMessage()));
            }
        }
        catch (CAMCryptoException | CAMCryptoRuntimeException e) {
            LOGGER.info("Failure while exporting the target certificateca", e);
            ThirdPartyCertificateTool.handleKnownFailure(e);
        }
        catch (RuntimeException e) {
            LOGGER.info("Failure while exporting the target certificateca", e);
            CliUtils.printlnInfo(THIRD_PARTY_TOOL_GENERIC_ERROR);
            CliUtils.printlnInfo(FAILURE);
        }
    }

    private static void generateCertificateSigningRequestFromANewKeyPair(CliUtils.Command command) {
        try {
            char[] keyStorePassword = ThirdPartyCertificateTool.cliKeyStorePasswordOrElseDefault(command);
            String distinguishedName = command.optionValue(CliUtils.CmdOption.DISTINGUISHED_NAME);
            String cryptoAlgorithm = command.optionValue(CliUtils.CmdOption.CRYPTO_ALGORITHM);
            String csrDestination = command.optionValue(CliUtils.CmdOption.CSR_LOCATION);
            String subjectAlternativeNameDnsNames = command.optionValue(CliUtils.CmdOption.SUBJECT_ALTERNATIVE_NAME_DNS_NAMES);
            String subjectAlternativeNameEmailAddresses = command.optionValue(CliUtils.CmdOption.SUBJECT_ALTERNATIVE_NAME_EMAIL_ADDRESSES);
            String subjectAlternativeNameIpAddresses = command.optionValue(CliUtils.CmdOption.SUBJECT_ALTERNATIVE_NAME_IP_ADDRESSES);
            X500Principal principal = ThirdPartyCertificateTool.x500Principal(distinguishedName);
            KeyPair keyPair = KeysAndCertsGenerator.newKeyPair(cryptoAlgorithm, CryptoParams.getInstance().keyLength(cryptoAlgorithm));
            CAMKeyStorePKCS12 camKeyStorePKCS12 = ThirdPartyCertificateTool.pkcs12CAMKeyStoreWithValidators(Config.PKCS12_CAM_KEYSTORE_FILE, keyStorePassword);
            CliUtils.printlnInfo(CliUtils.trimMsg(CamCryptoMessageKeys.generating_csr_info.buildMessage(principal.getName()).getLocalizedMessage()));
            LOGGER.info("Generating certificate request for {}", (Object)principal.getName());
            X509Certificate olderTrustedPKICert = ThirdPartyCertificateTool.olderPKITrustedAndSelfSignedTargetCert(camKeyStorePKCS12);
            if (olderTrustedPKICert != null) {
                CliUtils.printlnInfo("-->" + CliUtils.trimMsg(CamCryptoMessageKeys.deleting_older_cert_info.buildMessage(CertificatesUtils.certToString(olderTrustedPKICert)).getLocalizedMessage()));
                LOGGER.info("Removing an old encryption self-signed target certificate {}", (Object)CertificatesUtils.certToString(olderTrustedPKICert));
                camKeyStorePKCS12.deleteTrustedCertificate(olderTrustedPKICert);
            }
            X509Certificate selfSignedPKICert = KeysAndCertsGenerator.selfSignedCertificate(principal, keyPair.getPrivate(), keyPair.getPublic(), CryptoParams.getInstance().signatureAlgorithm(cryptoAlgorithm), 30);
            LOGGER.info("Adding generated {} private key and trusted certificate {}", (Object)cryptoAlgorithm, (Object)CertificatesUtils.certToString(selfSignedPKICert));
            CliUtils.printlnInfo("-->" + CliUtils.trimMsg(CamCryptoMessageKeys.adding_generated_private_key_info.buildMessage(cryptoAlgorithm, CertificatesUtils.certToString(selfSignedPKICert)).getLocalizedMessage()));
            String alias = ThirdPartyCertificateTool.trustedCertAlias(camKeyStorePKCS12, selfSignedPKICert);
            camKeyStorePKCS12.addTrustedCertificate(alias, selfSignedPKICert);
            camKeyStorePKCS12.addPrivateKeyWithCertChain("encryption", keyPair.getPrivate(), (Certificate[])Stream.of(selfSignedPKICert).toArray(Certificate[]::new));
            byte[] csrContent = KeysAndCertsGenerator.certificateRequestPkcs10PemEncoded(principal, subjectAlternativeNameDnsNames, subjectAlternativeNameIpAddresses, subjectAlternativeNameEmailAddresses, keyPair.getPrivate(), keyPair.getPublic(), CryptoParams.getInstance().signatureAlgorithm(cryptoAlgorithm));
            ThirdPartyCertificateTool.saveContentToFile("CSR", csrContent, csrDestination);
            CAMKeyStoreJKS camKeyStoreJKS = camKeyStorePKCS12.toJksCAMKeyStoreWithNoValidations(Config.JKS_CAM_KEYSTORE_FILE);
            camKeyStorePKCS12.persist();
            camKeyStoreJKS.persist();
            CliUtils.printlnInfo(SUCCESS);
        }
        catch (CAMCryptoException | CAMCryptoRuntimeException e) {
            LOGGER.info("Failure while generating certificate request", e);
            ThirdPartyCertificateTool.handleKnownFailure(e);
        }
        catch (RuntimeException e) {
            LOGGER.info("Failure while generating certificate request", e);
            CliUtils.printlnInfo(THIRD_PARTY_TOOL_GENERIC_ERROR);
            CliUtils.printlnInfo(FAILURE);
        }
    }

    private static String trustedCertAlias(CAMKeyStore camKeyStore, X509Certificate selfSignedPKICert) throws CAMCryptoException {
        try {
            String basicAlias = selfSignedPKICert.getSubjectDN().getName() + ";" + selfSignedPKICert.getSerialNumber().toString();
            basicAlias.replaceAll("\\s+", "");
            if (camKeyStore.aliases().contains(basicAlias)) {
                basicAlias = basicAlias + "_" + UUID.randomUUID();
            }
            return basicAlias.toLowerCase();
        }
        catch (RuntimeException e) {
            return "trust_" + UUID.randomUUID().toString().toLowerCase();
        }
    }

    private static void saveContentToFile(String contentType, byte[] content, String destination) throws CAMCryptoException {
        try {
            File csrFile = new File(destination);
            if (csrFile.exists() && csrFile.delete()) {
                csrFile.createNewFile();
            }
            FileUtils.writeByteArrayToFile(csrFile, content);
        }
        catch (Throwable t) {
            throw new CAMCryptoException(t, CamCryptoMessageKeys.could_not_save_content.buildMessage(contentType, destination));
        }
    }

    private static X500Principal x500Principal(String distinguishedName) throws CAMCryptoException {
        try {
            return new X500Principal(distinguishedName);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new CAMCryptoException(e, CamCryptoMessageKeys.could_not_parse_dn.buildMessage(distinguishedName));
        }
    }

    private static InputStream fileInputStream(String filePath) throws CAMCryptoException {
        try {
            return FileUtils.openInputStream(new File(filePath));
        }
        catch (IOException e) {
            throw new CAMCryptoException(e, CamCryptoMessageKeys.could_not_find_file.buildMessage(filePath));
        }
    }

    private static Tuples.Tuple2<PrivateKey, List<X509Certificate>> privateKeyAndCertChainFromPkcs12ThatMayHaveManyAliases(InputStream pkcs12Source, char[] pkcs12Password, String cryptoAlgorithm) throws CAMCryptoException {
        try {
            byte[] pkcs12AsBytes = IOUtils.toByteArray(pkcs12Source);
            List<String> availableAliases = KeysAndCertsLoader.keyEntriesAliasesFromPKCS12(new ByteArrayInputStream(pkcs12AsBytes), pkcs12Password);
            if (availableAliases != null && !availableAliases.isEmpty()) {
                String alias;
                availableAliases.sort(String.CASE_INSENSITIVE_ORDER);
                if (availableAliases.size() == 1) {
                    return new Tuples.Tuple2<PrivateKey, List<X509Certificate>>(KeysAndCertsLoader.privateKeyFromPKCS12(new ByteArrayInputStream(pkcs12AsBytes), availableAliases.get(0), pkcs12Password, cryptoAlgorithm), KeysAndCertsLoader.certificatesFromPKCS12(new ByteArrayInputStream(pkcs12AsBytes), availableAliases.get(0), pkcs12Password));
                }
                while (!availableAliases.contains(alias = CliUtils.askForInfo(CliUtils.trimMsg(CamCryptoMessageKeys.specify_alias.buildMessage(availableAliases.stream().collect(Collectors.joining(","))).getLocalizedMessage())))) {
                }
                return new Tuples.Tuple2<PrivateKey, List<X509Certificate>>(KeysAndCertsLoader.privateKeyFromPKCS12(new ByteArrayInputStream(pkcs12AsBytes), alias, pkcs12Password, cryptoAlgorithm), KeysAndCertsLoader.certificatesFromPKCS12(new ByteArrayInputStream(pkcs12AsBytes), alias, pkcs12Password));
            }
        }
        catch (IOException e) {
            throw new CAMCryptoException(e, CamCryptoMessageKeys.could_not_load_keystore_general.buildMessage());
        }
        throw new CAMCryptoException(null);
    }
}

