/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.health;

import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckFilter;
import com.codahale.metrics.health.SharedHealthCheckRegistries;
import com.codahale.metrics.json.HealthCheckModule;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.platform.commons.crypto.CAMCryptoException;
import com.ibm.bi.platform.commons.crypto.JCAMCrypto;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.http.entity.ContentType;

@WebServlet(name="BIHealthServlet", urlPatterns={"/health"})
public class BIHealthServlet
extends HttpServlet {
    private static final long serialVersionUID = -6576320598016097124L;
    private ObjectMapper mapper;
    private String contextName;
    private HealthCheckFilter hcFilter;
    private ExecutorService exec = null;
    private Set<String> overrideHealth = new HashSet<String>();

    public void init(ServletConfig config) throws ServletException {
        this.mapper = new ObjectMapper().registerModule(new HealthCheckModule());
        this.contextName = StringUtils.substring(config.getServletContext().getContextPath(), 1);
        this.hcFilter = new HealthCheckFilter(){

            public boolean matches(String name, HealthCheck healthCheck) {
                if (StringUtils.equals("bi", BIHealthServlet.this.contextName)) {
                    return true;
                }
                return StringUtils.equals(BIHealthServlet.this.contextName, name);
            }
        };
        this.exec = (ExecutorService)config.getServletContext().getAttribute("execSvc");
        RESTClientFactory.getInstance().startup(this.contextName);
    }

    public void destroy() {
        super.destroy();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean isHealthy = true;
        SortedMap<String, HealthCheck.Result> results = this.runHealthChecks(this.exec);
        resp.setContentType(ContentType.APPLICATION_JSON.toString());
        resp.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        if (results.isEmpty()) {
            resp.setStatus(501);
            return;
        }
        isHealthy = this.isAllHealthy(results);
        if (isHealthy) {
            resp.setStatus(200);
        } else {
            resp.setStatus(503);
        }
        if (this.isSysAdminOrTrusted(req)) {
            String queryParam = req.getParameter("sick");
            if (queryParam != null) {
                this.setUpOverrides(queryParam);
                resp.getWriter().println("{\"set to unhealthy\": \"" + queryParam + "\"}");
                return;
            }
            this.writeDetails(req, resp, results);
        } else {
            String msg = isHealthy ? "{\"healthy\":true}" : "{\"healthy\":false}";
            resp.getWriter().println(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setUpOverrides(String queryParam) {
        if (queryParam == null) {
            return;
        }
        Set<String> set = this.overrideHealth;
        synchronized (set) {
            if (StringUtils.isBlank(queryParam)) {
                this.overrideHealth.clear();
                return;
            }
            this.overrideHealth.addAll(Arrays.asList(queryParam.split("\\s*,\\s*")));
        }
    }

    void writeDetails(HttpServletRequest req, HttpServletResponse resp, SortedMap<String, HealthCheck.Result> results) throws IOException {
        try (ServletOutputStream output = resp.getOutputStream();){
            this.getWriter(req).writeValue((OutputStream)output, results);
        }
    }

    boolean isSysAdminOrTrusted(HttpServletRequest req) {
        String trustHeader = req.getHeader("X-CA-Authorization");
        if (StringUtils.isNotBlank(trustHeader)) {
            return this.isValidTrustHeader(trustHeader);
        }
        return this.isSysAdmin(req);
    }

    boolean isValidTrustHeader(String trustHeader) {
        try {
            return StringUtils.equals("health-check", JCAMCrypto.createTrustedRequestSession().getServiceIDAndVerifyToken(trustHeader));
        }
        catch (CAMCryptoException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isSysAdmin(HttpServletRequest req) {
        try {
            String pp = this.getPassportCookie(req);
            if (StringUtils.isBlank(pp)) {
                return false;
            }
            try (RESTClient client = this.getRESTClient(req);){
                JsonObject me = client.getResource("/bi/v1/me", ContentType.APPLICATION_JSON.toString());
                boolean bl = me.getBoolean("isSystemAdmin");
                return bl;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    RESTClient getRESTClient(HttpServletRequest req) {
        return RESTClientFactory.getInstance().getClient(req);
    }

    String getPassportCookie(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!StringUtils.equals(cookie.getName(), "cam_passport")) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    private ObjectWriter getWriter(HttpServletRequest request) {
        boolean prettyPrint = Boolean.parseBoolean(request.getParameter("pretty"));
        if (prettyPrint) {
            return this.mapper.writerWithDefaultPrettyPrinter();
        }
        return this.mapper.writer();
    }

    SortedMap<String, HealthCheck.Result> runHealthChecks(ExecutorService exec) {
        if (exec == null) {
            return new TreeMap<String, HealthCheck.Result>(SharedHealthCheckRegistries.getDefault().runHealthChecks(this.hcFilter));
        }
        return new TreeMap<String, HealthCheck.Result>(SharedHealthCheckRegistries.getDefault().runHealthChecks(exec, this.hcFilter));
    }

    boolean isAllHealthy(Map<String, HealthCheck.Result> results) {
        if (!this.overrideHealth.isEmpty()) {
            this.setOverrides(results);
        }
        for (HealthCheck.Result result : results.values()) {
            if (result.isHealthy()) continue;
            return false;
        }
        return true;
    }

    private void setOverrides(Map<String, HealthCheck.Result> results) {
        for (Map.Entry<String, HealthCheck.Result> entry : results.entrySet()) {
            if (!this.overrideHealth.contains(entry.getKey())) continue;
            results.put(entry.getKey(), HealthCheck.Result.unhealthy((String)"health override"));
        }
    }

    Set<String> getOverrideSet() {
        return this.overrideHealth;
    }
}

