/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.health;

import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.health.SharedHealthCheckRegistries;
import com.ibm.bi.health.DefaultHealthCheck;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
public class HealthContextListener
implements ServletContextListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(HealthContextListener.class);
    protected String contextName = null;
    protected ServletContext context;

    public void contextDestroyed(ServletContextEvent ctxEvent) {
        LOGGER.info("{} destroyed.", (Object)this.contextName);
    }

    public void contextInitialized(ServletContextEvent ctxEvent) {
        this.context = ctxEvent.getServletContext();
        if (StringUtils.isEmpty(this.contextName)) {
            this.contextName = StringUtils.substring(this.context.getContextPath(), 1);
        }
        if (!Boolean.getBoolean("disableHealthCheck")) {
            this.setHealthCheck(this.getHealthCheck());
        }
        LOGGER.info("{} initialized.", (Object)this.contextName);
    }

    protected HealthCheck getHealthCheck() {
        return new DefaultHealthCheck();
    }

    void setHealthCheck(HealthCheck healthCheck) {
        HealthCheckRegistry reg = this.getRegistry();
        HealthCheck existing = reg.getHealthCheck(this.contextName);
        if (existing != null) {
            if (!(healthCheck instanceof DefaultHealthCheck)) {
                reg.unregister(this.contextName);
            } else {
                return;
            }
        }
        reg.register(this.contextName, healthCheck);
    }

    HealthCheckRegistry getRegistry() {
        try {
            return SharedHealthCheckRegistries.getDefault();
        }
        catch (IllegalStateException e) {
            LOGGER.error("Default Health Registry not set!", e);
            throw e;
        }
    }
}

