/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.health;

import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.annotation.Async;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientConfig;
import com.ibm.bi.rest.RESTClientFactory;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Async(period=30L, scheduleType=Async.ScheduleType.FIXED_DELAY, initialState=Async.InitialState.HEALTHY, initialDelay=120L)
public class RemoteHealthCheck
extends HealthCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteHealthCheck.class);
    protected final String serviceName;
    protected final String url;
    private static final String HEALTHY = "healthy";
    private static final String MESSAGE = "message";

    public RemoteHealthCheck(String serviceName, String url) {
        this.serviceName = serviceName;
        this.url = url;
    }

    protected HealthCheck.Result check() throws Exception {
        return this.getRemoteResult();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    HealthCheck.Result getRemoteResult() throws IOException {
        try (RESTClient client = this.getClient();){
            client.makeTrusted("health-check");
            JsonObject response = client.getResource(this.url, "application/json");
            JsonObject result2 = response.containsKey(HEALTHY) ? response : response.getObject(this.serviceName);
            HealthCheck.ResultBuilder builder = this.getResultBuilder();
            if (result2 != null) {
                if (result2.containsKey(HEALTHY) && result2.getBoolean(HEALTHY).booleanValue()) {
                    builder.healthy();
                } else {
                    builder.unhealthy();
                }
                if (result2.containsKey(MESSAGE)) {
                    builder.withMessage(result2.getString(MESSAGE));
                }
                result2.keySet().forEach(k -> {
                    if (!StringUtils.equals(HEALTHY, k) && !StringUtils.equals(MESSAGE, k)) {
                        builder.withDetail(k, result2.get((String)k));
                    }
                });
            } else {
                builder.unhealthy().withMessage("Invalid JSON response from " + this.url).withDetail("response", (Object)response);
            }
            HealthCheck.Result result = builder.build();
            return result;
        }
        catch (IOException e) {
            LOGGER.error("Cannot contact {}", (Object)this.url);
            return this.getResultBuilder().unhealthy().withMessage("Cannot contact " + this.url).withDetail("error", (Object)e.getMessage()).build();
        }
    }

    HealthCheck.ResultBuilder getResultBuilder() {
        return HealthCheck.Result.builder();
    }

    RESTClient getClient() {
        return RESTClientFactory.getInstance().getClient(new RESTClientConfig());
    }
}

