/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.json;

import java.math.BigDecimal;
import java.math.BigInteger;

public class JsonNumber {
    private final Number value;

    public JsonNumber(Number value) {
        this.value = value;
    }

    public BigDecimal bigDecimalValue() {
        if (this.value instanceof BigDecimal) {
            return (BigDecimal)this.value;
        }
        if (this.value instanceof BigInteger) {
            return new BigDecimal((BigInteger)this.value);
        }
        return new BigDecimal(this.value.doubleValue());
    }

    public BigInteger bigIntegerValue() {
        if (this.value instanceof BigInteger) {
            return (BigInteger)this.value;
        }
        if (this.value instanceof BigDecimal) {
            return ((BigDecimal)this.value).toBigInteger();
        }
        return BigInteger.valueOf(this.value.longValue());
    }

    public long longValue() {
        return this.value.longValue();
    }

    public double doubleValue() {
        return this.value.doubleValue();
    }

    public boolean isIntegral() {
        if (this.value instanceof Long || this.value instanceof BigInteger) {
            return true;
        }
        if (this.value instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)this.value;
            return bd.signum() == 0 || bd.scale() <= 0 || bd.stripTrailingZeros().scale() <= 0;
        }
        double d = this.value.doubleValue();
        return d == Math.floor(d) && !Double.isInfinite(d);
    }

    public boolean equals(Object v) {
        if (v instanceof JsonNumber) {
            return this.value.equals(((JsonNumber)v).value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value.toString();
    }
}

