/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.json;

import com.ibm.bi.json.DefaultJsonFactory;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonNumber;
import com.ibm.bi.json.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JsonObject
extends HashMap<String, Object> {
    private static final long serialVersionUID = 2873521592918266683L;

    public JsonObject() {
    }

    public JsonObject(int size) {
        super(size);
    }

    public JsonObject(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public JsonObject(Map<String, ?> m) {
        super(m.size());
        this.putAll(m);
    }

    public <T> T get(String key) {
        return (T)super.get(key);
    }

    public Boolean getBoolean(String key) {
        return (Boolean)super.get(key);
    }

    public Long getLong(String key) {
        return (Long)super.get(key);
    }

    public Double getDouble(String key) {
        return (Double)super.get(key);
    }

    public String getString(String key) {
        return (String)super.get(key);
    }

    public JsonObject getObject(String key) {
        return (JsonObject)super.get(key);
    }

    public JsonArray getArray(String key) {
        return (JsonArray)super.get(key);
    }

    public Number getNumber(String key) {
        return (Number)super.get(key);
    }

    public BigInteger getBigInteger(String key) {
        return (BigInteger)super.get(key);
    }

    public BigDecimal getBigDecimal(String key) {
        return (BigDecimal)super.get(key);
    }

    public JsonNumber getJsonNumber(String key) {
        Number v = this.getNumber(key);
        return v != null ? new JsonNumber(v) : null;
    }

    @Override
    public void putAll(Map map) {
        if (map instanceof JsonObject) {
            super.putAll(map);
        } else {
            JsonObject.assertStringKeys(map);
            for (Map.Entry entry : map.entrySet()) {
                this.put((String)entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public Object put(String key, Object value) {
        return super.put(key, this.cast(value));
    }

    protected Object cast(Object value) {
        return JsonObject.toJson(value);
    }

    private static void assertStringKeys(Map obj) {
        Iterator iterator = obj.keySet().iterator();
        if (iterator.hasNext()) {
            Object key = iterator.next();
            if (!(key instanceof String)) {
                throw new IllegalArgumentException("Type " + key.getClass().getName() + " can't be converted to JSON");
            }
            return;
        }
    }

    public static Object toJson(Object obj) {
        if (obj == null || obj instanceof String || obj instanceof Boolean || obj instanceof Long || obj instanceof Double || obj instanceof BigInteger || obj instanceof BigDecimal || obj instanceof JsonArray || obj instanceof JsonObject) {
            return obj;
        }
        if (obj instanceof Float) {
            return (double)((Float)obj).floatValue();
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof List) {
            JsonArray result = new JsonArray();
            result.addAll((Collection<?>)((List)obj));
            return result;
        }
        if (obj instanceof Map) {
            JsonObject.assertStringKeys((Map)obj);
            JsonObject map = new JsonObject();
            map.putAll((Map)obj);
            return map;
        }
        throw new IllegalArgumentException("Type " + obj.getClass().getName() + " can't be converted to JSON");
    }

    public JsonObject set(String key, Object value) {
        this.put(key, value);
        return this;
    }

    @Override
    public String toString() {
        JsonWriter json = new JsonWriter(false);
        StringWriter writer = new StringWriter();
        try {
            json.write(writer, (Object)this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    public static JsonObject parseString(String s, boolean strict) throws IOException {
        return (JsonObject)DefaultJsonFactory.parseString(s, strict);
    }
}

